#include "dialog.h"
#include "dialog.m"

void fldmisc_required(){}	// To ease the link

class FIELD_IPNUM: public FIELD_SSTRING{
	int flags;
	/*~PROTOBEG~ FIELD_IPNUM */
public:
	FIELD_IPNUM (const char *_prompt, SSTRING&ip);
	int post_validate (void);
	/*~PROTOEND~ FIELD_IPNUM */
};

PUBLIC FIELD_IPNUM::FIELD_IPNUM (
	const char *_prompt,
	SSTRING &ip)
	: FIELD_SSTRING (_prompt,ip,17)
{
	flags = 0;
}

PUBLIC int FIELD_IPNUM::post_validate()
{
	int ret = FIELD_SSTRING::post_validate();
	if (ret != -1){
		if (buf[0] != '\0' && !ipnum_validip(buf,false)){
			xconf_error (MSG_U(E_IVLDIPNUM,"Invalid IP number: %s"),buf);
			ret = -1;
		}
	}
	return ret;
}


/*
	Define a field to input an IP number
*/
PUBLIC FIELD_SSTRING* DIALOG::newf_ipnum (
	const char *prompt,
	SSTRING &ip)
{
	FIELD_IPNUM *s = new FIELD_IPNUM (prompt,ip);
	add (s);
	return s;
}

