#include <stdlib.h>
#include <misc.h>
#include "dialog.h"
#include <proto.h>
#include "dialog.m"

class FIELD_BUTTON_PRIVATE{
public:
	SSTRING str;
	SSTRING icon;
	SSTRING help;	// Help text poping over the button
	DIALOG *dia;
	int no;			// no of the field in the dialog
	bool enter_action;	// Enter in the form trigger this button action
};

PROTECTED FIELD_BUTTON::FIELD_BUTTON (
	const char *_str,
	const char *_icon,
	const char *_help,
	PRIVATE_MESSAGE &_msg,
	bool enter_action,
	DIALOG *_dia)
	: FIELD (NULL)
{
	priv = new FIELD_BUTTON_PRIVATE;
	msg = &_msg;
	priv->str.setfrom (_str);
	priv->icon.setfrom (_icon);
	priv->help.setfrom (_help);
	priv->dia = _dia;
	priv->no = -1;	// We will learn our ID at dialog setup time
	priv->enter_action = enter_action;
}

PUBLIC FIELD_BUTTON::~FIELD_BUTTON ()
{
	delete priv;
}

PUBLIC MENU_STATUS FIELD_BUTTON::dokey(WINDOW *, int key, FIELD_MSG &, bool &)
{
	MENU_STATUS ret = MENU_NULL;
	if (key == ' '){
		dialog_sendmessage (*msg);
		ret = MENU_MESSAGE;
	}
	return ret;
}

PUBLIC void FIELD_BUTTON::set_registry_value(const char *)
{
}
PUBLIC const char *FIELD_BUTTON::get_registry_value()
{
	return NULL;
}


PUBLIC void FIELD_BUTTON::drawtxt(WINDOW *win, int)
{
	SSTRING s;
	if (!priv->str.is_empty()){
		s.setfromf("[%s]",priv->str.get());
	}else{
		// We present the icon name with the tag icon:
		s.setfromf("[%s:%s]",MSG_U(I_ICON,"Icon"),priv->icon.get());
	}
	diaetc_drawinput (win,box.x,box.y,box.width,s.get());
}


PUBLIC void FIELD_BUTTON::save(){}
PUBLIC void FIELD_BUTTON::restore(){}
PUBLIC void FIELD_BUTTON::reload(const char *, int ){}
PUBLIC void FIELD_BUTTON::html_draw(int){}
PUBLIC MENU_STATUS FIELD_BUTTON::gui_get(int nof, const char *, const char *actionid )
{
	MENU_STATUS ret = MENU_NULL;
	if (actionid[0] == 'B' && atoi(actionid+1)==200+nof){
		ret = MENU_MESSAGE;
	}
	return ret;
}
PUBLIC char FIELD_BUTTON::getidprefix (){return ' '; }
PUBLIC int  FIELD_BUTTON::html_validate(int ){ return 0;}


PUBLIC void FIELD_BUTTON::gui_draw(int nof, SSTRINGS &)
{
	priv->no = nof;
	const char *ic = priv->icon.get();
	int button_id = 200 + nof;
	if (ic[0] != '\0'){
		char sent[PATH_MAX];
		diagui_sendxpm (ic,sent);
		char tmp[1000];
		diagui_sendcmd (P_Button_xpm,"B%d %s $dump=1\n",button_id
			,diagui_quote(sent,tmp));
	}else{
		char tmp[1000];
		diagui_sendcmd (P_Button,"B%d 1 %s\n",button_id
			,diagui_quote(priv->str.get(),tmp));
	}
	if (priv->enter_action) diagui_sendcmd (P_Enteraction,"B%d\n",button_id);
}


PROTECTED void FIELD_BUTTON::sendval(const char *val)
{
	char tmp[200];
	const char *dianame = priv->dia->setguiname(tmp);
	if (dianame != NULL){
		char tmp[1000],tmp1[1000];
		diagui_sendcmd (P_Setval,"%s B%d %s\n"
				,formatpath (tmp1,dianame)
				,priv->no+200
				,diagui_quote(val,tmp));
	}
}



PUBLIC FIELD_BUTTON_TEXT::FIELD_BUTTON_TEXT (
	const char *_str,
	const char *_help,
	PRIVATE_MESSAGE &_msg,
	bool enter_action,
	DIALOG *_dia)
	: FIELD_BUTTON (_str,NULL,_help,_msg,enter_action,_dia)
{
}

/*
	Change the text of a button.
	If the GUI dialog is drawn, the change is made immediatly.
*/
PUBLIC void FIELD_BUTTON_TEXT::settext (const char *_str)
{
	if (priv->str.cmp(_str)!=0){
		priv->str.setfrom (_str);
		sendval (_str);
	}
}

/*
	Add a text button which will show up within the dialog area (wherever
	you want in fact, like any other field)

	See samples.cc: sample_extrabuttons()
*/
PUBLIC FIELD_BUTTON_TEXT *DIALOG::new_button (
	const char *str,	// Text of the button
	const char *help,	// bubble test over the icon, optional
	PRIVATE_MESSAGE &msg,
	bool enter_action)
{
	FIELD_BUTTON_TEXT *ret = new FIELD_BUTTON_TEXT (str,help,msg
		,enter_action,this);
	add (ret);
	return ret;
}

PUBLIC FIELD_BUTTON_TEXT *DIALOG::new_button (
	const char *str,	// Text of the button
	const char *help,	// bubble test over the icon, optional
	PRIVATE_MESSAGE &msg)
{
	return new_button(str,help,msg,false);
}


PUBLIC FIELD_BUTTON_ICON::FIELD_BUTTON_ICON (
	const char *_icon,
	const char *_help,
	PRIVATE_MESSAGE &_msg,
	bool enter_action,
	DIALOG *_dia)
	: FIELD_BUTTON (NULL,_icon,_help,_msg,enter_action,_dia)
{
}

/*
	Change the icon of button.
	If the GUI dialog is drawn, the change is made immediatly.
*/
PUBLIC void FIELD_BUTTON_ICON::seticon (const char *_icon)
{
	if (priv->icon.cmp(_icon)!=0){
		priv->icon.setfrom (_icon);
		char sent[PATH_MAX];
		diagui_sendxpm (_icon,sent);
		sendval (sent);
	}
}



/*
	Add an icon button which will show up within the dialog area (wherever
	you want in fact, like any other field)

	See samples.cc: sample_extrabuttons()
*/
PUBLIC FIELD_BUTTON_ICON *DIALOG::new_button_icon (
	const char *icon,		// icon name, correponding to a xpm file
	const char *help,		// bubble test over the icon, optional
	PRIVATE_MESSAGE &msg)
{
	FIELD_BUTTON_ICON *ret = new FIELD_BUTTON_ICON (icon,help,msg,false,this);
	add (ret);
	return ret;
}

class FIELD_INPUTGRID: public FIELD_BUTTON{
	int x;
	int y;
	int cellwidth;
	int cellheight;
	int nbcellh;
	int nbcellv;
	/*~PROTOBEG~ FIELD_INPUTGRID */
public:
	FIELD_INPUTGRID (int _x,
		 int _y,
		 int _cellwidth,
		 int _cellheight,
		 int _nbcellh,
		 int _nbcellv,
		 PRIVATE_MESSAGE&_msg,
		 DIALOG *_dia);
	void gui_draw (int nof, SSTRINGS&);
	/*~PROTOEND~ FIELD_INPUTGRID */
};
PUBLIC FIELD_INPUTGRID::FIELD_INPUTGRID(
	int _x,
	int _y,
	int _cellwidth,
	int _cellheight,
	int _nbcellh,
	int _nbcellv,
	PRIVATE_MESSAGE &_msg,
	DIALOG *_dia)
	: FIELD_BUTTON ("","","",_msg,false,_dia)
{
	x = _x;
	y = _y;
	cellwidth = _cellwidth;
	cellheight = _cellheight;
	nbcellh = _nbcellh;
	nbcellv = _nbcellv;
}

PUBLIC void FIELD_INPUTGRID::gui_draw(int nof, SSTRINGS &)
{
	priv->no = nof;
	diagui_sendcmd (P_Inputgrid,"B%d %d %d %d %d %d %d %s%s\n"
		,200+nof,x,y,cellwidth,cellheight,nbcellh,nbcellv
		,guiparms.is_empty() ? "" : " $"
		,guiparms.get());
}

/*
	Add an input grid.
	See samples.cc: sample_inputgrid()
*/
PUBLIC void DIALOG::new_inputgrid (
	int x,
	int y,
	int cellwidth,
	int cellheight,
	int nbcellh,
	int nbcellv,
	PRIVATE_MESSAGE &msg)
{
	FIELD_INPUTGRID *ret = new FIELD_INPUTGRID (x,y,cellwidth,cellheight
		,nbcellh,nbcellv,msg,this);
	add (ret);
}

