/*
 *  main.c  -- The Main Program.
 *
 *  Copyright (C) 1997-2005 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <getopt.h>

#include "interface.h"
#include "support.h"
#include "global.h"

GtkWidget 	*MainWindow;
GtkWidget	*ImportWindow;
int		debug = 0;

void
show_help(void)
{
  printf(_("\n------ linSmith %s ------\n"), prog_version);
  printf(_("(c) John Coppens 1997-2004\n\n"));
  printf(_("Usage:  linsmith [-d <opts>]\n\n"));
  printf(_("  -d    enables debugging:\n"));
  printf(_("     l    loads\n"));
  printf(_("     e    elements\n"));
  printf(_("     g    graphics\n"));
  printf(_("     p    printing\n"));
  printf(_("     m    math\n"));
  printf(_("     o    logging\n"));
  printf(_("   ?\n"));
  printf(_("   h    help (this text)\n"));
  gtk_exit(0);
}
        

void
check_params(int argc, char *argv[])
{
  int i, c;

  while ((i = getopt (argc, argv, "d:h?")) != EOF) {
    switch (i) {
      case 'd':
        for (c = 0; c < strlen(optarg); c++) {
          switch (optarg[c]) {
            case 'l': debug |= DBG_LOADS; break;
            case 'e': debug |= DBG_ELEMENTS; break;
	    case 'g': debug |= DBG_GRAPHICS; break;
	    case 'p': debug |= DBG_PRINTING; break;
	    case 'm': debug |= DBG_MATH; break;
            case 'o': debug |= DBG_LOGGING; break;
          }
        }
        break;
      case '?':
      case 'h':
        show_help();
        break;
    }
  }
}



int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  check_params(argc, argv);

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  MainWindow = create_MainWindow();
  gtk_widget_show(MainWindow);

  gtk_main ();
  return 0;
}

