/*****************************************************************************/
/* linleech - a program to selectively download usenet articles              */
/* Copyright (C) 1988  Curtiss Howard                                        */ 
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*****************************************************************************/

#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>

#include "linleech_socket.h"

FILE *CreateSock (int Socket)
{
	FILE *Fptr;
	
	printf ("linleech> Creating socket to read from... ");

	Fptr = fdopen (Socket, "r");

	if (!Fptr)
	{
		printf ("failure.\n");

		return NULL;
	}
	
	printf ("okay.\n");

	return Fptr;
}

int HostConnect (char *Host, unsigned short Port)
{
	struct sockaddr_in SA;
	struct hostent *HP;
	int S;
    
	if ((HP = gethostbyname (Host)) == NULL)
	{
		printf ("linleech> Couldn't resolve host.\n");
	
		return -1;
	}
    
	bzero (&SA, sizeof (SA));
    
	bcopy (HP->h_addr, (char *) &SA.sin_addr, HP->h_length);
    
	SA.sin_family = HP->h_addrtype;
	SA.sin_port = htons ((u_short) Port);
    
	if ((S = socket (HP->h_addrtype, SOCK_STREAM, 0)) < 0)
	{
		printf ("linleech> Couldn't create socket.\n");
	
		return -1;
	}
    
	if (connect (S, &SA, sizeof (SA)) < 0)
	{
		printf ("linleech> Couldn't connect to %s.\n", Host);
	
		close (S);
	
		return -1;
	}
    
	return S;
}
