/* linbox/field/modular-balanced.h
 * Copyright (C) 2010 LinBox
 * Written by Brice Boyer <brice.boyer@imag.fr>
 *
 * 
 * ========LICENCE========
 * This file is part of the library LinBox.
 * 
 * LinBox is free software: you can redistribute it and/or modify
 * it under the terms of the  GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * ========LICENCE========
 *.
 */

/** @file field/modular-balanced.h
 * @ingroup field
 * @brief Common header for any modular-balanced field.
 * Use <code>\#include<modular-balanced></code> to get access to any modular
 * balanced representation.
 */

#ifndef __LINBOX_modular_balanced_H
#define __LINBOX_modular_balanced_H

#include "linbox/field/Modular/modular-balanced-float.h"
#include "linbox/field/Modular/modular-balanced-double.h"
#include "linbox/field/Modular/modular-balanced-int32.h"
#ifdef __LINBOX_HAVE_INT64
#include "linbox/field/Modular/modular-balanced-int64.h"
#endif

#endif

// vim:sts=8:sw=8:ts=8:noet:sr:cino=>s,f0,{0,g0,(0,:0,t0,+0,=s
// Local Variables:
// mode: C++
// tab-width: 8
// indent-tabs-mode: nil
// c-basic-offset: 8
// End:

