/**
 * @file leak1.c Leakbug test.
 *
 * $Id: leak1.c,v 1.3 2001/05/19 08:29:39 chipx86 Exp $
 *
 * @Copyright (C) 2001 Christian Hammond. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <leakbug.h>

int
main(int argc, char **argv)
{
	int *int_ptr1, *int_ptr2;
	int int1;
	char *str1, *str2;

	int_ptr1 = (int *)malloc(sizeof(int));
	*int_ptr1 = 5;

	int_ptr2 = (int *)malloc(sizeof(int));
	*int_ptr2 = 10;

	int1 = 42;

	int_ptr1 = &int1;

	str1 = (char *)malloc(13 * sizeof(char));
	strcpy(str1, "Hello World!");

	str2 = strdup(str1);

	printf("int_ptr1 = %d\n", *int_ptr1);
	printf("int_ptr2 = %d\n", *int_ptr2);
	printf("str1 = %s\n", str1);
	printf("str2 = %s\n", str2);

	printf("Reallocating str1 to 15 bytes...\n");
	str1 = realloc(str1, 15);
	strcpy(str1, "Hello World!!");

	printf("str1 = %s\n", str1);

	free(int_ptr1);
	free(int_ptr2);
	free(str1);
/*	free(str2); */
	
	lbDumpLeaks();
	
	return 0;
}
