.TH CLANTR l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
CLANTR - return the value of the one norm, or the Frobenius norm, or the infinity norm, or the element of largest absolute value of a trapezoidal or triangular matrix A
.SH SYNOPSIS
.TP 14
REAL FUNCTION
CLANTR( NORM, UPLO, DIAG, M, N, A, LDA,
WORK )
.TP 14
.ti +4
CHARACTER
DIAG, NORM, UPLO
.TP 14
.ti +4
INTEGER
LDA, M, N
.TP 14
.ti +4
REAL
WORK( * )
.TP 14
.ti +4
COMPLEX
A( LDA, * )
.SH PURPOSE
CLANTR returns the value of the one norm, or the Frobenius norm, or the infinity norm, or the element of largest absolute value of a trapezoidal or triangular matrix A. 
.SH DESCRIPTION
CLANTR returns the value
.br

   CLANTR = ( max(abs(A(i,j))), NORM = 'M' or 'm'
.br
            (
.br
            ( norm1(A),         NORM = '1', 'O' or 'o'
.br
            (
.br
            ( normI(A),         NORM = 'I' or 'i'
.br
            (
.br
            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

where  norm1  denotes the  one norm of a matrix (maximum column sum),
normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
normF  denotes the  Frobenius norm of a matrix (square root of sum of
squares).  Note that  max(abs(A(i,j)))  is not a  matrix norm.

.SH ARGUMENTS
.TP 8
NORM    (input) CHARACTER*1
Specifies the value to be returned in CLANTR as described
above.
.TP 8
UPLO    (input) CHARACTER*1
Specifies whether the matrix A is upper or lower trapezoidal.
= 'U':  Upper trapezoidal
.br
= 'L':  Lower trapezoidal
Note that A is triangular instead of trapezoidal if M = N.
.TP 8
DIAG    (input) CHARACTER*1
Specifies whether or not the matrix A has unit diagonal.
= 'N':  Non-unit diagonal
.br
= 'U':  Unit diagonal
.TP 8
M       (input) INTEGER
The number of rows of the matrix A.  M >= 0, and if
UPLO = 'U', M <= N.  When M = 0, CLANTR is set to zero.
.TP 8
N       (input) INTEGER
The number of columns of the matrix A.  N >= 0, and if
UPLO = 'L', N <= M.  When N = 0, CLANTR is set to zero.
.TP 8
A       (input) COMPLEX array, dimension (LDA,N)
The trapezoidal matrix A (A is triangular if M = N).
If UPLO = 'U', the leading m by n upper trapezoidal part of
the array A contains the upper trapezoidal matrix, and the
strictly lower triangular part of A is not referenced.
If UPLO = 'L', the leading m by n lower trapezoidal part of
the array A contains the lower trapezoidal matrix, and the
strictly upper triangular part of A is not referenced.  Note
that when DIAG = 'U', the diagonal elements of A are not
referenced and are assumed to be one.
.TP 8
LDA     (input) INTEGER
The leading dimension of the array A.  LDA >= max(M,1).
.TP 8
WORK    (workspace) REAL array, dimension (LWORK),
where LWORK >= M when NORM = 'I'; otherwise, WORK is not
referenced.
