# !Hangul,Korean! -*-coding: euc-kr;-*-
#
sub isNC($$$)
{
	print STDERR "Does this terminal support Hangul?";
	print STDERR "(  Դϱ?)[y/N]";
	$a = <>;
	if ($a =~ /y|Y/) {
		return 1;
	} else {
		return 0;
	}
}

sub initialize()
{
	&Sub::addlist("locales");
	&Sub::addlist("manpages-ko");
	if (&Sub::isinstalled("xserver-.*")) {
		&Sub::addlist("ami");
		&Sub::addlist("hanterm");
		&Sub::addlist("xfonts-baekmuk");
	}
	if (&Sub::isinstalled("mutt")) {
		&Sub::addlist("lynx");
		&Sub::addlist("urlview");
	}
	$b = &Sub::select(
		"Please select the default Korean font.\n\n".
		"1:-*-gulim-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n".
		"2:-*-dotum-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n".
		"3:-*-roundgothic-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n".
		"4:-*-hyrgothic-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n\n",
		"Ʈ ѱƮ Ͻʽÿ.\n\n".
		"1:-*-gulim-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n".
		"2:-*-dotum-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n".
		"3:-*-roundgothic-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n".
		"4:-*-hyrgothic-*-r-normal--*-*-*-*-*-*-ksc5601.1987-1\n\n",
		4,1);
	$HFONT = "gulim";
	if ($b =~ /2/) {
		$HFONT = "dotum";
	}
	if ($b =~ /3/) {
		$HFONT = "roundgothic";
	}
	if ($b =~ /4/) {
		$HFONT = "hyrgothic";
	}
	$Sub::HFONT = $HFONT;

	$c = &Sub::noyes(
		"\nDo you use 3bulsic keyboard?\n",
		"\n ѱ Ű带 մϱ?");
	if ($c) {
		$HKBD = "3";
	} else {
		$HKBD = "2";
	}
	$Sub::HKBD = $HKBD;

	# ---------- record the preferences in ~/.Eterm/user.cfg ----------
	if ( ! (-f "$ENV{HOME}/.Eterm/user.cfg" || -f "$ENV{HOME}/.Eterm/themes/Eterm/user.cfg")) {
		$d = &Sub::yesno(
			"\n------- /home/alee/.Eterm/user.cfg --------\nSetting for Eterm.\n\nDo setting?",
			"\n------- /home/alee/.Eterm/user.cfg --------\nSetting for Eterm.\n\nϽðڽϱ?");
		if ($d) {
			if (! -e "$ENV{HOME}/.Eterm") {
				mkdir "$ENV{HOME}/.Eterm", 0700;
			}
			open USERCFG, ">$ENV{HOME}/.Eterm/user.cfg";
			print USERCFG "<Eterm-0.9>\n";
			print USERCFG "begin attributes\n";
			print USERCFG "  font default 1\n";
			print USERCFG "  font 0 -*-fixed-medium-r-normal--*-*-75-75-*-60-iso8859-1\n";
			print USERCFG "  font 1 -*-fixed-medium-r-normal--*-*-75-75-*-70-iso8859-1\n";
			print USERCFG "  font 2 -*-fixed-medium-r-normal--*-*-75-75-*-80-iso8859-1\n";
			print USERCFG "  font 3 -*-fixed-medium-r-normal--*-*-75-75-*-100-iso8859-1\n";
			print USERCFG "  font 4 -*-fixed-medium-r-normal--*-*-75-75-*-120-iso8859-1\n";
			print USERCFG "end attributes\n";
			print USERCFG "\n";
			print USERCFG "begin multichar\n";
			print USERCFG "  font 0 -*-$HFONT-medium-r-normal--12-120-75-75-*-120-ksc5601.1987-0\n";
			print USERCFG "  font 1 -*-$HFONT-medium-r-normal--14-140-75-75-*-140-ksc5601.1987-0\n";
			print USERCFG "  font 2 -*-$HFONT-medium-r-normal--16-160-75-75-*-160-ksc5601.1987-0\n";
			print USERCFG "  font 3 -*-$HFONT-medium-r-normal--20-200-75-75-*-200-ksc5601.1987-0\n";
			print USERCFG "  font 4 -*-$HFONT-medium-r-normal--24-240-75-75-*-240-ksc5601.1987-0\n";
			print USERCFG "  encoding euckr\n";
			print USERCFG "end multichar\n";
			print USERCFG "\n";
			print USERCFG "begin xim\n";
			print USERCFG "  input_method Ami\n";
			print USERCFG "  preedit_type OverTheSpot\n";
			print USERCFG "end xim\n";
			print USERCFG "\n";
			print USERCFG "begin actions\n";
			print USERCFG '  bind Ctrl minus to string "\e]50;#-"';
			print USERCFG "\n";
			print USERCFG '  bind Ctrl equal to string "\e]50;#+"';
			print USERCFG "\n";
			print USERCFG "end actions\n";
			print USERCFG "\n";
			print USERCFG "begin misc\n";
			print USERCFG "  term_name xterm\n";
			print USERCFG "end misc\n";
			close USERCFG;
		}
	}
}

# ---------------------------------------------------
# sourceset2displayset() is a subroutine to convert a 
# string from Source Character Codeset into Display 
# Character Codeset.
#
# This subroutine needs 'real' contents if the language
# (character set) has multiple codesets and a codeset
# for source code and a codeset to be displayed is
# different.
#
# For example, Japanese version converts from EUC-JP 
# into ISO-2022-JP because EUC-JP is the safest for
# source code and ISO-2022-JP is the safest to be
# displayed.
# ---------------------------------------------------
sub sourceset2displayset ($)
{
	return $_[0];
}

# ---------------------------------------------------
# analcode() is a subroutine to guess the codeset of
# string given by a parameter.  The meaning of the
# result value is same to convcode().
#
# This subroutine is used to detect the codeset of
# existing dotfiles because the additional contents
# have to be written in the same codeset to the
# existing contents.  Of course this subroutine
# is needed only for languages for which multiple
# codesets are used.
#
# The programmer for each language can determine
# the meaning of the return value of this subroutine.
# For example, Japanese version of analcode returns
# 'JIS' for ISO-2022-JP codeset, 'SJIS' for Shift-JIS
# codeset, and 'EUC' for EUC-JP codeset.
# ---------------------------------------------------
sub analcode($)
{
	return 0;
}

# ---------------------------------------------------
# Convert the given string from its codeset into the
# given codeset.  The string is given by the 1st 
# parameter and the codeset is given by the 2nd 
# parameter.  The actual value of the 2nd parameter
# has to be the same as the return value of analcode
# subroutine.
#
# This subroutine is used to write additional contents
# to dotfiles in proper codeset.  Of course this 
# subroutine is needed only for languages for which
# multiple codesets are used.
# ---------------------------------------------------
sub convcode($$)
{
	return $_[0];
}


%messages = (

# msgid
  "\nPush [Enter] key to End.\n" =>
# msgstr1 (in native language but in ASCII)
  "\nPush [Enter] key to End.\n\000".
# msgstr2 (in native language and in native character set: for
# example ISO-8859-1)
  "\n[Enter]Ű .\n" ,

# msgid
  "Now obtaining package list...\n" =>
# msgstr1 (in ASCII)
  "Now obtaining package list...\n\000".
# msgstr2 (in Native Character Set)
  "Ű Ʈ  Դϴ...\n" ,

# msgid
  "Do setting? " =>
# msgstr1 (in ASCII)
  "Do setting? \000".
# msgstr2 (in Native Character Set)
  "Ͻðڽϱ? " ,

# msgid
  "Setting is not done.\n" =>
# msgstr1 (ASCII)
  "Setting is not done.\n\000".
# msgstr2 (in Native Character Set)
  " Ϸ ʾҽϴ.\n" ,

# msgid
  "Do setting...\n" =>
# msgstr1 (ASCII)
  "Do setting...\n\000".
# msgstr2 (in Native Character Set)
  " ...\n" ,

# msgid
  "Cannot read \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot read \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"    ϴ.\n" ,

# msgid
  "Making a new file \"%s\"...\n" =>
# msgstr1 (ASCII)
  "Making a new file \"%s\"...\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"  ϴ.\n" ,

# msgid
  "Cannot open \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot open \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"    ϴ.\n" ,

# msgid
  "Cannot write to \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot write to \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\" Ͽ   ϴ.\n" ,

# msgid
  "Cannot lock \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot lock \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"    ϴ.\n" ,

# msgid
  "Cannot close \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot close \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"    ϴ.\n" ,

# msgid
  "Install the following packages.\n" =>
# msgstr1 (ASCII)
  "Install the following packages.\n\000".
# msgstr2 (in Native Character Set)
  " Ű ġϽʽÿ.\n" ,

#msgid
  "(Edit /etc/locale.gen and invoke locale-gen)\n" =>
# msgstr1 (ASCII)
  "(Edit /etc/locale.gen and invoke locale-gen)\n\000".
# msgstr2 (in Native Character Set)
  "(Edit /etc/locale.gen and invoke locale-gen)\n" ,

# msgid
  "   Setting is now done.  To activate these settings,\n".
  "logout and login.\n".
  "   Read each dotfile and confirm the modification.\n".
  "If you don't like the setting, modify directly or\n".
  "add overriding setting after 'language-env end' line.\n".
  "   Read /usr/share/doc/language-env/README.* for detail.\n" =>
# msgstr1 (ASCII)
  "   Setting is now done.  To activate these settings,\n".
  "logout and login.\n".
  "   Read each dotfile and confirm the modification.\n".
  "If you don't like the setting, modify directly or\n".
  "add overriding setting after 'language-env end' line.\n".
  "   Read /usr/share/doc/language-env/README.* for detail.\n\000".
# msgstr2 (in Native Character Set)
  "ѱ  ϴ. Ϸ ٽ αϽʽÿ.\n".
  " ϵ  Ǿ ȮϽʽÿ.\n".
  "     ϰų\n".
  "'language-env end' ޺κп ߰Ͻʽÿ.\n",

# msgid
  "Usage: set-language-env [options]\n".
  "  -l language : Specify language (otherwise choose from menu)\n".
  "  -h          : This help message\n".
  "  -v          : 'verbose mode'\n".
  "  -s          : Display list of supported languages and exit\n".
  "  -r          : Remove all settings\n".
  "  -N          : Never fork another set-language-env (for internal use)\n".
  "  -c          : Don't use native character set (for internal use)\n".
  "  -C          : Use native character set (for internal use)\n".
  "  -E          : Setting for /etc/skel directory (root user only)\n" =>
# msgstr1 (ASCII)
  "Usage: set-language-env [options]\n".
  "  -l language : Specify language (otherwise choose from menu)\n".
  "  -h          : This help message\n".
  "  -v          : 'verbose mode'\n".
  "  -s          : Display list of supported languages and exit\n".
  "  -r          : Remove all settings\n".
  "  -N          : Never fork another set-language-env (for internal use)\n".
  "  -c          : Don't use native character set (for internal use)\n".
  "  -C          : Use native character set (for internal use)\n".
  "  -E          : Setting for /etc/skel directory (root user only)\n\000".
# msgstr2 (in Native Character Set)
  "Usage: set-language-env [ɼ]\n".
  "  -l      :   (ϸ ޴ )\n".
  "  -h          : \n".
  "  -v          : 'ڼ(verbose) '\n".
  "  -s          : ϴ   \n".
  "  -r          :   \n".
  "  -N          : Never fork another set-language-env (for internal use)\n".
  "  -c          : Ƽ ڼ   (for internal use)\n".
  "  -C          : Ƽ ڼ  (for internal use)\n".
  "  -E          : /etc/skel 丮  (root ڸ )\n" ,

# msgid
  "Install the following locales.\n" =>
# msgstr1 (ASCII)
  "Install the following locales.\n\000".
# msgstr2 (in Native Character Set)
  "  ġϽʽÿ.\n" ,

# msgid
  "(Edit /etc/locale.gen and invoke locale-gen)\n" =>
# msgstr1 (ASCII)
  "(Edit /etc/locale.gen and invoke locale-gen)\n\000".
# msgstr2 (in Native Character Set)
  "(/etc/locale.gen    locale-gen Ͻʽÿ.)\n" ,

# msgid
  "" =>
# msgstr1 (ASCII)
  "\000".
# msgstr2 (in Native Character Set)
  ""

);

$yes_upper = "Y";
$yes_lower = "y";
$no_upper = "N";
$no_lower = "n";

$need_locale = 'ko_KR.eucKR(ko_KR.EUC-KR!EUC-KR)';
