/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: infodel.c,v 6.3 1999/05/25 22:08:00 kmeyer1 Exp $
 *
 *	Function:	- delete info key and associated value
 *	Accepts:	- info (inout)
 *			- key
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>
#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_delete(info, key)

MPI_Info		info;
char			*key;

{
	struct _infoent	search;			/* search element */
	struct _infoent	*found;			/* found key/value pair */
	int		keylen;		/* key length */

        lam_initerr_m();
	lam_setfunc_m(BLKMPIINFODEL);
	
	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	keylen = (key) ? strlen(key) : 0;
	if (keylen == 0 || keylen > MPI_MAX_INFO_KEY) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
					lam_mkerr(MPI_ERR_INFO_KEY, 0)));
	}

	strcpy(search.ie_key, key);

	if ((found = al_find(info->info_list, &search))) {
		if (found->ie_value) free(found->ie_value);
		if (al_delete(info->info_list, found) < 0) {
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
						lam_mkerr(MPI_ERR_INTERN, 0)));
		}
	} else {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODEL,
					lam_mkerr(MPI_ERR_INFO_NOKEY, 0)));
	}

        lam_resetfunc_m(BLKMPIINFODEL);
	return(MPI_SUCCESS);
}
