/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: infocreate.c,v 6.3 1999/05/25 22:08:00 kmeyer1 Exp $
 *
 *	Function:	- info object constructor
 *	Accepts:	- info (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>
#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * private functions
 */
static int		info_key_cmp();


int
MPI_Info_create(info)

MPI_Info		*info;

{
        lam_initerr_m();
	lam_setfunc_m(BLKMPIINFOCREATE);

	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((*info = (MPI_Info) malloc(sizeof(struct _info))) == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	(*info)->info_list = al_init(sizeof(struct _infoent), info_key_cmp);
	if ((*info)->info_list == 0) {
		free((char *) *info);
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOCREATE,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	(*info)->info_f77handle = -1;

        lam_resetfunc_m(BLKMPIINFOCREATE);
	return(MPI_SUCCESS);
}

/*
 *	info_key_cmp
 *
 *	Function:	- compare two info pairs by key
 *	Accepts:	- ptr to two pairs
 *	Returns:	- string comparison of keys
 */
static int
info_key_cmp(a, b)

struct _infoent	*a;
struct _infoent	*b;

{
	return(strcmp(a->ie_key, b->ie_key));
}
