/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: gincl.c,v 6.3 1999/05/25 22:07:55 kmeyer1 Exp $
 *
 *	Function:	- form a new group by inclusion
 *	Accepts:	- original group
 *			- # of processes
 *			- ranks 
 *			- ptr new group
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <terror.h>

int
MPI_Group_incl(g, n, ranks, png)

MPI_Group		g;
int			n;
int			*ranks;
MPI_Group		*png;

{
	int		i, j;
	int		*r;
	struct _proc	**pi, **pj;		/* processes in groups */
	MPI_Group	ng;			/* new group */

	lam_initerr_m();
	lam_setfunc_m(BLKMPIGROUPINCL);
/*
 * Check the arguments.
 */
	if (g == MPI_GROUP_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPINCL, lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if ((png == 0) || ((n > 0) && (ranks == 0))
			|| (n < 0) || (n > g->g_nprocs)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPINCL, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Handle the trivial cases.
 */
	if (n == 0) {
		*png = MPI_GROUP_EMPTY;
		MPI_GROUP_EMPTY->g_refcount++;
		lam_resetfunc_m(BLKMPIGROUPINCL);
		return(MPI_SUCCESS);
	}
/*
 * Allocate a new group.
 */
	ng = (MPI_Group) malloc((unsigned) sizeof(struct _group) +
					(n * sizeof(struct _proc *)));
	if (ng == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGROUPINCL, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*png = ng;
	ng->g_nprocs = n;
	ng->g_myrank = MPI_UNDEFINED;
	ng->g_refcount = 1;
	ng->g_f77handle = -1;
	ng->g_procs = (struct _proc **) ((char *) ng + sizeof(struct _group));
/*
 * Fill the new group processes.
 */
	pj = g->g_procs;

	for (i = 0, pi = ng->g_procs, r = ranks; i < n; ++i, ++pi, ++r) {

		if ((*r < 0) || (*r >= g->g_nprocs)
				|| (pj[*r]->p_mode & LAM_PFLAG)) {

			for (r = ranks, j = 0; j < i; ++j, ++r) {
				pj[*r]->p_mode &= ~LAM_PFLAG;
			}
			free((char *) ng);
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPIGROUPINCL,
						lam_mkerr(MPI_ERR_RANK, 0)));
		} else {
			*pi = pj[*r];
			pj[*r]->p_mode |= LAM_PFLAG;
		}
	}

	for (i = 0, pi = ng->g_procs; i < n; ++i, ++pi) {
		(*pi)->p_refcount++;
		(*pi)->p_mode &= ~LAM_PFLAG;
		if (*pi == lam_myproc) {
			ng->g_myrank = i;
		}
	}

	lam_resetfunc_m(BLKMPIGROUPINCL);
	return(MPI_SUCCESS);
}
