/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	$Id: typical.h,v 6.4 1999/07/29 21:07:39 jsquyres Exp $
 *
 *	Function:	- typically used constants and macros
 */

#ifndef _TYPICAL
#define _TYPICAL

/*
 * constants
 */
#ifndef FALSE
#define FALSE		0
#define TRUE		1
#endif

#ifndef ERROR
#define ERROR		-1
#endif

#define LAMERROR	-1

/*
 * macros
 */
#define LAM_max(a,b)	(((a) > (b)) ? (a) : (b))
#define LAM_min(a,b)	(((a) < (b)) ? (a) : (b))
#define LAM_isNullStr(s)	(*(s) == 0)

/*
 * synonyms
 */
typedef unsigned int	unint;

#endif
