/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: echod.c,v 6.4 1999/09/10 05:20:14 jsquyres Exp $
 * 
 *	Function:	- echo server
 *			- receives a message and echos it back to the sender
 *			- primarily a diagnostic tool
 *			- message size limited to MAXNMSGLEN
 */

#include <lam_config.h>

#include <events.h>
#include <ereq.h>
#include <net.h>
#include <preq.h>
#include <terror.h>

/*
 * local variables
 */
static char		msg[MAXNMSGLEN];	/* echo message */
static struct nmsg	nhead;			/* echo network message */

/*
 * global functions
 */
void			(*(e_init()))();
void			(*(echod()))();

/*
 *	e_init
 *
 *	Function:	- echod initialization
 */
void (*(
e_init()))()

{
/*
 * Attach to kernel.
 */
	if (lpattach("echod")) {
		lampanic("echod (lpattach)");
	}
/*
 * Receive first request.
 */
	LAM_ZERO_ME(nhead);
	memset(msg, -1, MAXNMSGLEN);
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = msg;

	if (nrecv(&nhead)) {
		panic("echod (nrecv)");
	}

	return((void (*)()) echod);
}

/*
 *	echod
 *
 *	Function:	- server loop
 *			- replies message & receives next request
 */
void
(*(echod()))()

{
	struct ereq	*request;		/* request from client */

	request = (struct ereq *) nhead.nh_data;
/*
 * Reply to the request.
 */
	nhead.nh_node = request->eq_node;
	nhead.nh_event = request->eq_event;
	nhead.nh_flags = NREEL;
	nhead.nh_msg = msg;

	if (nsend(&nhead)) {
		panic("echod (nsend)");
	}
/*
 * Receive a request.
 */
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = msg;

	if (nrecv(&nhead)) {
		panic("echod (nrecv)");
	}

	return((void (*)()) echod);
}
