/* src/mpi2c++_config.h.  Generated automatically by configure.  */
// -*- c++ -*-
//
// Copyright 1997-1999, University of Notre Dame.
// Authors:  Jeremy G. Siek, Michael P. McNally, Jeffery M. Squyres, 
//           Andrew Lumsdaine
//
// This file is part of the Notre Dame C++ bindings for MPI
//
// You should have received a copy of the License Agreement for the
// Notre Dame C++ bindings for MPI along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//

#ifndef _MPIPP_CONFIG_H
#define _MPIPP_CONFIG_H

#define _MPIPP_USEEXCEPTIONS_ 0
#define _MPIPP_DEBUG_         0

#define MPI2CPP_HAVE_BOOL     1 

#define MPI2CPP_SIZEOF_INT    4
#define SIZEOF_MPI2CPP_BOOL_T 1

#if MPI2CPP_SIZEOF_INT != SIZEOF_MPI2CPP_BOOL_T
#define _MPIPP_BOOL_NE_INT_   1
#else
#define _MPIPP_BOOL_NE_INT_   0
#endif

// Does our compiler support namespaces?
#define _MPIPP_USENAMESPACE_  1

// Compile for Profiling?
#define _MPIPP_PROFILING_     0

// What kind of signals do we have?
#define MPI2CPP_BSD_SIGNAL    0
#define MPI2CPP_SYSV_SIGNAL   1

// Is the ERR_PENDING constant defined?
#define MPI2CPP_HAVE_PENDING  0

// Can virtual functions return derived class instead
// of base class?
#define MPI2CPP_VIRTUAL_FUNC_RET      0

#if _MPIPP_PROFILING_
#define _REAL_MPI_ PMPI
#else
#define _REAL_MPI_ MPI
#endif

#if _MPIPP_USENAMESPACE_
#define _MPIPP_STATIC_
#define _MPIPP_EXTERN_ extern
#else
#define _MPIPP_STATIC_ static
#define _MPIPP_EXTERN_
#endif

#if MPI2CPP_HAVE_BOOL
typedef bool MPI2CPP_BOOL_T;
#define MPI2CPP_FALSE false
#define MPI2CPP_TRUE true
#else
enum MPI2CPP_BOOL_T { MPI2CPP_FALSE, MPI2CPP_TRUE };
#ifdef bool
/* #undef bool */
#endif
#ifdef false
/* #undef false */
#endif
#ifdef true
/* #undef true */
#endif
#define bool MPI2CPP_BOOL_T
#define false MPI2CPP_FALSE
#define true MPI2CPP_TRUE
#endif

#define MPI2CPP_BSD_SIGNAL 0
#define MPI2CPP_SYSV_SIGNAL 1

// Flags for FORTRAN, optional C, and optional Fortran datatypes

#define MPI2CPP_FORTRAN 0
#define MPI2CPP_ALL_OPTIONAL_FORTRAN 0
#define MPI2CPP_SOME_OPTIONAL_FORTRAN 0
#define MPI2CPP_OPTIONAL_C 0

//
// Architecture/OS's that will need flags in the test suite to
// ignore certain tests
//
 
#define MPI2CPP_LAM61 0
#define MPI2CPP_LAM62 0
#define MPI2CPP_LAM63 1
#define MPI2CPP_LAM64 0
#define MPI2CPP_LAMUNKNOWN 0
#define MPI2CPP_LAM (MPI2CPP_LAM61 | MPI2CPP_LAM62 | MPI2CPP_LAM63 | MPI2CPP_LAM64 | MPI2CPP_LAMUNKNWON)

#define MPI2CPP_MPICH1013 0
#define MPI2CPP_MPICH110 0
#define MPI2CPP_MPICH111 0
#define MPI2CPP_MPICH112 0
#define MPI2CPP_MPICHUNKNOWN 0
#define MPI2CPP_MPICH (MPI2CPP_MPICH1013 | MPI2CPP_MPICH110 | MPI2CPP_MPICH111 | MPI2CPP_MPICHUNKNOWN) 
#if MPI2CPP_MPICH
// Tell MPICH to use the right MPI_Handle_function definition
#define USE_STDARG
#endif
 
#define MPI2CPP_IBM21014 0
#define MPI2CPP_IBM21015 0
#define MPI2CPP_IBM21016 0
#define MPI2CPP_IBM21017 0
#define MPI2CPP_IBM21018 0
#define MPI2CPP_IBMUNKNOWN 0
#define MPI2CPP_IBM_SP (MPI2CPP_IBM21014 | MPI2CPP_IBM21015 | MPI2CPP_IBM21016 | MPI2CPP_IBM21017 | MPI2CPP_IBM21018 | MPI2CPP_IBMUNKNOWN)
 
#define MPI2CPP_SGI20 0
#define MPI2CPP_SGI30 0
#define MPI2CPP_SGIUNKNOWN 0

#define MPI2CPP_HPUX0102 0
#define MPI2CPP_HPUX0103 0
#define MPI2CPP_HPUX0105 0
#define MPI2CPP_HPUXUNKNOWN 0

#define MPI2CPP_CRAY 0
#define MPI2CPP_CRAY1104 0
#define MPI2CPP_CRAYUNKNOWN 0

#define MPI2CPP_G_PLUS_PLUS 0

#define MPI2CPP_ATTR int

// #$%@#%@#%@#% AIX!!!!

#define MPI2CPP_AIX 0

#endif
