#ifndef WRAPPERFACTORY_H
#define WRAPPERFACTORY_H

#include <qworkspace.h>
#include "MainWin.h"
#include "Worksheet.h"
#include "Style.h"
#include "Symbol.h"
#include "Label.h"
#include "Legend.h"
#include "Plot2DSimple.h"
#include "Plot2DSurface.h"
#include "Plot3D.h"
#include "PlotQWT3D.h"
#include "PlotPie.h"
#include "PlotPolar.h"
#include "PlotTernary.h"

#ifdef HAVE_QSA_FAC
#include <qswrapperfactory.h>
#endif

// wrapper
class PointWrapper : public QObject
{
	Q_OBJECT
public:
	PointWrapper(Point *v) : v(v) {}
public slots:
	void setPoint(double x, double y) { v->setPoint(x,y); }
	double X() { return v->X(); }
	void setX(double s) { v->setX(s); }
	double Y() { return v->Y(); }
	void setY(double s) { v->setY(s); }
	void setMasked(bool m=true) { v->setMasked(m); }
	bool Masked() { return v-Masked(); }
private:
	Point *v;
};

class ArrowWrapper : public QObject
{
	Q_OBJECT
public:
	ArrowWrapper(Arrow *v) : v(v) {}
public slots:
	bool Location() { return v->Location(); }
	void setLocation(bool l) { v->setLocation(l); }
	bool Enabled() { return v->Enabled(); }
	void setEnabled(bool b=true) { v->setEnabled(b); }
	double Length() { return v->Length(); }
	void setLength(double l) { v->setLength(l); }
	double Angle() { return v->Angle(); }
	void setAngle(double a) { v->setAngle(a); }
	bool Filled() { return v->Filled(); }
	void setFilled(bool f=true) { v->setFilled(f); }
	QColor fillColor() { return v->fillColor(); }
	void setFillColor(QColor c) { v->setFillColor(c); }
	void setFillColor(QString c) { v->setFillColor(QColor(c)); }
private:
	Arrow *v;
};

class LineWrapper : public QObject
{
	Q_OBJECT
public:
	LineWrapper(Line *v) : v(v) {}
public slots:
	Point startPoint() { return v->startPoint(); }
	Point endPoint() { return v->endPoint(); }
	void setStartPoint(double x, double y) { v->setStartPoint(x,y); }
	void setEndPoint(double x, double y) { v->setEndPoint(x,y); }
	int Width() { return v->Width(); }
	void setWidth(int w) { v->setWidth(w); }
	QColor Color() { return v->Color(); }
	void setColor(QColor c) { v->setColor(c); }
	void setColor(QString c) { v->setColor(QColor(c)); }
	Arrow* startArrow() { return v->startArrow(); }
	Arrow* endArrow() { return v->endArrow(); }
	void setStartArrow(Arrow *a) { v->setStartArrow(a); }
	void setEndArrow(Arrow *e) {  v->setEndArrow(e); }
private:
	Line *v;
};

class RectWrapper : public QObject
{
	Q_OBJECT
public:
	RectWrapper(Rect *v) : v(v) {}
public slots:
	Point startPoint() { return v->startPoint(); }
	Point endPoint() { return v->endPoint(); }
	void setStartPoint(double x, double y) { v->setStartPoint(x,y); }
	void setEndPoint(double x, double y) { v->setEndPoint(x,y); }
	int Width() { return v->Width(); }
	void setWidth(int w) { v->setWidth(w); }
	QColor Color() { return v->Color(); }
	void setColor(QColor c) { v->setColor(c); }
	void setColor(QString c) { v->setColor(QColor(c)); }
	QColor FillColor() { return v->FillColor(); }
	void setFillColor(QColor c) { v->setFillColor(c); }
	void setFillColor(QString c) { v->setFillColor(QColor(c)); }
	bool isFilled() { return v->isFilled(); }
	void setFilled(bool f=true) { v->setFilled(f); }
private:
	Rect *v;
};

class EllipseWrapper : public QObject
{
	Q_OBJECT
public:
	EllipseWrapper(Ellipse *v) : v(v) {}
public slots:
	Point startPoint() { return v->startPoint(); }
	Point endPoint() { return v->endPoint(); }
	void setStartPoint(double x, double y) { v->setStartPoint(x,y); }
	void setEndPoint(double x, double y) { v->setEndPoint(x,y); }
	int Width() { return v->Width(); }
	void setWidth(int w) { v->setWidth(w); }
	QColor Color() { return v->Color(); }
	void setColor(QColor c) { v->setColor(c); }
	void setColor(QString c) { v->setColor(QColor(c)); }
	QColor FillColor() { return v->FillColor(); }
	void setFillColor(QColor c) { v->setFillColor(c); }
	void setFillColor(QString c) { v->setFillColor(QColor(c)); }
	bool isFilled() { return v->isFilled(); }
	void setFilled(bool f=true) { v->setFilled(f); }
private:
	Ellipse *v;
};

class LImageWrapper : public QObject
{
	Q_OBJECT
public:
	LImageWrapper(LImage *v) : v(v) {}
public slots:
	Point Pos() { return v->Pos(); }
	void setPos(double x, double y) { v->setPos(x,y); }
	QString Name() { return v->Name(); }
	void setName(QString n) { v->setName(n); }
	double Scale() { return v->Scale(); }
	void setScale(double s) { v->setScale(s); }
	double Angle() { return v->Angle(); }
	void setAngle(double a) { v->setAngle(a); }
private:
	LImage *v;
};

class SymbolWrapper : public QObject
{
	Q_OBJECT
public:
	SymbolWrapper(Symbol *v) : v(v) {}
public slots:
	int Type() { return (int) v->Type(); }
	void setType(SType t) { v->setType(t); }
	void setType(int t) { v->setType((SType)t); }
	QColor Color() { return v->Color(); }
	void setColor(QColor c) { v->setColor(c); }
	void setColor(QString c) { v->setColor(QColor(c)); }
	int Size() { return v->Size(); }
	void setSize(int s) { v->setSize(s); }
	int Fill() { return (int) v->Fill(); }
	void setFill(FType f) { v->setFill(f); }
	void setFill(int f) { v->setFill((FType) f); }
	QColor FillColor() { return v->FillColor(); }
	void setFillColor(QColor fc) { v->setFillColor(fc); }
	void setFillColor(QString fc) { v->setFillColor(QColor(fc)); }
	int Brush() { return v->Brush();}
	void setBrush(int b) { v->setBrush(b); }
private:
	Symbol *v;
};

class StyleWrapper : public QObject
{
	Q_OBJECT
public:
	StyleWrapper(Style *v) : v(v) {}
public slots:
	int Type() { return v->Type(); }
	void setType(int t) { v->setType((StylesType)t); }
	QColor Color() { return v->Color(); }
	void setColor(QString c) { v->setColor(QColor(c)); }
	void setColor(QColor c) { v->setColor(c); }
	int Width() { return v->Width(); }
	void setWidth(int w) { v->setWidth(w); }
	int PenStyle() { return v->PenStyle(); }
	void setPenStyle(int p) { v->setPenStyle(p); }
	int Brush() { return v->Brush(); }
	void setBrush (int b) { v->setBrush(b); }
	bool isFilled() { return v->isFilled(); }
	void setFilled(int f) { v->setFilled(f); }
	QColor FillColor() { return v->FillColor(); }
	void setFillColor(QString c) { v->setFillColor(QColor(c)); }
	void setFillColor(QColor c) { v->setFillColor(c); }
	int BoxWidth() { return v->BoxWidth(); }
	void setBoxWidth(int b) { v->setBoxWidth(b); }
	bool AutoBoxWidth() { return v->AutoBoxWidth(); }
	void setAutoBoxWidth(bool b=true) { v->setAutoBoxWidth(b); }
private:
	Style *v;
};

class LRangeWrapper : public QObject
{
	Q_OBJECT
public:
	LRangeWrapper(LRange *v) : v(v) {}
public slots:
	double Diff() { return v->Diff(); }
	double rMin() { return v->rMin(); }
	double rMax() { return v->rMax(); }
	void setMin(double m) { v->setMin(m); }
	void setMax(double m) { v->setMax(m); }
	void setRange(double rmin=0, double rmax=1) { v->setRange(rmin,rmax); }
private:
	LRange *v;
};

class LabelWrapper : public QObject
{
	Q_OBJECT
public:
	LabelWrapper(Label *v) : v(v) {}
public slots:
	void setPosition(double X, double Y) { v->setPosition(X,Y); }
	double X() { return v->X(); }
	double Y() { return v->Y(); }
	QString Title() { return v->Title(); }		
	void setTitle(QString title) { v->setTitle(title); }
	void setColor(QColor color) { v->setColor(color); }
	void setColor(QString color) { v->setColor(QColor(color)); }
	QColor Color() { return v->Color(); }
	void setFont(QFont font) { v->setFont(font); }
	QFont Font() { return v->Font(); }
	void setBoxed(bool b=true) { v->setBoxed(b); }
	bool Boxed() { return v->Boxed(); }
	double Rotation() { return v->Rotation(); }
	void setRotation(double r) { v->setRotation(r); }
	bool isTeXLabel() { return v->isTeXLabel(); }
	void setTeXLabel(bool t) { v->setTeXLabel(t); }
private:
	Label *v;
};

class LegendWrapper : public QObject
{
	Q_OBJECT
public:
	LegendWrapper(Legend *v) : v(v) {}
public slots:
	void setFont(QFont font) { v->setFont(font); }
	QFont Font() { return v->Font(); }
	void enable(bool b=true) { v->enable(b); }
	bool Enabled() { return v->Enabled(); }
	void setPosition(double X, double Y) { v->setPosition(X,Y); }
	double X() { return v->X(); }
	double Y() { return v->Y(); }
	void enableBorder(bool b=true) { v->enableBorder(b); }
	bool BorderEnabled() { return v->BorderEnabled(); }
	void setColor(QColor c) { v->setColor(c); }
	void setColor(QString c) { v->setColor(c); }
	QColor Color() { return v->Color(); }
	void setTransparent(bool t=true) { v->setTransparent(t); }
	bool Transparent() { return v->Transparent(); }
	bool getOrientation() { return v->getOrientation(); }
	void setOrientation(bool o) { v->setOrientation(o); }
	int TicLabelLength() { return v->TicLabelLength(); }
	void setTicLabelLength(int l) { v->setTicLabelLength(l); }
private:
	Legend *v;
};

class AxisWrapper : public QObject
{
	Q_OBJECT
public:
	AxisWrapper(Axis *v) : v(v) {}
public slots:
	void Enable(bool b=true) { v->Enable(b); }	
	bool Enabled() { return v->Enabled(); }
	void setScale(TScale s) { v->setScale(s); }
	void setScale(int s) { v->setScale((TScale) s); }
	int Scale() { return (int) v->Scale(); }
	void setLabel(Label *label) { v->setLabel(label); }
	void setScaling(double s) { v->setScaling(s); }
	double Scaling() { return v->Scaling(); }
	void setShift(double s) { v->setShift(s); }
	double Shift() { return v->Shift(); }
	Label *getLabel() { return v->getLabel(); }
	Label *label() { return v->getLabel(); }

	bool tickType() { return v->tickType(); }
	void setTickType(bool t) { v->setTickType(t); } 
	bool tickLabelEnabled() { return v->tickLabelEnabled(); }
	void enableTickLabel(bool e=true) { v->enableTickLabel(e); } 
	void setTickLabelRotation(double r) { v->setTickLabelRotation(r); }
	double TickLabelRotation() { return v->TickLabelRotation(); }
	void setTickLabelPrefix(QString p) {v->setTickLabelPrefix(p); }
	QString TickLabelPrefix() { return v->TickLabelPrefix(); }
	void setTickLabelSuffix(QString s) { v->setTickLabelSuffix(s); }
	QString TickLabelSuffix() { return v->TickLabelSuffix(); }
	void setTickLabelFont(QFont a) { v->setTickLabelFont(a); }
	QFont TickLabelFont() { return v->TickLabelFont(); }
	void setTickColor(QColor col) { v->setTickColor(col); }
	void setTickColor(QString col) { v->setTickColor(QColor(col)); }
	QColor TickColor() { return v->TickColor(); }
	void setTickLabelColor(QColor col) { v->setTickLabelColor(col); }
	void setTickLabelColor(QString col) { v->setTickLabelColor(QColor(col)); }
	QColor TickLabelColor() { return v->TickLabelColor(); }
	void setTickLabelFormat(TFormat tmp) { v->setTickLabelFormat(tmp); }
	void setTickLabelFormat(int tmp) { v->setTickLabelFormat((TFormat) tmp); }
	int TickLabelFormat() { return  (int) v->TickLabelFormat(); }
	void setDateTimeFormat(QString f) { v->setDateTimeFormat(f); }
	QString DateTimeFormat() { return v->DateTimeFormat(); }
	void setTickLabelPrecision(int tmp) { v->setTickLabelPrecision(tmp); }
	int TickLabelPrecision() { return v->TickLabelPrecision(); }
	void setTickLabelPosition(int g) { v->setTickLabelPosition(g); }
	int TickLabelPosition() { return v->TickLabelPosition(); }
	
	void setMajorTicks(int t) { v->setMajorTicks(t); }
	double MajorTicks() { return v->MajorTicks(); }
	void setMinorTicks(int t) { v->setMinorTicks(t); }
	double MinorTicks() { return v->MinorTicks(); }
	void enableMajorTicks(bool b=true) { v->enableMajorTicks(b); }
	void enableMinorTicks(bool b=true) { v->enableMinorTicks(b); }
	bool MajorTicksEnabled() { return v->MajorTicksEnabled(); }
	bool MinorTicksEnabled() { return v->MinorTicksEnabled(); }
	void setTickPos(int tp) { v->setTickPos(tp); }
	int TickPos() { return v->TickPos(); }
	void setMajorTickWidth(int w) { v->setMajorTickWidth(w); }
	int majorTickWidth() { return v->majorTickWidth(); }
	void setMinorTickWidth(int w) { v->setMinorTickWidth(w); }
	int minorTickWidth() { return v->minorTickWidth(); }
	double majorTickLength() { return v->majorTickLength(); }
	void setMajorTickLength(double l) { v->setMajorTickLength(l); }
	double minorTickLength() { return v->minorTickLength(); }
	void setMinorTickLength(double l) { v->setMinorTickLength(l); }
	
	bool BorderEnabled() { return v->BorderEnabled(); }
	void enableBorder(bool b=true) { v->enableBorder(b); }
	void setBorderColor(QColor col) { v->setBorderColor(col); }
	void setBorderColor(QString col) { v->setBorderColor(QColor(col)); }
	QColor BorderColor() { return v->BorderColor(); }
	void setBorderWidth(int b) { v->setBorderWidth(b); }
	int borderWidth() { return v->borderWidth(); }

	bool MajorGridEnabled() { return v->MajorGridEnabled(); }
	void enableMajorGrid(bool b=true) { v->enableMajorGrid(b); }
	bool MinorGridEnabled() { return v->MinorGridEnabled(); }
	void enableMinorGrid(bool b=true) { v->enableMinorGrid(b); }
	void setMajorGridColor(QColor c) { v->setMajorGridColor(c); }
	void setMajorGridColor(QString c) { v->setMajorGridColor(QColor(c)); }
	QColor majorGridColor() { return v->majorGridColor(); }
	void setMinorGridColor(QColor c) { v->setMinorGridColor(c); }
	void setMinorGridColor(QString c) { v->setMinorGridColor(QColor(c)); }
	QColor minorGridColor() { return v->minorGridColor(); }
	void setMajorGridType(Qt::PenStyle t) { v->setMajorGridType(t); }
	Qt::PenStyle MajorGridType() { return v->MajorGridType(); }
	void setMinorGridType(Qt::PenStyle t) { v->setMinorGridType(t); }
	Qt::PenStyle MinorGridType() { return v->MinorGridType(); }
	void setMajorGridWidth(int w) { v->setMajorGridWidth(w); }
	int majorGridWidth() { return v->majorGridWidth(); }
	void setMinorGridWidth(int w) { v->setMinorGridWidth(w); }
	int minorGridWidth() { return v->minorGridWidth(); }
private:
	Axis *v;
};

class ErrorbarWrapper : public QObject
{
	Q_OBJECT
public:
	ErrorbarWrapper(Errorbar *v) : v(v) {}
public slots:
	QColor Color() { return v->Color(); }
	void setColor(QColor c) { v->setColor(c); }
	QColor BaseColor() { return v->BaseColor(); }
	void setBaseColor(QColor c) { v->setBaseColor(c); }
	int XSize() { return v->XSize(); }
	void setXSize(int s) { v->setXSize(s); }
	int YSize() { return v->YSize(); }
	void setYSize(int s) { v->setYSize(s); }
	Qt::PenStyle Style() { return v->Style(); }
	void setStyle(Qt::PenStyle p) { v->setStyle(p); }
	Qt::PenStyle BaseStyle() { return v->BaseStyle(); }
	void setBaseStyle(Qt::PenStyle p) { v->setBaseStyle(p); }
	int Width() { return v->Width(); }
	void setWidth(int w) { v->setWidth(w); }
	int BaseWidth() { return v->BaseWidth(); }
	void setBaseWidth(int w) { v->setBaseWidth(w); }
	int XType() { return (int) v->XType(); }
	void setXType(EType e) { v->setXType(e); }
	int YType() { return (int) v->YType(); }
	void setYType(EType e) { v->setYType(e); }
private:
	Errorbar *v;
};


class Plot2DSimpleWrapper : public QObject
{
	Q_OBJECT
public:
	Plot2DSimpleWrapper(Plot2DSimple *v) : v(v) {}
public slots:
	// from Plot.h
	Legend* getLegend() { return v->getLegend(); }
	Label* Title() { return v->Title(); }
	Axis *getAxis(int i) { return v->getAxis(i); }
	void setRange(LRange *r, int i) { v->setRange(r,i); }
	LRange* Range(int i) { return v->Range(i); }
	void setActRange(LRange *r, int i) { v->setActRange(r,i); } 
	LRange* ActRange(int i) { return v->ActRange(i); }
	void setRegionMin(double min) { v->setRegionMin(min); }
	void setRegionMax(double max) { v->setRegionMax(max); }
	void setRegion(double min, double max) { v->setRegion(min,max); }
	double RegionMin() {return v->RegionMin(); }
	double RegionMax() {return v->RegionMax(); }
	LRange *Region() { return v->Region(); }
	bool regionEnabled() { return v->regionEnabled(); }
	void enableRegion(bool e=true) { v->enableRegion(e); }
	void setRegionEnabled(bool e=true) { v->enableRegion(e); }
	
	bool marksEnabled() { return v->marksEnabled(); }		// marks
	void enableMarks(bool m=true) { v->enableMarks(m); }
	void setMarksEnabled(bool m=true) { v->enableMarks(m); }
	LRange *markX() { return v->markX(); }
	void setMarkX(LRange *l) { v->setMarkX(l); }
	LRange *markY() { return v->markY(); }
	void setMarkY(LRange *l) { v->setMarkY(l); }
	bool Fill() { return v->Fill(); }							// fill
	void setFill(bool f=true) { v->setFill(f); }
	void setFillType(int t) { v->setFillType(t); }
	int  FillType() { return v->FillType(); }
	int FillG1() { return v->FillG1(); }
	void setFillG1(int f) { v->setFillG1(f); }
	int FillG2() { return v->FillG2(); }
	void setFillG2(int f) { v->setFillG1(f); }
	QBrush FillBrush() { return v->FillBrush(); }
	void setFillBrush(QBrush b) { v->setFillBrush(b); }
	
	void setPosition(double x, double y) { v->setPosition(x,y);}
	Point Position() { return v->Position(); }
	void setSize(double x, double y) { v->setSize(x,y);}
	Point Size() { return v->Size(); }
	void enabledAspectRatio(bool a=true) { v->enableAspectRatio(a); }
	bool AspectRatioEnabled() { return v->AspectRatioEnabled(); }
	void autoScaleX() {v->autoScaleX();}
	void autoScaleY() {v->autoScaleY();}
	void autoScaleZ() {v->autoScaleZ();}
	void autoScaleAll() {v->autoScaleAll();}
	LRange *XRange() { return v->Range(0); }
	LRange *YRange() { return v->Range(1); }
	LRange *ZRange() { return v->Range(2); }
	void setXRange(double x1, double x2) {v->setXRange(x1,x2); }
	void setYRange(double y1, double y2) {v->setYRange(y1,y2); }
	void setZRange(double z1, double z2) {v->setZRange(z1,z2); }
	QColor Background() { return v->Background().color();}
	QColor graphBackground() { return v->graphBackground().color();}
	QBrush BackgroundBrush() { return v->Background();}
	QBrush graphBackgroundBrush() { return v->graphBackground();}
	void setBackground(QColor c) { v->setBackground(QBrush(c));}
	void setBackground(QBrush c) { v->setBackground(c);}
	void setBackground(QString c) { v->setBackground(QBrush(QColor(c)));}
	void setGraphBackground(QColor c) { v->setGraphBackground(QBrush(c));}
	void setGraphBackground(QBrush c) { v->setGraphBackground(c);}
	void setGraphBackground(QString c) { v->setGraphBackground(QBrush(QColor(c)));}
	
	bool Transparent() { return v->Transparent(); }
	void setTransparent(bool t) { v->setTransparent(t); }
	int ClipOffset() { return v->ClipOffset(); }
	void setClipOffset(int c) { v->setClipOffset(c);}
	double Baseline() { return v->Baseline(); }
	void setBaseline(double b) { v->setBaseline(b); }
	double XBaseline() { return v->XBaseline(); }
	void setXBaseline(double b) { v->setXBaseline(b); }
	bool BaselineEnabled() { return v->BaselineEnabled(); }
	bool XBaselineEnabled() { return v->XBaselineEnabled(); }
	void enableBaseline(bool e=true) { v->enableBaseline(e); }
	void setBaselineEnabled(bool e=true) { v->enableBaseline(e); }
	void enableXBaseline(bool e=true) { v->enableXBaseline(e); }
	void setXBaselineEnabled(bool e=true) { v->enableXBaseline(e); }
private:
	Plot2DSimple *v;
};

class Plot2DSurfaceWrapper : public QObject
{
	Q_OBJECT
public:
	Plot2DSurfaceWrapper(Plot2DSurface *v) : v(v) {}
public slots:
	// from Plot.h
	Legend* getLegend() { return v->getLegend(); }
	Label* Title() { return v->Title(); }
	Axis *getAxis(int i) { return v->getAxis(i); }
	void setRange(LRange *r, int i) { v->setRange(r,i); }
	LRange* Range(int i) { return v->Range(i); }
	void setActRange(LRange *r, int i) { v->setActRange(r,i); } 
	LRange* ActRange(int i) { return v->ActRange(i); }
	void setRegionMin(double min) { v->setRegionMin(min); }
	void setRegionMax(double max) { v->setRegionMax(max); }
	void setRegion(double min, double max) { v->setRegion(min,max); }
	double RegionMin() {return v->RegionMin(); }
	double RegionMax() {return v->RegionMax(); }
	LRange *Region() { return v->Region(); }
	bool regionEnabled() { return v->regionEnabled(); }
	void enableRegion(bool e=true) { v->enableRegion(e); }
	void setRegionEnabled(bool e=true) { v->enableRegion(e); }
	
	bool marksEnabled() { return v->marksEnabled(); }
	void enableMarks(bool m=true) { v->enableMarks(m); }
	void setMarksEnabled(bool m=true) { v->enableMarks(m); }
	LRange *markX() { return v->markX(); }
	void setMarkX(LRange *l) { v->setMarkX(l); }
	LRange *markY() { return v->markY(); }
	void setMarkY(LRange *l) { v->setMarkY(l); }
	
	void setPosition(double x, double y) { v->setPosition(x,y);}
	Point Position() { return v->Position(); }
	void setSize(double x, double y) { v->setSize(x,y);}
	Point Size() { return v->Size(); }
	void enabledAspectRatio(bool a=true) { v->enableAspectRatio(a); }
	bool AspectRatioEnabled() { return v->AspectRatioEnabled(); }
	void autoScaleX() {v->autoScaleX();}
	void autoScaleY() {v->autoScaleY();}
	void autoScaleZ() {v->autoScaleZ();}
	void autoScaleAll() {v->autoScaleAll();}
	LRange *XRange() { return v->Range(0); }
	LRange *YRange() { return v->Range(1); }
	LRange *ZRange() { return v->Range(2); }
	void setXRange(double x1, double x2) {v->setXRange(x1,x2); }
	void setYRange(double y1, double y2) {v->setYRange(y1,y2); }
	void setZRange(double z1, double z2) {v->setZRange(z1,z2); }
	QColor Background() { return v->Background().color();}
	QColor graphBackground() { return v->graphBackground().color();}
	QBrush BackgroundBrush() { return v->Background();}
	QBrush graphBackgroundBrush() { return v->graphBackground();}
	void setBackground(QColor c) { v->setBackground(QBrush(c));}
	void setBackground(QBrush c) { v->setBackground(c);}
	void setBackground(QString c) { v->setBackground(QBrush(QColor(c)));}
	void setGraphBackground(QColor c) { v->setGraphBackground(QBrush(c));}
	void setGraphBackground(QBrush c) { v->setGraphBackground(c);}
	void setGraphBackground(QString c) { v->setGraphBackground(QBrush(QColor(c)));}
	
	void enableXBaseline(bool e=true) { v->enableXBaseline(e); }
	void setXBaselineEnabled(bool e=true) { v->enableXBaseline(e); }
	bool Transparent() { return v->Transparent(); }
	void setTransparent(bool t) { v->setTransparent(t); }
	int ClipOffset() { return v->ClipOffset(); }
	void setClipOffset(int c) { v->setClipOffset(c);}
	double Baseline() { return v->Baseline(); }
	void setBaseline(double b) { v->setBaseline(b); }
	double XBaseline() { return v->XBaseline(); }
	void setXBaseline(double b) { v->setXBaseline(b); }
	bool BaselineEnabled() { return v->BaselineEnabled(); }
	bool XBaselineEnabled() { return v->XBaselineEnabled(); }
	void enableBaseline(bool e=true) { v->enableBaseline(e); }
	void setBaselineEnabled(bool e=true) { v->enableBaseline(e); }
private:
	Plot2DSurface *v;
};

class Plot3DWrapper : public QObject
{
	Q_OBJECT
public:
	Plot3DWrapper(Plot3D *v) : v(v) {}
public slots:
	// from Plot.h
	Legend* getLegend() { return v->getLegend(); }
	Label* Title() { return v->Title(); }
	Axis *getAxis(int i) { return v->getAxis(i); }
	void setRange(LRange *r, int i) { v->setRange(r,i); }
	LRange* Range(int i) { return v->Range(i); }
	void setActRange(LRange *r, int i) { v->setActRange(r,i); } 
	LRange* ActRange(int i) { return v->ActRange(i); }
	void setRegionMin(double min) { v->setRegionMin(min); }
	void setRegionMax(double max) { v->setRegionMax(max); }
	void setRegion(double min, double max) { v->setRegion(min,max); }
	double RegionMin() {return v->RegionMin(); }
	double RegionMax() {return v->RegionMax(); }
	LRange *Region() { return v->Region(); }
	bool regionEnabled() { return v->regionEnabled(); }
	void enableRegion(bool e=true) { v->enableRegion(e); }
	void setRegionEnabled(bool e=true) { v->enableRegion(e); }
	
	bool marksEnabled() { return v->marksEnabled(); }
	void enableMarks(bool m=true) { v->enableMarks(m); }
	void setMarksEnabled(bool m=true) { v->enableMarks(m); }
	LRange *markX() { return v->markX(); }
	void setMarkX(LRange *l) { v->setMarkX(l); }
	LRange *markY() { return v->markY(); }
	void setMarkY(LRange *l) { v->setMarkY(l); }
	
	void setPosition(double x, double y) { v->setPosition(x,y);}
	Point Position() { return v->Position(); }
	void setSize(double x, double y) { v->setSize(x,y);}
	Point Size() { return v->Size(); }
	void enabledAspectRatio(bool a=true) { v->enableAspectRatio(a); }
	bool AspectRatioEnabled() { return v->AspectRatioEnabled(); }
	void autoScaleX() {v->autoScaleX();}
	void autoScaleY() {v->autoScaleY();}
	void autoScaleZ() {v->autoScaleZ();}
	void autoScaleAll() {v->autoScaleAll();}
	LRange *XRange() { return v->Range(0); }
	LRange *YRange() { return v->Range(1); }
	LRange *ZRange() { return v->Range(2); }
	void setXRange(double x1, double x2) {v->setXRange(x1,x2); }
	void setYRange(double y1, double y2) {v->setYRange(y1,y2); }
	void setZRange(double z1, double z2) {v->setZRange(z1,z2); }
	QColor Background() { return v->Background().color();}
	QColor graphBackground() { return v->graphBackground().color();}
	QBrush BackgroundBrush() { return v->Background();}
	QBrush graphBackgroundBrush() { return v->graphBackground();}
	void setBackground(QColor c) { v->setBackground(QBrush(c));}
	void setBackground(QBrush c) { v->setBackground(c);}
	void setBackground(QString c) { v->setBackground(QBrush(QColor(c)));}
	void setGraphBackground(QColor c) { v->setGraphBackground(QBrush(c));}
	void setGraphBackground(QBrush c) { v->setGraphBackground(c);}
	void setGraphBackground(QString c) { v->setGraphBackground(QBrush(QColor(c)));}
	
	bool Transparent() { return v->Transparent(); }
	void setTransparent(bool t) { v->setTransparent(t); }
	int ClipOffset() { return v->ClipOffset(); }
	void setClipOffset(int c) { v->setClipOffset(c);}
	double Baseline() { return v->Baseline(); }
	void setBaseline(double b) { v->setBaseline(b); }
	double XBaseline() { return v->XBaseline(); }
	void setXBaseline(double b) { v->setXBaseline(b); }
	bool BaselineEnabled() { return v->BaselineEnabled(); }
	bool XBaselineEnabled() { return v->XBaselineEnabled(); }
	void enableBaseline(bool e=true) { v->enableBaseline(e); }
	void setBaselineEnabled(bool e=true) { v->enableBaseline(e); }
	void enableXBaseline(bool e=true) { v->enableXBaseline(e); }
	void setXBaselineEnabled(bool e=true) { v->enableXBaseline(e); }
	// from Plot3D.h
	bool RenderStyle() { return v->RenderStyle(); }
	void setRenderStyle(bool r=true) { v->setRenderStyle(r); }
private:
	Plot3D *v;
};

class PlotQWT3DWrapper : public QObject
{
	Q_OBJECT
public:
	PlotQWT3DWrapper(PlotQWT3D *v) : v(v) {}
public slots:
	// from Plot.h
	Legend* getLegend() { return v->getLegend(); }
	Label* Title() { return v->Title(); }
	Axis *getAxis(int i) { return v->getAxis(i); }
	void setRange(LRange *r, int i) { v->setRange(r,i); }
	LRange* Range(int i) { return v->Range(i); }
	void setActRange(LRange *r, int i) { v->setActRange(r,i); } 
	LRange* ActRange(int i) { return v->ActRange(i); }
	void setRegionMin(double min) { v->setRegionMin(min); }
	void setRegionMax(double max) { v->setRegionMax(max); }
	void setRegion(double min, double max) { v->setRegion(min,max); }
	double RegionMin() {return v->RegionMin(); }
	double RegionMax() {return v->RegionMax(); }
	LRange *Region() { return v->Region(); }
	bool regionEnabled() { return v->regionEnabled(); }
	void enableRegion(bool e=true) { v->enableRegion(e); }
	void setRegionEnabled(bool e=true) { v->enableRegion(e); }
	
	bool marksEnabled() { return v->marksEnabled(); }
	void enableMarks(bool m=true) { v->enableMarks(m); }
	void setMarksEnabled(bool m=true) { v->enableMarks(m); }
	LRange *markX() { return v->markX(); }
	void setMarkX(LRange *l) { v->setMarkX(l); }
	LRange *markY() { return v->markY(); }
	void setMarkY(LRange *l) { v->setMarkY(l); }
	
	void setPosition(double x, double y) { v->setPosition(x,y);}
	Point Position() { return v->Position(); }
	void setSize(double x, double y) { v->setSize(x,y);}
	Point Size() { return v->Size(); }
	void enabledAspectRatio(bool a=true) { v->enableAspectRatio(a); }
	bool AspectRatioEnabled() { return v->AspectRatioEnabled(); }
	void autoScaleX() {v->autoScaleX();}
	void autoScaleY() {v->autoScaleY();}
	void autoScaleZ() {v->autoScaleZ();}
	void autoScaleAll() {v->autoScaleAll();}
	LRange *XRange() { return v->Range(0); }
	LRange *YRange() { return v->Range(1); }
	LRange *ZRange() { return v->Range(2); }
	void setXRange(double x1, double x2) {v->setXRange(x1,x2); }
	void setYRange(double y1, double y2) {v->setYRange(y1,y2); }
	void setZRange(double z1, double z2) {v->setZRange(z1,z2); }
	QColor Background() { return v->Background().color();}
	QColor graphBackground() { return v->graphBackground().color();}
	QBrush BackgroundBrush() { return v->Background();}
	QBrush graphBackgroundBrush() { return v->graphBackground();}
	void setBackground(QColor c) { v->setBackground(QBrush(c));}
	void setBackground(QBrush c) { v->setBackground(c);}
	void setBackground(QString c) { v->setBackground(QBrush(QColor(c)));}
	void setGraphBackground(QColor c) { v->setGraphBackground(QBrush(c));}
	void setGraphBackground(QBrush c) { v->setGraphBackground(c);}
	void setGraphBackground(QString c) { v->setGraphBackground(QBrush(QColor(c)));}
	
	bool Transparent() { return v->Transparent(); }
	void setTransparent(bool t) { v->setTransparent(t); }
	int ClipOffset() { return v->ClipOffset(); }
	void setClipOffset(int c) { v->setClipOffset(c);}
	double Baseline() { return v->Baseline(); }
	void setBaseline(double b) { v->setBaseline(b); }
	double XBaseline() { return v->XBaseline(); }
	void setXBaseline(double b) { v->setXBaseline(b); }
	bool BaselineEnabled() { return v->BaselineEnabled(); }
	bool XBaselineEnabled() { return v->XBaselineEnabled(); }
	void enableBaseline(bool e=true) { v->enableBaseline(e); }
	void setBaselineEnabled(bool e=true) { v->enableBaseline(e); }
	void enableXBaseline(bool e=true) { v->enableXBaseline(e); }
	void setXBaselineEnabled(bool e=true) { v->enableXBaseline(e); }
private:
	PlotQWT3D *v;
};

class PlotPieWrapper : public QObject
{
	Q_OBJECT
public:
	PlotPieWrapper(PlotPie *v) : v(v) {}
public slots:
	// from Plot.h
	Legend* getLegend() { return v->getLegend(); }
	Label* Title() { return v->Title(); }
	Axis *getAxis(int i) { return v->getAxis(i); }
	void setRange(LRange *r, int i) { v->setRange(r,i); }
	LRange* Range(int i) { return v->Range(i); }
	void setActRange(LRange *r, int i) { v->setActRange(r,i); } 
	LRange* ActRange(int i) { return v->ActRange(i); }
	void setRegionMin(double min) { v->setRegionMin(min); }
	void setRegionMax(double max) { v->setRegionMax(max); }
	void setRegion(double min, double max) { v->setRegion(min,max); }
	double RegionMin() {return v->RegionMin(); }
	double RegionMax() {return v->RegionMax(); }
	LRange *Region() { return v->Region(); }
	bool regionEnabled() { return v->regionEnabled(); }
	void enableRegion(bool e=true) { v->enableRegion(e); }
	void setRegionEnabled(bool e=true) { v->enableRegion(e); }
	
	bool marksEnabled() { return v->marksEnabled(); }
	void enableMarks(bool m=true) { v->enableMarks(m); }
	void setMarksEnabled(bool m=true) { v->enableMarks(m); }
	LRange *markX() { return v->markX(); }
	void setMarkX(LRange *l) { v->setMarkX(l); }
	LRange *markY() { return v->markY(); }
	void setMarkY(LRange *l) { v->setMarkY(l); }
	
	void setPosition(double x, double y) { v->setPosition(x,y);}
	Point Position() { return v->Position(); }
	void setSize(double x, double y) { v->setSize(x,y);}
	Point Size() { return v->Size(); }
	void enabledAspectRatio(bool a=true) { v->enableAspectRatio(a); }
	bool AspectRatioEnabled() { return v->AspectRatioEnabled(); }
	void autoScaleX() {v->autoScaleX();}
	void autoScaleY() {v->autoScaleY();}
	void autoScaleZ() {v->autoScaleZ();}
	void autoScaleAll() {v->autoScaleAll();}
	LRange *XRange() { return v->Range(0); }
	LRange *YRange() { return v->Range(1); }
	LRange *ZRange() { return v->Range(2); }
	void setXRange(double x1, double x2) {v->setXRange(x1,x2); }
	void setYRange(double y1, double y2) {v->setYRange(y1,y2); }
	void setZRange(double z1, double z2) {v->setZRange(z1,z2); }
	QColor Background() { return v->Background().color();}
	QColor graphBackground() { return v->graphBackground().color();}
	QBrush BackgroundBrush() { return v->Background();}
	QBrush graphBackgroundBrush() { return v->graphBackground();}
	void setBackground(QColor c) { v->setBackground(QBrush(c));}
	void setBackground(QBrush c) { v->setBackground(c);}
	void setBackground(QString c) { v->setBackground(QBrush(QColor(c)));}
	void setGraphBackground(QColor c) { v->setGraphBackground(QBrush(c));}
	void setGraphBackground(QBrush c) { v->setGraphBackground(c);}
	void setGraphBackground(QString c) { v->setGraphBackground(QBrush(QColor(c)));}
	
	bool Transparent() { return v->Transparent(); }
	void setTransparent(bool t) { v->setTransparent(t); }
	int ClipOffset() { return v->ClipOffset(); }
	void setClipOffset(int c) { v->setClipOffset(c);}
	double Baseline() { return v->Baseline(); }
	void setBaseline(double b) { v->setBaseline(b); }
	double XBaseline() { return v->XBaseline(); }
	void setXBaseline(double b) { v->setXBaseline(b); }
	bool BaselineEnabled() { return v->BaselineEnabled(); }
	bool XBaselineEnabled() { return v->XBaselineEnabled(); }
	void enableBaseline(bool e=true) { v->enableBaseline(e); }
	void setBaselineEnabled(bool e=true) { v->enableBaseline(e); }
	void enableXBaseline(bool e=true) { v->enableXBaseline(e); }
	void setXBaselineEnabled(bool e=true) { v->enableXBaseline(e); }
private:
	PlotPie *v;
};

class PlotPolarWrapper : public QObject
{
	Q_OBJECT
public:
	PlotPolarWrapper(PlotPolar *v) : v(v) {}
public slots:
	// from Plot.h
	Legend* getLegend() { return v->getLegend(); }
	Label* Title() { return v->Title(); }
	Axis *getAxis(int i) { return v->getAxis(i); }
	void setRange(LRange *r, int i) { v->setRange(r,i); }
	LRange* Range(int i) { return v->Range(i); }
	void setActRange(LRange *r, int i) { v->setActRange(r,i); } 
	LRange* ActRange(int i) { return v->ActRange(i); }
	void setRegionMin(double min) { v->setRegionMin(min); }
	void setRegionMax(double max) { v->setRegionMax(max); }
	void setRegion(double min, double max) { v->setRegion(min,max); }
	double RegionMin() {return v->RegionMin(); }
	double RegionMax() {return v->RegionMax(); }
	LRange *Region() { return v->Region(); }
	bool regionEnabled() { return v->regionEnabled(); }
	void enableRegion(bool e=true) { v->enableRegion(e); }
	void setRegionEnabled(bool e=true) { v->enableRegion(e); }
	
	bool marksEnabled() { return v->marksEnabled(); }
	void enableMarks(bool m=true) { v->enableMarks(m); }
	void setMarksEnabled(bool m=true) { v->enableMarks(m); }
	LRange *markX() { return v->markX(); }
	void setMarkX(LRange *l) { v->setMarkX(l); }
	LRange *markY() { return v->markY(); }
	void setMarkY(LRange *l) { v->setMarkY(l); }
	
	void setPosition(double x, double y) { v->setPosition(x,y);}
	Point Position() { return v->Position(); }
	void setSize(double x, double y) { v->setSize(x,y);}
	Point Size() { return v->Size(); }
	void enabledAspectRatio(bool a=true) { v->enableAspectRatio(a); }
	bool AspectRatioEnabled() { return v->AspectRatioEnabled(); }
	void autoScaleX() {v->autoScaleX();}
	void autoScaleY() {v->autoScaleY();}
	void autoScaleZ() {v->autoScaleZ();}
	void autoScaleAll() {v->autoScaleAll();}
	LRange *XRange() { return v->Range(0); }
	LRange *YRange() { return v->Range(1); }
	LRange *ZRange() { return v->Range(2); }
	void setXRange(double x1, double x2) {v->setXRange(x1,x2); }
	void setYRange(double y1, double y2) {v->setYRange(y1,y2); }
	void setZRange(double z1, double z2) {v->setZRange(z1,z2); }
	QColor Background() { return v->Background().color();}
	QColor graphBackground() { return v->graphBackground().color();}
	QBrush BackgroundBrush() { return v->Background();}
	QBrush graphBackgroundBrush() { return v->graphBackground();}
	void setBackground(QColor c) { v->setBackground(QBrush(c));}
	void setBackground(QBrush c) { v->setBackground(c);}
	void setBackground(QString c) { v->setBackground(QBrush(QColor(c)));}
	void setGraphBackground(QColor c) { v->setGraphBackground(QBrush(c));}
	void setGraphBackground(QBrush c) { v->setGraphBackground(c);}
	void setGraphBackground(QString c) { v->setGraphBackground(QBrush(QColor(c)));}
	
	bool Transparent() { return v->Transparent(); }
	void setTransparent(bool t) { v->setTransparent(t); }
	int ClipOffset() { return v->ClipOffset(); }
	void setClipOffset(int c) { v->setClipOffset(c);}
	double Baseline() { return v->Baseline(); }
	void setBaseline(double b) { v->setBaseline(b); }
	double XBaseline() { return v->XBaseline(); }
	void setXBaseline(double b) { v->setXBaseline(b); }
	bool BaselineEnabled() { return v->BaselineEnabled(); }
	bool XBaselineEnabled() { return v->XBaselineEnabled(); }
	void enableBaseline(bool e=true) { v->enableBaseline(e); }
	void setBaselineEnabled(bool e=true) { v->enableBaseline(e); }
	void enableXBaseline(bool e=true) { v->enableXBaseline(e); }
	void setXBaselineEnabled(bool e=true) { v->enableXBaseline(e); }
private:
	PlotPolar *v;
};

class PlotTernaryWrapper : public QObject
{
	Q_OBJECT
public:
	PlotTernaryWrapper(PlotTernary *v) : v(v) {}
public slots:
	// from Plot.h
	Legend* getLegend() { return v->getLegend(); }
	Label* Title() { return v->Title(); }
	Axis *getAxis(int i) { return v->getAxis(i); }
	void setRange(LRange *r, int i) { v->setRange(r,i); }
	LRange* Range(int i) { return v->Range(i); }
	void setActRange(LRange *r, int i) { v->setActRange(r,i); } 
	LRange* ActRange(int i) { return v->ActRange(i); }
	void setRegionMin(double min) { v->setRegionMin(min); }
	void setRegionMax(double max) { v->setRegionMax(max); }
	void setRegion(double min, double max) { v->setRegion(min,max); }
	double RegionMin() {return v->RegionMin(); }
	double RegionMax() {return v->RegionMax(); }
	LRange *Region() { return v->Region(); }
	bool regionEnabled() { return v->regionEnabled(); }
	void enableRegion(bool e=true) { v->enableRegion(e); }
	void setRegionEnabled(bool e=true) { v->enableRegion(e); }
	
	bool marksEnabled() { return v->marksEnabled(); }
	void enableMarks(bool m=true) { v->enableMarks(m); }
	void setMarksEnabled(bool m=true) { v->enableMarks(m); }
	LRange *markX() { return v->markX(); }
	void setMarkX(LRange *l) { v->setMarkX(l); }
	LRange *markY() { return v->markY(); }
	void setMarkY(LRange *l) { v->setMarkY(l); }
	
	void setPosition(double x, double y) { v->setPosition(x,y);}
	Point Position() { return v->Position(); }
	void setSize(double x, double y) { v->setSize(x,y);}
	Point Size() { return v->Size(); }
	void enabledAspectRatio(bool a=true) { v->enableAspectRatio(a); }
	bool AspectRatioEnabled() { return v->AspectRatioEnabled(); }
	void autoScaleX() {v->autoScaleX();}
	void autoScaleY() {v->autoScaleY();}
	void autoScaleZ() {v->autoScaleZ();}
	void autoScaleAll() {v->autoScaleAll();}
	LRange *XRange() { return v->Range(0); }
	LRange *YRange() { return v->Range(1); }
	LRange *ZRange() { return v->Range(2); }
	void setXRange(double x1, double x2) {v->setXRange(x1,x2); }
	void setYRange(double y1, double y2) {v->setYRange(y1,y2); }
	void setZRange(double z1, double z2) {v->setZRange(z1,z2); }
	QColor Background() { return v->Background().color();}
	QColor graphBackground() { return v->graphBackground().color();}
	QBrush BackgroundBrush() { return v->Background();}
	QBrush graphBackgroundBrush() { return v->graphBackground();}
	void setBackground(QColor c) { v->setBackground(QBrush(c));}
	void setBackground(QBrush c) { v->setBackground(c);}
	void setBackground(QString c) { v->setBackground(QBrush(QColor(c)));}
	void setGraphBackground(QColor c) { v->setGraphBackground(QBrush(c));}
	void setGraphBackground(QBrush c) { v->setGraphBackground(c);}
	void setGraphBackground(QString c) { v->setGraphBackground(QBrush(QColor(c)));}
	
	bool Transparent() { return v->Transparent(); }
	void setTransparent(bool t) { v->setTransparent(t); }
	int ClipOffset() { return v->ClipOffset(); }
	void setClipOffset(int c) { v->setClipOffset(c);}
	double Baseline() { return v->Baseline(); }
	void setBaseline(double b) { v->setBaseline(b); }
	double XBaseline() { return v->XBaseline(); }
	void setXBaseline(double b) { v->setXBaseline(b); }
	bool BaselineEnabled() { return v->BaselineEnabled(); }
	bool XBaselineEnabled() { return v->XBaselineEnabled(); }
	void enableBaseline(bool e=true) { v->enableBaseline(e); }
	void setBaselineEnabled(bool e=true) { v->enableBaseline(e); }
	void enableXBaseline(bool e=true) { v->enableXBaseline(e); }
	void setXBaselineEnabled(bool e=true) { v->enableXBaseline(e); }
private:
	PlotTernary *v;
};


// factory
#ifdef HAVE_QSA_FAC
class WrapperFactory : public QSWrapperFactory
{
public:
    WrapperFactory(MainWin *mw, QWorkspace *ws);
    QObject *create( const QString &className,void *ptr);
private:
	MainWin *mw;
	QWorkspace *ws;
};
#endif

#endif //WRAPPERFACTORY_H
