//LabPlot : WaveletListDialog.h

#ifndef WAVELETLISTDIALOG_H
#define WAVELETLISTDIALOG_H

#include "ListDialog.h"

class WaveletListDialog : public ListDialog
{
	Q_OBJECT
public:
	WaveletListDialog(MainWin *mw, const char *name);
public slots:
	void setDirection(int v=0) {	transform->setCurrentItem(v); }	//!< set direction forward/backward
	void setTransform(int v=0) { setDirection(v); }
	void setForm(bool t=false) { form->setCurrentItem(t); }			//!< set form of transformation
	void setType(int t) { typecb->setCurrentItem(t); }					//!< set type of transform
	void setK(int k) { kni->setValue(k); }				//!< set k value
	int Apply() { return apply_clicked(); }
private:
	KComboBox *transform, *form, *typecb;
	KIntNumInput *kni;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // WAVELETLISTDIALOG_H
