//LabPlot : Rect.h

#ifndef RECT_H
#define RECT_H

#include <qcolor.h>
#include <qpainter.h>
#include <qstringlist.h>
#include <qdom.h>
#include "Point.h"

class Rect
{
public:
	Rect(Point s=0,Point e=0,QColor c="black",int w=1,bool f=true, QColor fi="white");
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	QDomElement saveXML(QDomDocument doc);
	void openXML(QDomNode node);
	Point startPoint() { return start; }
	Point endPoint() { return end; }
	void setStartPoint(double x, double y) { start=Point(x,y);}
	void setEndPoint(double x, double y) { end=Point(x,y);}
	int Width() { return width; }
	void setWidth(int w) { width=w; }
	QColor Color() { return color; }
	void setColor(QColor c) { color=c; }
	void setColor(QString c) { color=QColor(c); }
	QColor FillColor() { return fillcolor; }
	void setFillColor(QColor c) { fillcolor=c; }
	void setFillColor(QString c) { fillcolor=QColor(c); }
	bool isFilled() { return filled; }
	void setFilled(bool f=true) { filled=f; }
	void draw(QPainter *p, int w, int h);
	bool inside(int x, int y, int w, int h);
protected:
	Point start, end;
	QColor color;
	int width;
	bool filled;
	QColor fillcolor;
};

#endif //RECT_H
