// //LabPlot : ListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qfiledialog.h>
#include <qinputdialog.h>
#include "ListDialog.h"
#include "ExportDialog.h"
#include "InfoDialog.h"
#include "DataDialog.h"
#include "FunctionDialog.h"
#include "AddGraphDialog.h"
#include "LTableItem.h"
#include "colors.h"
#include "defs.h"

ListDialog::ListDialog(MainWin *m, const char *name)
	: Dialog(m, name)
{
	kdDebug()<<"	ListDialog()"<<endl;

	if(p==0) {
		kdDebug()<<"	p==0"<<endl;
		lv=0;
		return;
	}

	Plot *plot = p->getPlot(p->API());
	TESTPTR(plot);
	type = plot->Type();

	lv = new GraphListView(vbox);

	// popup menu
	menu = new QPopupMenu( lv );
	menu->insertItem( i18n( "Show/Hide" ),this,SLOT(toggleShown()) );
	menu->insertItem( i18n( "Add" ),this,SLOT(addGraph()) );
	menu->insertItem( i18n( "Delete" ),this,SLOT(deleteGraph()) );
	menu->insertItem( i18n( "Change" ),this,SLOT(changeGraph()) );
	menu->insertItem( i18n( "Clone" ),this,SLOT(Clone()) );
	menu->insertSeparator();
	menu->insertItem( i18n( "Edit" ),this,SLOT(editGraph()) );
	menu->insertItem( i18n( "Open Spreadsheet" ),this,SLOT(openSpreadsheet()) );
	menu->insertItem( i18n( "Export" ),this,SLOT(dumpGraph()) );
	menu->insertItem( i18n( "Statistics" ),this,SLOT(statGraph()) );
	menu->insertSeparator();
	menu->insertItem(i18n("different colors") ,this,SLOT(setDifferentColor()) );
	menu->insertItem(i18n("different symbols") ,this,SLOT(setDifferentSymbol()) );
	menu->insertItem(i18n("different line widths") ,this,SLOT(setDifferentWidth()) );
	menu->insertItem(i18n("different line styles") ,this,SLOT(setDifferentStyle()) );
 	menu->insertItem(i18n("black && white") ,this,SLOT(setBlackWhite()) );
 	menu->insertSeparator();
	menu->insertItem( i18n( "Toggle Masking" ),this,SLOT(toggleMask()) );
	menu->insertItem( i18n( "Unmask" ),this,SLOT(unMask()) );
	menu->insertItem( i18n( "Mask every n-th row" ),this,SLOT(nthMask()) );
	menu->insertItem( i18n( "Mask all but n-th row" ),this,SLOT(firstMask()) );

	// result selection
	QHBox *hb = new QHBox(vbox);
	sheetlabel = new QLabel(i18n("add result to "),hb);
	sheetcb = new KComboBox(hb);
	updateSheetList();

	connect(lv, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint& , int ) ),
		this, SLOT( Menu(QListViewItem *, const QPoint& , int) ) );
	connect(lv, SIGNAL( doubleClicked( QListViewItem *, const QPoint& , int ) ),
		this, SLOT( changeGraph() ) );

	updateList();
}

void ListDialog::updateSheetList() {
	QStringList wlist;
	QWidgetList list = mw->getWorkspace()->windowList();

	for(unsigned int i=0;i<list.count();i++) {
		wlist << list.at(i)->caption();
	}
	wlist<<i18n("new Worksheet")<<i18n("new Spreadsheet");

	sheetcb->clear();
	sheetcb->insertStringList(wlist);
	sheetcb->setCurrentItem(mw->activeSheetIndex());
}

void ListDialog::updateList() {
	kdDebug()<<"	ListDialog::updateList()"<<endl;
	lv->clear();
	lv->setSorting(-1);

	GraphList *graphlist = p->getPlot(p->API())->getGraphList();
	for (int i= graphlist->Number()-1;i>=0;i--) {
		kdDebug()<<" using graph "<<i<<endl;
		QStringList sl;
		GRAPHType st = graphlist->getType(i);

		if (type == P2D) {
			if (st == GRAPH2D)		// x-y
				sl = graphlist->getGraph2D(i)->Info();
			else if (st == GRAPH3D) {	// x-y-dy
				lv->showZ();
				sl = graphlist->getGraph3D(i)->Info();
			}
			else if (st == GRAPH4D) {	// x-y-dx-dy, x-y-dy1-dy2
				lv->showZ();
				lv->showT();
				sl = graphlist->getGraph4D(i)->Info();
			}
		}
		else if (type == P3D) {
			if (st == GRAPH3D) {
				lv->showZ();
				sl = graphlist->getGraph3D(i)->Info();
			}
			else if (st == GRAPHM)
				sl = graphlist->getGraphM(i)->Info();
		}
		else if (type == PSURFACE) {
			if (st == GRAPHM)
				sl = graphlist->getGraphM(i)->Info();
			else if (st == GRAPH3D)
				sl = graphlist->getGraph3D(i)->Info();
			else if (st == GRAPHIMAGE)
				sl = graphlist->getGraphIMAGE(i)->Info();
		}
		else if (type == PPIE) {
			if(st == GRAPH2D) {
				Graph2D *graph = graphlist->getGraph2D(i);
				if(graph !=0)
					sl = graph->Info();
				else
					kdDebug()<<"			WARNING: graph "<<i<<" == 0!"<<endl;
			}
			else if (st == GRAPHL) {
				GraphL *graph = graphlist->getGraphL(i);
				if(graph !=0)
					sl = graph->Info();
				else
					kdDebug()<<"			WARNING: graph "<<i<<" == 0!"<<endl;
			}
		}
		else if (type == PPOLAR) {
			Graph2D *graph = graphlist->getGraph2D(i);
			if(graph !=0)
				sl = graph->Info();
			else
				kdDebug()<<"			WARNING: graph "<<i<<" == 0!"<<endl;
				
		}
		else if (type == PTERNARY) {
			lv->showZ();
			sl = graphlist->getGraph3D(i)->Info();
		}
		else if (type == PQWT3D) {
			if (st == GRAPHM)
				sl = graphlist->getGraphM(i)->Info();
			else if (st == GRAPH3D)
				sl = graphlist->getGraph3D(i)->Info();
		}
		QListViewItem *lvi = new QListViewItem(lv);

		// add icon with graph symbol
		QPainter pa;
		QPixmap pm( 30, 30 );
		pm.fill(Qt::white);
		pa.begin( &pm );
		graphlist->getGraph(i)->drawStyle(&pa,0,15);
		pa.end();

		lvi->setPixmap(0,pm);

		for (unsigned int j = 0;j < sl.count();j++) {
			lvi->setText(j+1,sl[j]);
		}
//		kdDebug()<<"	NOW COLUMNS = "<<lv->columns()<<endl;
	}

	// select at least last item
	lv->setSelected(lv->currentItem(),true);

	p->getMainWin()->setModified();
	p->resetRanges();
	p->updatePixmap();
	kdDebug()<<"	ListDialog::updateList() DONE"<<endl;
}

void ListDialog::selectItem(int i) {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		if(item == i)
			it.current()->setSelected(true);
	}
}

// toggle shown of selected graph
void ListDialog::toggleShown() {
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());

		Graph *g = p->getPlot(p->API())->getGraphList()->getGraph(item);
		if(g->isShown())
			g->setShown(false);
		else
			g->setShown(true);
	}

	updateList();
	p->updatePixmap();
	p->resetRanges();
}

// add graphs
void ListDialog::addGraph() {
	kdDebug()<<"ListDialog::addGraph()"<<endl;
	(new AddGraphDialog(mw, this, p->getPlot(p->API())->getGraphList(), 0))->show();
}

// delete selected graph
void ListDialog::deleteGraph() {
	kdDebug()<<"ListDialog::deleteGraph()"<<endl;
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	int cur_item=0;
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		kdDebug()<<"	item = "<<item<<endl;
		// shift item after deleted items
		kdDebug()<<"	deleting graph "<<item-cur_item<<endl;
		kdDebug()<<"	API="<<p->API()<<endl;
		p->getPlot(p->API())->getGraphList()->delGraph(item - cur_item++);
	}

	p->resetRanges();

	updateList();
	p->updatePixmap();
}

void ListDialog::changeGraph() {
	Plot *plot = p->getPlot(p->API());
	PType ptype = plot->Type();

#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		QString name = it.current()->text(0);

		if(plot->getGraphList()->getGraph(item)->Source()==SDATA)
			(new DataDialog(mw,name,this,item,ptype))->show();
		else
			(new FunctionDialog(mw,name,this,item,ptype))->show();
	}
}

//! dump the selected graph data to a file
void ListDialog::dumpGraph() {
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		QString name = it.current()->text(0);
		(new ExportDialog(p->getMainWin(),name,item))->show();
	}
}

//! edit the selected graph data
void ListDialog::editGraph() {
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		QString name = it.current()->text(0);

		GraphList *gl = p->getPlot(p->API())->getGraphList();
		GRAPHType gtype = gl->getType(item);
//		kdDebug()<<"STRUCT/TYPE = "<<gtype<<endl;

		if(gtype == GRAPHIMAGE)	// image not editable
			continue;

		mw->newSpreadsheet();
		Spreadsheet *ss = mw->activeSpreadsheet();

		switch(gtype) {
		case GRAPH2D: {
			Graph2D *g = gl->getGraph2D(item);
			ss->addGraph2D(g);
			}; break;
		case GRAPH3D: {
			Graph3D *g = gl->getGraph3D(item);
			ss->addGraph3D(g);
			}; break;
		case GRAPH4D: {
			Graph4D *g = gl->getGraph4D(item);
			ss->addGraph4D(g);
			}; break;
		case GRAPHM: {
			GraphM *g = gl->getGraphM(item);
			ss->addGraphM(g);
			}; break;
		default:
			break;
		}

		ss->setListDialog(this);
		ss->setGraph(gl->getGraph(item));
	}
}

void ListDialog::openSpreadsheet() {
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());

		GraphList *gl = p->getPlot(p->API())->getGraphList();
		GRAPHType st = gl->getType(item);

		Spreadsheet *spreadsheet = p->getMainWin()->newSpreadsheet();
		QTable *table = spreadsheet->Table();
		if(st != GRAPHIMAGE)	// here Number = NX*NY !
			table->setNumRows(gl->getGraph(item)->Number());

		if (st == GRAPH2D) {
			Graph2D *g = gl->getGraph2D(item);
			Point *data = g->Data();
			for(int i=0;i<g->Number();i++) {
				if(data[i].Masked()) {
					LTableItem *itx, *ity;
					itx = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].X()));
					ity = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].Y()));
					itx->setMasked();
					ity->setMasked();
					table->setItem( i, 0, itx);
					table->setItem( i, 1, ity);
				}
				else {
					table->setText(i,0,QString::number(data[i].X()));
					table->setText(i,1,QString::number(data[i].Y()));
				}
			}
		}
		else if (st == GRAPH3D) {
			Graph3D *g = gl->getGraph3D(item);
			Point3D *data = g->Data();
			table->setNumCols(3);
			table->horizontalHeader()->setLabel( 2, QString("C ")+i18n("{double}")+QString(" [Z]") );
			for(int i=0;i<g->Number();i++) {
				if(data[i].Masked()) {
					LTableItem *itx, *ity, *itz;
					itx = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].X()));
					ity = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].Y()));
					itz = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].Z()));
					itx->setMasked();
					ity->setMasked();
					itz->setMasked();
					table->setItem( i, 0, itx);
					table->setItem( i, 1, ity);
					table->setItem( i, 2, itz);
				}
				else {
					table->setText(i,0,QString::number(data[i].X()));
					table->setText(i,1,QString::number(data[i].Y()));
					table->setText(i,2,QString::number(data[i].Z()));
				}
			}
		}
		else if (st == GRAPHM) {
			GraphM *g = gl->getGraphM(item);
			double *data = g->Data();
			table->setNumCols(g->NX());
			table->setNumRows(g->NY());
			// set label for all columns
			for (int i=1;i<table->numCols();i++)
				table->horizontalHeader()->setLabel( i, QChar(i+65)+' '+i18n("{double}")+QString( " [Y]" ) );

			// TODO : set masked data
			for(int i=0;i<g->NY();i++)
				for(int j=0;j<g->NX();j++)
					table->setText(i,j,QString::number(data[j+g->NX()*i]));
		}
		else if (st == GRAPH4D) {
			Graph4D *g = gl->getGraph4D(item);
			Point4D *data = g->Data();
			table->setNumCols(4);
			table->horizontalHeader()->setLabel( 2, QString("C ")+i18n("{double}")+QString(" [Y]" ) );
			table->horizontalHeader()->setLabel( 3, QString("D ")+i18n("{double}")+QString(" [Y]" ) );
			for(int i=0;i<g->Number();i++) {
				if(data[i].Masked()) {
					kdDebug()<<"Point "<<i<<" MASKED ("<<data[i].Masked()<<')'<<endl;
					LTableItem *itx, *ity, *itz, *itt;
					itx = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].X()));
					ity = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].Y()));
					itz = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].Z()));
					itt = new LTableItem( table, QTableItem::OnTyping,QString::number(data[i].T()));
					itx->setMasked();
					ity->setMasked();
					itz->setMasked();
					itt->setMasked();
					table->setItem( i, 0, itx);
					table->setItem( i, 1, ity);
					table->setItem( i, 2, itz);
					table->setItem( i, 3, itz);
				}
				else {
					table->setText(i,0,QString::number(data[i].X()));
					table->setText(i,1,QString::number(data[i].Y()));
					table->setText(i,2,QString::number(data[i].Z()));
					table->setText(i,3,QString::number(data[i].T()));
				}
			}
		}
		else if (st == GRAPHIMAGE) {
			GraphIMAGE *g = gl->getGraphIMAGE(item);
			QPixmap pm = g->Pixmap();
			table->setNumCols(pm.width());
			table->setNumRows(pm.height());
			// set label for all columns
			for (int i=1;i<table->numCols();i++)
				table->horizontalHeader()->setLabel( i, QChar(i+65)+' '+i18n("{double}")+QString( " [Y]" ) );

			QImage image = pm.convertToImage();

			for (int i=0;i<pm.width();i++) {
				for (int j=0;j<pm.height();j++) {
					table->setText(j,i,QString::number(qGray(image.pixel(i,j))));
				}
			}
		}
	}
	MainWin *mw = p->getMainWin();
	mw->setActiveSheet(mw->NrWorksheets()+mw->NrSpreadsheets()-1);
}

//! show selected graph info and statistics
void ListDialog::statGraph() {
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		QString name = it.current()->text(0);

		(new InfoDialog(mw,name,item))->show();
	}
}

void ListDialog::setDifferentColor() {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	int i=0;
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		Graph *g = gl->getGraph(item);
		Style *style = g->getStyle();
		style->setColor(colortable[i%15]);
		i++;
	}

	p->updatePixmap();
}

void ListDialog::setDifferentSymbol() {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	int i=0;
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		Graph *g = gl->getGraph(item);
		Symbol *symbol = g->getSymbol();
		symbol->setType((SType) (i%SYMBOLNR+1));
		i++;
	}

	p->updatePixmap();
}

void ListDialog::setDifferentWidth() {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	int i=0;
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		Graph *g = gl->getGraph(item);
		Style *style = g->getStyle();
		style->setWidth(i+1);
		i++;
	}

	p->updatePixmap();
}

void ListDialog::setDifferentStyle() {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	int i=0;
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		Graph *g = gl->getGraph(item);
		Style *style = g->getStyle();
		style->setPenStyle(i%5+1);
		i++;
	}

	p->updatePixmap();
}

void ListDialog::setBlackWhite() {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	int i=0;
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		Graph *g = gl->getGraph(item);
		Style *style = g->getStyle();
		style->setColor(Qt::black);
		style->setFillColor(Qt::black);
		Symbol *symbol = g->getSymbol();
		symbol->setColor(Qt::black);
		symbol->setFillColor(Qt::black);
// dont change symbol types and pen style
//		style->setPenStyle(i%5+1);
//		symbol->setType(i%SYMBOLNR+1);
		i++;
	}

	p->updatePixmap();
}

// called from all masking functions : 0-toggle, 1-unmask, 2-nth point, 3-first point
void ListDialog::mask(int how, int n) {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number() == 0)
		return;

#if QT_VERSION > 0x030102
	QListViewItemIterator it(lv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(lv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif
		int item = (int) (lv->itemPos(it.current())/it.current()->height());
		GRAPHType gtype = gl->getType(item);
		switch(gtype) {
		case GRAPH2D: {
			Graph2D *g = gl->getGraph2D(item);
			Point *data = g->Data();
			for(int i=0;i<g->Number();i++) {
				switch(how) {
				case 0:
					if(data[i].Masked())
						data[i].setMasked(false);
					else
						data[i].setMasked(true);
					break;
				case 1:
					data[i].setMasked(false);
					break;
				case 2:
					if(i%n==0) data[i].setMasked(true);
					break;
				case 3:
					if(i%n) data[i].setMasked(true);
					break;
				}
			}
			}; break;
		case GRAPH3D: {
			Graph3D *g = gl->getGraph3D(item);
			Point3D *data = g->Data();
			for(int i=0;i<g->Number();i++) {
				switch(how) {
				case 0:
					if(data[i].Masked())
						data[i].setMasked(false);
					else
						data[i].setMasked(true);
					break;
				case 1:
					data[i].setMasked(false);
					break;
				case 2:
					if(i%n==0) data[i].setMasked(true);
					break;
				case 3:
					if(i%n) data[i].setMasked(true);
					break;
				}
			}
			}; break;
		case GRAPH4D: {
			Graph4D *g = gl->getGraph4D(item);
			Point4D *data = g->Data();
			for(int i=0;i<g->Number();i++) {
				switch(how) {
				case 0:
					if(data[i].Masked())
						data[i].setMasked(false);
					else
						data[i].setMasked(true);
					break;
				case 1:
					data[i].setMasked(false);
					break;
				case 2:
					if(i%n==0) data[i].setMasked(true);
					break;
				case 3:
					if(i%n) data[i].setMasked(true);
					break;
				}
			}
			}; break;
		case GRAPHM: {
			//TODO
			}; break;
		default: break;
		}
	}

	p->updatePixmap();
}

void ListDialog::toggleMask() { mask(0,0); }

void ListDialog::unMask() { mask(1,0); }

void ListDialog::nthMask() {
	bool res;
	int n = QInputDialog::getInteger(i18n("Mask every n-th row"),i18n("n = "),10,1,INF,1,&res);
	if(!res) return;

	mask(2,n);
}

void ListDialog::firstMask() {
	bool res;
	int n = QInputDialog::getInteger(i18n("Mask all but n-th row"),i18n("n = "),10,1,INF,1,&res);
	if(!res) return;

	mask(3,n);
}

//! clone selected graphs
void ListDialog::Clone() {
	// TODO : use GraphXX::Clone() instead
	Plot *plot = p->getPlot(p->API());
	PType ptype = plot->Type();
	GraphList *gl = plot->getGraphList();
	if(gl->Number()==0)
		return;

	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	int sheet = sheetcb->currentItem();
	switch(gl->getType(item)) {
	case GRAPH2D: {
		Graph2D *g = gl->getGraph2D(item)->Clone();
		mw->addGraph2D(g,sheet,ptype);
		}; break;
	case GRAPH3D: {
		Graph3D *g = gl->getGraph3D(item)->Clone();
		mw->addGraph3D(g,sheet,ptype);
		}; break;
	case GRAPH4D: {
		Graph4D *g = gl->getGraph4D(item)->Clone();
		mw->addGraph4D(g,sheet);
		}; break;
	case GRAPHM: {
		GraphM *g = gl->getGraphM(item)->Clone();
		mw->addGraphM(g,sheet,ptype);
		}; break;
	case GRAPHIMAGE: {
		GraphIMAGE *g = gl->getGraphIMAGE(item)->Clone();
		mw->addGraphIMAGE(g,sheet);
		}; break;
	default:
		break;
	}

	updateList();
	updateSheetList();
	p->updatePixmap();
}

// update range (ale-ble) when selecting another graph
void ListDialog::updateRange(int axis) {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0)
		return;
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	LRange range=0;

	if (gl->getType(item) == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		range = g->Range(axis);
		ale->setText(QString::number(range.rMin()));
		ble->setText(QString::number(range.rMax()));
	}
}

