/*LabPlot : constants.h*/

#ifndef CONSTANTS_H
#define CONSTANTS_H

#ifdef HAVE_GSL
#include <gsl/gsl_math.h>
#include <gsl/gsl_sf.h>
#include <gsl/gsl_randist.h>
#include <gsl/gsl_const_num.h>
#ifdef HAVE_GSL14
#include <gsl/gsl_const_mksa.h>
#include <gsl/gsl_const_cgsm.h>
#else
#include <gsl/gsl_const_mks.h>
#include <gsl/gsl_const_cgs.h>
#endif
#endif

#include "parser_struct.h"

struct con constants[] = {
	{"pi1",M_1_PI},
	{"pi2",M_2_PI},
	{"pisqrt2",M_2_SQRTPI},
	{"e",M_E},
	{"ln2",M_LN2},
	{"ln10",M_LN10},
	{"log2e",M_LOG2E},
	{"log10e",M_LOG10E},
	{"pi",M_PI},
	{"pi_2",M_PI_2},
	{"pi_4",M_PI_4},
	{"sqrt2",M_SQRT2},
	{"sqrt1_2",M_SQRT1_2},
#ifdef HAVE_GSL
#ifdef HAVE_GSL14
	{"c",GSL_CONST_MKSA_SPEED_OF_LIGHT},
	{"mu0",GSL_CONST_MKSA_VACUUM_PERMEABILITY},
	{"e0",GSL_CONST_MKSA_VACUUM_PERMITTIVITY},
	{"na",GSL_CONST_NUM_AVOGADRO},
	{"f",GSL_CONST_MKSA_FARADAY},
	{"k",GSL_CONST_MKSA_BOLTZMANN},
	{"r0",GSL_CONST_MKSA_MOLAR_GAS},
	{"v0",GSL_CONST_MKSA_STANDARD_GAS_VOLUME},
	{"gauss",GSL_CONST_MKSA_GAUSS},
	{"mu",GSL_CONST_MKSA_MICRON},
	{"ha",GSL_CONST_MKSA_HECTARE},
	{"mph",GSL_CONST_MKSA_MILES_PER_HOUR},
	{"kmh",GSL_CONST_MKSA_KILOMETERS_PER_HOUR},
	{"au",GSL_CONST_MKSA_ASTRONOMICAL_UNIT},
	{"G",GSL_CONST_MKSA_GRAVITATIONAL_CONSTANT},
	{"ly",GSL_CONST_MKSA_LIGHT_YEAR},
	{"pc",GSL_CONST_MKSA_PARSEC},
	{"gg",GSL_CONST_MKSA_GRAV_ACCEL},
	{"ms",GSL_CONST_MKSA_SOLAR_MASS},
	{"e",GSL_CONST_MKSA_ELECTRON_CHARGE},
	{"ev",GSL_CONST_MKSA_ELECTRON_VOLT},
	{"amu",GSL_CONST_MKSA_UNIFIED_ATOMIC_MASS},
	{"me",GSL_CONST_MKSA_MASS_ELECTRON},
	{"mmu",GSL_CONST_MKSA_MASS_MUON},
	{"mp",GSL_CONST_MKSA_MASS_PROTON},
	{"mn",GSL_CONST_MKSA_MASS_NEUTRON},
	{"alpha",GSL_CONST_NUM_FINE_STRUCTURE},
	{"ry",GSL_CONST_MKSA_RYDBERG},
	{"a0",GSL_CONST_MKSA_BOHR_RADIUS},
	{"a",GSL_CONST_MKSA_ANGSTROM},
	{"barn",GSL_CONST_MKSA_BARN},
	{"mub",GSL_CONST_MKSA_BOHR_MAGNETON},
	{"mun",GSL_CONST_MKSA_NUCLEAR_MAGNETON},
	{"mue",GSL_CONST_MKSA_ELECTRON_MAGNETIC_MOMENT},
	{"mup",GSL_CONST_MKSA_PROTON_MAGNETIC_MOMENT},
	{"min",GSL_CONST_MKSA_MINUTE},
	{"h",GSL_CONST_MKSA_HOUR},
	{"d",GSL_CONST_MKSA_DAY},
	{"week",GSL_CONST_MKSA_WEEK},
	{"in",GSL_CONST_MKSA_INCH},
	{"ft",GSL_CONST_MKSA_FOOT},
	{"yard",GSL_CONST_MKSA_YARD},
	{"mile",GSL_CONST_MKSA_MILE},
	{"mil",GSL_CONST_MKSA_MIL},
	{"nmile",GSL_CONST_MKSA_NAUTICAL_MILE},
	{"fathom",GSL_CONST_MKSA_FATHOM},
	{"knot",GSL_CONST_MKSA_KNOT},
	{"pt",GSL_CONST_MKSA_POINT},
	{"texpt",GSL_CONST_MKSA_TEXPOINT},
	{"acre",GSL_CONST_MKSA_ACRE},
	{"ltr",GSL_CONST_MKSA_LITER},
	{"us_gallon",GSL_CONST_MKSA_US_GALLON},
	{"can_gallon",GSL_CONST_MKSA_CANADIAN_GALLON},
	{"uk_gallon",GSL_CONST_MKSA_UK_GALLON},
	{"quart",GSL_CONST_MKSA_QUART},
	{"pint",GSL_CONST_MKSA_PINT},
	{"pound",GSL_CONST_MKSA_POUND_MASS},
	{"ounce",GSL_CONST_MKSA_OUNCE_MASS},
 	{"ton",GSL_CONST_MKSA_TON},
 	{"mton",GSL_CONST_MKSA_METRIC_TON},
 	{"uk_ton",GSL_CONST_MKSA_UK_TON},
 	{"troy_ounce",GSL_CONST_MKSA_TROY_OUNCE},
 	{"carat",GSL_CONST_MKSA_CARAT},
 	{"gram_force",GSL_CONST_MKSA_GRAM_FORCE},
 	{"pound_force",GSL_CONST_MKSA_POUND_FORCE},
 	{"kilepound_force",GSL_CONST_MKSA_KILOPOUND_FORCE},
 	{"poundal",GSL_CONST_MKSA_POUNDAL},
	{"cal",GSL_CONST_MKSA_CALORIE},
 	{"btu",GSL_CONST_MKSA_BTU},
 	{"therm",GSL_CONST_MKSA_THERM},
 	{"hp",GSL_CONST_MKSA_HORSEPOWER},
	{"bar",GSL_CONST_MKSA_BAR},
 	{"atm",GSL_CONST_MKSA_STD_ATMOSPHERE},
 	{"torr",GSL_CONST_MKSA_TORR},
 	{"mhg",GSL_CONST_MKSA_METER_OF_MERCURY},
 	{"inhg",GSL_CONST_MKSA_INCH_OF_MERCURY},
 	{"inh2o",GSL_CONST_MKSA_INCH_OF_WATER},
 	{"psi",GSL_CONST_MKSA_PSI},
	{"poise",GSL_CONST_MKSA_POISE},
 	{"stokes",GSL_CONST_MKSA_STOKES},
	{"stilb",GSL_CONST_MKSA_STILB},
 	{"lumen",GSL_CONST_MKSA_LUMEN},
 	{"lux",GSL_CONST_MKSA_LUX},
 	{"phot",GSL_CONST_MKSA_PHOT},
 	{"ftcandle",GSL_CONST_MKSA_FOOTCANDLE},
	{"lambert",GSL_CONST_MKSA_LAMBERT},
	{"ftlambert",GSL_CONST_MKSA_FOOTLAMBERT},
	{"curie",GSL_CONST_MKSA_CURIE},
 	{"roentgen",GSL_CONST_MKSA_ROENTGEN},
 	{"rad",GSL_CONST_MKSA_RAD},
	{"c_cgs",GSL_CONST_CGSM_SPEED_OF_LIGHT},
	{"g_cgs",GSL_CONST_CGSM_GRAVITATIONAL_CONSTANT},
	{"h_cgs",GSL_CONST_CGSM_PLANCKS_CONSTANT_H},
	{"hbar_cgs",GSL_CONST_CGSM_PLANCKS_CONSTANT_HBAR},
	{"au_cgs",GSL_CONST_CGSM_ASTRONOMICAL_UNIT},
	{"ly_cgs",GSL_CONST_CGSM_LIGHT_YEAR},
	{"pc_cgs",GSL_CONST_CGSM_PARSEC},
	{"gg_cgs",GSL_CONST_CGSM_GRAV_ACCEL},
	{"ev_cgs",GSL_CONST_CGSM_ELECTRON_VOLT},
	{"me_cgs",GSL_CONST_CGSM_MASS_ELECTRON},
	{"mmu_cgs",GSL_CONST_CGSM_MASS_MUON},
	{"mp_cgs",GSL_CONST_CGSM_MASS_PROTON},
	{"mn_cgs",GSL_CONST_CGSM_MASS_NEUTRON},
	{"ry_cgs",GSL_CONST_CGSM_RYDBERG},
	{"k_cgs",GSL_CONST_CGSM_BOLTZMANN},
	{"mub_cgs",GSL_CONST_CGSM_BOHR_MAGNETON},
	{"mun_cgs",GSL_CONST_CGSM_NUCLEAR_MAGNETON},
	{"mue_cgs",GSL_CONST_CGSM_ELECTRON_MAGNETIC_MOMENT},
	{"mup_cgs",GSL_CONST_CGSM_PROTON_MAGNETIC_MOMENT},
	{"r0_cgs",GSL_CONST_CGSM_MOLAR_GAS},
	{"v0_cgs",GSL_CONST_CGSM_STANDARD_GAS_VOLUME},
	{"in_cgs",GSL_CONST_CGSM_INCH},
	{"ft_cgs",GSL_CONST_CGSM_FOOT},
	{"yard_cgs",GSL_CONST_CGSM_YARD},
	{"mile_cgs",GSL_CONST_CGSM_MILE},
	{"nile_cgs",GSL_CONST_CGSM_NAUTICAL_MILE},
	{"fathom_cgs",GSL_CONST_CGSM_FATHOM},
	{"mil_cgs",GSL_CONST_CGSM_MIL},
	{"pt_cgs",GSL_CONST_CGSM_POINT},
	{"texpt_cgs",GSL_CONST_CGSM_TEXPOINT},
	{"mu_cgs",GSL_CONST_CGSM_MICRON},
	{"A_cgs",GSL_CONST_CGSM_ANGSTROM},
	{"ha_cgs",GSL_CONST_CGSM_HECTARE},
	{"acre_cgs",GSL_CONST_CGSM_ACRE},
	{"barn_cgs",GSL_CONST_CGSM_BARN},
	{"ltr_cgs",GSL_CONST_CGSM_LITER},
	{"us_gallon-cgs",GSL_CONST_CGSM_US_GALLON},
	{"quart_cgs",GSL_CONST_CGSM_QUART},
	{"pint_cgs",GSL_CONST_CGSM_PINT},
	{"cup_cgs",GSL_CONST_CGSM_CUP},
	{"fluid_ouncs_cgs",GSL_CONST_CGSM_FLUID_OUNCE},
	{"tablespoon_cgs",GSL_CONST_CGSM_TABLESPOON},
	{"teaspoon_cgs",GSL_CONST_CGSM_TEASPOON},
	{"can_gallon_cgs",GSL_CONST_CGSM_CANADIAN_GALLON},
	{"uk_gallon_cgs",GSL_CONST_CGSM_UK_GALLON},
	{"mph_cgs",GSL_CONST_CGSM_MILES_PER_HOUR},
	{"kmh_cgs",GSL_CONST_CGSM_KILOMETERS_PER_HOUR},
	{"knot_cgs",GSL_CONST_CGSM_KNOT},
	{"pound_cgs",GSL_CONST_CGSM_POUND_MASS},
	{"ouncs_cgs",GSL_CONST_CGSM_OUNCE_MASS},
	{"ton_cgs",GSL_CONST_CGSM_TON},
	{"mton_cgs",GSL_CONST_CGSM_METRIC_TON},
	{"uk_ton_cgs",GSL_CONST_CGSM_UK_TON},
	{"troy_ounce_cgs",GSL_CONST_CGSM_TROY_OUNCE},
	{"carat_cgs",GSL_CONST_CGSM_CARAT},
	{"amu_cgs",GSL_CONST_CGSM_UNIFIED_ATOMIC_MASS},
	{"gram_cgs",GSL_CONST_CGSM_GRAM_FORCE},
	{"pound_force_cgs",GSL_CONST_CGSM_POUND_FORCE},
	{"kilopound_force_cgs",GSL_CONST_CGSM_KILOPOUND_FORCE},
	{"poundal_cgs",GSL_CONST_CGSM_POUNDAL},
	{"cal_cgs",GSL_CONST_CGSM_CALORIE},
	{"btu_cgs",GSL_CONST_CGSM_BTU},
	{"therm_cgs",GSL_CONST_CGSM_THERM},
	{"hp_cgs",GSL_CONST_CGSM_HORSEPOWER},
	{"bar_cgs",GSL_CONST_CGSM_BAR},
	{"atm_cgs",GSL_CONST_CGSM_STD_ATMOSPHERE},
	{"torr_cgs",GSL_CONST_CGSM_TORR},
	{"mhg_cgs",GSL_CONST_CGSM_METER_OF_MERCURY},
	{"inhg_cgs",GSL_CONST_CGSM_INCH_OF_MERCURY},
	{"inh2o_cgs",GSL_CONST_CGSM_INCH_OF_WATER},
	{"psi_cgs",GSL_CONST_CGSM_PSI},
	{"poise_cgs",GSL_CONST_CGSM_POISE},
	{"stokes_cgs",GSL_CONST_CGSM_STOKES},
	{"f_cgs",GSL_CONST_CGSM_FARADAY},
	{"e_cgs",GSL_CONST_CGSM_ELECTRON_CHARGE},
	{"gauss_cgs",GSL_CONST_CGSM_GAUSS},
	{"stilb_cgs",GSL_CONST_CGSM_STILB},
	{"lumen_cgs",GSL_CONST_CGSM_LUMEN},
	{"lux_cgs",GSL_CONST_CGSM_LUX},
	{"phot_cgs",GSL_CONST_CGSM_PHOT},
	{"ftcandle_cgs",GSL_CONST_CGSM_FOOTCANDLE},
	{"lambert_cgs",GSL_CONST_CGSM_LAMBERT},
	{"ftlambert_cgs",GSL_CONST_CGSM_FOOTLAMBERT},
	{"curie_cgs",GSL_CONST_CGSM_CURIE},
	{"roentgen_cgs",GSL_CONST_CGSM_ROENTGEN},
	{"rad_cgs",GSL_CONST_CGSM_RAD},
	{"sm_cgs",GSL_CONST_CGSM_SOLAR_MASS},
	{"a0_cgs",GSL_CONST_CGSM_BOHR_RADIUS},
#else
	{"c",GSL_CONST_MKS_SPEED_OF_LIGHT},
	{"mu0",GSL_CONST_MKS_VACUUM_PERMEABILITY},
	{"e0",GSL_CONST_MKS_VACUUM_PERMITTIVITY},
	{"na",GSL_CONST_NUM_AVOGADRO},
	{"f",GSL_CONST_MKS_FARADAY},
	{"k",GSL_CONST_MKS_BOLTZMANN},
	{"r0",GSL_CONST_MKS_MOLAR_GAS},
	{"v0",GSL_CONST_MKS_STANDARD_GAS_VOLUME},
	{"gauss",GSL_CONST_MKS_GAUSS},
	{"mu",GSL_CONST_MKS_MICRON},
	{"ha",GSL_CONST_MKS_HECTARE},
	{"mph",GSL_CONST_MKS_MILES_PER_HOUR},
	{"kmh",GSL_CONST_MKS_KILOMETERS_PER_HOUR},
	{"au",GSL_CONST_MKS_ASTRONOMICAL_UNIT},
	{"g",GSL_CONST_MKS_GRAVITATIONAL_CONSTANT},
	{"ly",GSL_CONST_MKS_LIGHT_YEAR},
	{"pc",GSL_CONST_MKS_PARSEC},
	{"gg",GSL_CONST_MKS_GRAV_ACCEL},
	{"ms",GSL_CONST_MKS_SOLAR_MASS},
	{"e",GSL_CONST_MKS_ELECTRON_CHARGE},
	{"ev",GSL_CONST_MKS_ELECTRON_VOLT},
	{"amu",GSL_CONST_MKS_UNIFIED_ATOMIC_MASS},
	{"me",GSL_CONST_MKS_MASS_ELECTRON},
	{"mmu",GSL_CONST_MKS_MASS_MUON},
	{"mp",GSL_CONST_MKS_MASS_PROTON},
	{"mn",GSL_CONST_MKS_MASS_NEUTRON},
	{"alpha",GSL_CONST_NUM_FINE_STRUCTURE},
	{"ry",GSL_CONST_MKS_RYDBERG},
	{"a0",GSL_CONST_MKS_BOHR_RADIUS},
	{"a",GSL_CONST_MKS_ANGSTROM},
	{"barn",GSL_CONST_MKS_BARN},
	{"mub",GSL_CONST_MKS_BOHR_MAGNETON},
	{"mun",GSL_CONST_MKS_NUCLEAR_MAGNETON},
	{"mue",GSL_CONST_MKS_ELECTRON_MAGNETIC_MOMENT},
	{"mup",GSL_CONST_MKS_PROTON_MAGNETIC_MOMENT},
	{"min",GSL_CONST_MKS_MINUTE},
	{"h",GSL_CONST_MKS_HOUR},
	{"d",GSL_CONST_MKS_DAY},
	{"week",GSL_CONST_MKS_WEEK},
	{"in",GSL_CONST_MKS_INCH},
	{"ft",GSL_CONST_MKS_FOOT},
	{"yard",GSL_CONST_MKS_YARD},
	{"mile",GSL_CONST_MKS_MILE},
	{"mil",GSL_CONST_MKS_MIL},
	{"nmile",GSL_CONST_MKS_NAUTICAL_MILE},
	{"fathom",GSL_CONST_MKS_FATHOM},
	{"knot",GSL_CONST_MKS_KNOT},
	{"pt",GSL_CONST_MKS_POINT},
	{"texpt",GSL_CONST_MKS_TEXPOINT},
	{"acre",GSL_CONST_MKS_ACRE},
	{"ltr",GSL_CONST_MKS_LITER},
	{"us_gallon",GSL_CONST_MKS_US_GALLON},
	{"can_gallon",GSL_CONST_MKS_CANADIAN_GALLON},
	{"uk_gallon",GSL_CONST_MKS_UK_GALLON},
	{"quart",GSL_CONST_MKS_QUART},
	{"pint",GSL_CONST_MKS_PINT},
	{"pound",GSL_CONST_MKS_POUND_MASS},
	{"ounce",GSL_CONST_MKS_OUNCE_MASS},
 	{"ton",GSL_CONST_MKS_TON},
 	{"mton",GSL_CONST_MKS_METRIC_TON},
 	{"uk_ton",GSL_CONST_MKS_UK_TON},
 	{"troy_ounce",GSL_CONST_MKS_TROY_OUNCE},
 	{"carat",GSL_CONST_MKS_CARAT},
 	{"gram_force",GSL_CONST_MKS_GRAM_FORCE},
 	{"pound_force",GSL_CONST_MKS_POUND_FORCE},
 	{"kilepound_force",GSL_CONST_MKS_KILOPOUND_FORCE},
 	{"poundal",GSL_CONST_MKS_POUNDAL},
	{"cal",GSL_CONST_MKS_CALORIE},
 	{"btu",GSL_CONST_MKS_BTU},
 	{"therm",GSL_CONST_MKS_THERM},
 	{"hp",GSL_CONST_MKS_HORSEPOWER},
	{"bar",GSL_CONST_MKS_BAR},
 	{"atm",GSL_CONST_MKS_STD_ATMOSPHERE},
 	{"torr",GSL_CONST_MKS_TORR},
 	{"mhg",GSL_CONST_MKS_METER_OF_MERCURY},
 	{"inhg",GSL_CONST_MKS_INCH_OF_MERCURY},
 	{"inh2o",GSL_CONST_MKS_INCH_OF_WATER},
 	{"psi",GSL_CONST_MKS_PSI},
	{"poise",GSL_CONST_MKS_POISE},
 	{"stokes",GSL_CONST_MKS_STOKES},
	{"stilb",GSL_CONST_MKS_STILB},
 	{"lumen",GSL_CONST_MKS_LUMEN},
 	{"lux",GSL_CONST_MKS_LUX},
 	{"phot",GSL_CONST_MKS_PHOT},
 	{"ftcandle",GSL_CONST_MKS_FOOTCANDLE},
	{"lambert",GSL_CONST_MKS_LAMBERT},
	{"ftlambert",GSL_CONST_MKS_FOOTLAMBERT},
	{"curie",GSL_CONST_MKS_CURIE},
 	{"roentgen",GSL_CONST_MKS_ROENTGEN},
 	{"rad",GSL_CONST_MKS_RAD},
	{"c_cgs",GSL_CONST_CGS_SPEED_OF_LIGHT},
	{"g_cgs",GSL_CONST_CGS_GRAVITATIONAL_CONSTANT},
	{"h_cgs",GSL_CONST_CGS_PLANCKS_CONSTANT_H},
	{"hbar_cgs",GSL_CONST_CGS_PLANCKS_CONSTANT_HBAR},
	{"mu0_cgs",GSL_CONST_CGS_VACUUM_PERMEABILITY},
	{"au_cgs",GSL_CONST_CGS_ASTRONOMICAL_UNIT},
	{"ly_cgs",GSL_CONST_CGS_LIGHT_YEAR},
	{"pc_cgs",GSL_CONST_CGS_PARSEC},
	{"g_cgs",GSL_CONST_CGS_GRAV_ACCEL},
	{"ev_cgs",GSL_CONST_CGS_ELECTRON_VOLT},
	{"me_cgs",GSL_CONST_CGS_MASS_ELECTRON},
	{"mmu_cgs",GSL_CONST_CGS_MASS_MUON},
	{"mp_cgs",GSL_CONST_CGS_MASS_PROTON},
	{"mn_cgs",GSL_CONST_CGS_MASS_NEUTRON},
	{"ry_cgs",GSL_CONST_CGS_RYDBERG},
	{"k_cgs",GSL_CONST_CGS_BOLTZMANN},
	{"mub_cgs",GSL_CONST_CGS_BOHR_MAGNETON},
	{"mun_cgs",GSL_CONST_CGS_NUCLEAR_MAGNETON},
	{"mue_cgs",GSL_CONST_CGS_ELECTRON_MAGNETIC_MOMENT},
	{"mup_cgs",GSL_CONST_CGS_PROTON_MAGNETIC_MOMENT},
	{"r0_cgs",GSL_CONST_CGS_MOLAR_GAS},
	{"v0_cgs",GSL_CONST_CGS_STANDARD_GAS_VOLUME},
	{"in_cgs",GSL_CONST_CGS_INCH},
	{"ft_cgs",GSL_CONST_CGS_FOOT},
	{"yard_cgs",GSL_CONST_CGS_YARD},
	{"mile_cgs",GSL_CONST_CGS_MILE},
	{"nile_cgs",GSL_CONST_CGS_NAUTICAL_MILE},
	{"fathom_cgs",GSL_CONST_CGS_FATHOM},
	{"mil_cgs",GSL_CONST_CGS_MIL},
	{"pt_cgs",GSL_CONST_CGS_POINT},
	{"texpt_cgs",GSL_CONST_CGS_TEXPOINT},
	{"mu_cgs",GSL_CONST_CGS_MICRON},
	{"a_cgs",GSL_CONST_CGS_ANGSTROM},
	{"ha_cgs",GSL_CONST_CGS_HECTARE},
	{"acre_cgs",GSL_CONST_CGS_ACRE},
	{"barn_cgs",GSL_CONST_CGS_BARN},
	{"ltr_cgs",GSL_CONST_CGS_LITER},
	{"us_gallon-cgs",GSL_CONST_CGS_US_GALLON},
	{"quart_cgs",GSL_CONST_CGS_QUART},
	{"pint_cgs",GSL_CONST_CGS_PINT},
	{"cup_cgs",GSL_CONST_CGS_CUP},
	{"fluid_ouncs_cgs",GSL_CONST_CGS_FLUID_OUNCE},
	{"tablespoon_cgs",GSL_CONST_CGS_TABLESPOON},
	{"teaspoon_cgs",GSL_CONST_CGS_TEASPOON},
	{"can_gallon_cgs",GSL_CONST_CGS_CANADIAN_GALLON},
	{"uk_gallon_cgs",GSL_CONST_CGS_UK_GALLON},
	{"mph_cgs",GSL_CONST_CGS_MILES_PER_HOUR},
	{"kmh_cgs",GSL_CONST_CGS_KILOMETERS_PER_HOUR},
	{"knot_cgs",GSL_CONST_CGS_KNOT},
	{"pound_cgs",GSL_CONST_CGS_POUND_MASS},
	{"ouncs_cgs",GSL_CONST_CGS_OUNCE_MASS},
	{"ton_cgs",GSL_CONST_CGS_TON},
	{"mton_cgs",GSL_CONST_CGS_METRIC_TON},
	{"uk_ton_cgs",GSL_CONST_CGS_UK_TON},
	{"troy_ounce_cgs",GSL_CONST_CGS_TROY_OUNCE},
	{"carat_cgs",GSL_CONST_CGS_CARAT},
	{"amu_cgs",GSL_CONST_CGS_UNIFIED_ATOMIC_MASS},
	{"gram_cgs",GSL_CONST_CGS_GRAM_FORCE},
	{"pound_force_cgs",GSL_CONST_CGS_POUND_FORCE},
	{"kilopound_force_cgs",GSL_CONST_CGS_KILOPOUND_FORCE},
	{"poundal_cgs",GSL_CONST_CGS_POUNDAL},
	{"cal_cgs",GSL_CONST_CGS_CALORIE},
	{"btu_cgs",GSL_CONST_CGS_BTU},
	{"therm_cgs",GSL_CONST_CGS_THERM},
	{"hp_cgs",GSL_CONST_CGS_HORSEPOWER},
	{"bar_cgs",GSL_CONST_CGS_BAR},
	{"atm_cgs",GSL_CONST_CGS_STD_ATMOSPHERE},
	{"torr_cgs",GSL_CONST_CGS_TORR},
	{"mhg_cgs",GSL_CONST_CGS_METER_OF_MERCURY},
	{"inhg_cgs",GSL_CONST_CGS_INCH_OF_MERCURY},
	{"inh2o_cgs",GSL_CONST_CGS_INCH_OF_WATER},
	{"psi_cgs",GSL_CONST_CGS_PSI},
	{"poise_cgs",GSL_CONST_CGS_POISE},
	{"stokes_cgs",GSL_CONST_CGS_STOKES},
	{"f_cgs",GSL_CONST_CGS_FARADAY},
	{"e_cgs",GSL_CONST_CGS_ELECTRON_CHARGE},
	{"g_cgs",GSL_CONST_CGS_GAUSS},
	{"stilb_cgs",GSL_CONST_CGS_STILB},
	{"lumen_cgs",GSL_CONST_CGS_LUMEN},
	{"lux_cgs",GSL_CONST_CGS_LUX},
	{"phot_cgs",GSL_CONST_CGS_PHOT},
	{"ftcandle_cgs",GSL_CONST_CGS_FOOTCANDLE},
	{"lambert_cgs",GSL_CONST_CGS_LAMBERT},
	{"ftlambert_cgs",GSL_CONST_CGS_FOOTLAMBERT},
	{"curie_cgs",GSL_CONST_CGS_CURIE},
	{"roentgen_cgs",GSL_CONST_CGS_ROENTGEN},
	{"rad_cgs",GSL_CONST_CGS_RAD},
	{"sm_cgs",GSL_CONST_CGS_SOLAR_MASS},
	{"a0_cgs",GSL_CONST_CGS_BOHR_RADIUS},
	{"e0_cgs",GSL_CONST_CGS_VACUUM_PERMITTIVITY},
#endif
#endif
	{0,0}
};

#endif /* CONSTANTS_H */
