#!/bin/bash

#  Copyright (c) Abraham vd Merwe <abz@blio.net>
#  All rights reserved.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. Neither the name of the author nor the names of other contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
#  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
#  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
#  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
#  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
#  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

DAEMON="/usr/local/sbin/ixbiff"

###############################################

function showhelp ()
{
  echo "usage: ${0/*\//} [ start | stop | restart ]"
  exit 1
}

function start_daemon ()
{
	local pid
	pid=$(ps auxw | grep "$DAEMON" | grep -v grep | awk '{ print $2 }')
	if [[ 0 != ${#pid} ]]
	then
		echo "The biff daemon is already running."
		exit 0
	fi
	echo -n "Starting biff daemon..."
	(($DAEMON > /dev/null 2>&1) && echo " succeeded.") || echo " failed."
}

function stop_daemon ()
{
	echo -n "Stopping biff daemon..."
	((kill -TERM $(ps auxw | grep "$DAEMON" | grep -v grep | awk '{ print $2 }') > /dev/null 2>&1) && echo " succeeded.") || echo " failed."
}

function restart_daemon ()
{
	echo -n "Restarting biff daemon..."
	(stop_daemon && sleep 1 && start_daemon) 2> /dev/null 1>&2
	echo " done."
}

function reload_daemon ()
{
	echo -n "Reloading biff daemon..."
	killall -HUP "$DAEMON" > /dev/null 1>&2
	echo " done."
}

###############################################

test -x $DAEMON || exit 0

if [[ $# == 0 ]]
then
	start_daemon
	exit 0
fi

if [[ $# == 1 ]]
then
	case "$1" in
		"start") start_daemon ;;
		"stop") stop_daemon ;;
		"reload"|"force-reload") reload_daemon ;;
		"restart") restart_daemon ;;
		*) showhelp ;;
	esac
	exit 0
fi

showhelp
exit 0

