#!/usr/bin/perl
#
#
# By Stefan 'tommie' Tomanek, stefan@kann-nix.org
#
#
# This script works fine on DFN (german universities) and T-Oline sites
#
# 01.03.2002
# *Changed to GPL
#
# 15.03.2002
# *Now works on QUERIES as well


use vars qw($VERSION %IRSSI);

$VERSION = "20020315";
%IRSSI = (
        authors     => "Stefan Tomanek",
	contact     => "stefan\@pico.ruhr.de",
	name        => "localize",
	description => "Localizes users using the localizer database (http://jan.kneschke.de/projects/localizer/index.php)",
	license     => "GPLv2",
	url         => "",
	changed     => "$VERSION",
);

use strict;
use Irssi;
use HTTP::Request::Common;
use LWP::UserAgent;

sub fetch_data {
	my ($ip) = @_;
	my $ua = LWP::UserAgent->new;
	my $request = HTTP::Request->new('GET', 'http://jan.kneschke.de/projects/localizer/index.php?query='.$ip);
	my $response = $ua->request($request);
	return($response->content);
}

sub parse_page {
	my ($page) = @_;
	my ($provider, $city, $province, $country);
	my %location;
	my @lines = split('\n', $page);
	foreach (@lines) {
		my $line = $_;
		(/Host not found, using/) && return(%location);
		foreach ( "(Backbone-)Provider", "City", "Country", "Province") {
			my $rexexpstr = $_;
			$rexexpstr =~ s/\(/\\\(/;
			$rexexpstr =~ s/\)/\\\)/;
			my $regexp = "^<tr><td><b>".$rexexpstr."</b></td><td>.*";
			if ($line =~ /$regexp/) {
				my $result = $line;
				$result =~ s/(<.*?>)|$rexexpstr//ig;
				%location->{lc($_)} = $result;
			}
		}
	}
	return (%location);
}

sub cmd_localize {
	my ($nicknames, $server, $witem) = @_;
	foreach my $nickname (split(/ /, $nicknames)) {
		$nickname =~ s/\ $//;
		my $ip;
		my $target;
		if (not $nickname =~ /@/) {
			my $host;
			if ($witem->{'type'} eq 'CHANNEL') {
				my $nick = $witem->nick_find($nickname);
				$host = $nick->{'host'};
			} elsif ($witem->{'type'} eq 'QUERY') {
				$host = $witem->{'address'};
			}
			if (not $host) {
				Irssi::print('%R>>%n Unable to localize '.$nickname.', not on channel', MSGLEVEL_CLIENTCRAP);
				return;
			};
			my @hostname = split(/@/, $host);
			$ip = $hostname[1];
			$target = $nickname;
		} else { $nickname =~ s/@//; $ip=$nickname; $target=$ip;}
		my %location = parse_page (fetch_data($ip));
		if (not %location) {
			Irssi::print('%R>>%n Unable to localize '.$nickname, MSGLEVEL_CLIENTCRAP);
			return;
		}
		Irssi::print('%R>>%n Location of '.$target.':', MSGLEVEL_CLIENTCRAP);
		foreach (keys(%location)) {
			Irssi::print('%B'.$_.':%n '.%location->{$_}, MSGLEVEL_CLIENTCRAP);
		}
		Irssi::print('%R<<%n', MSGLEVEL_CLIENTCRAP);
	}
}

sub cmd_citys {
	my ($args, $server, $witem) = @_;
	my %citys;
	my $channel = $witem;
	foreach my $nick ($channel->nicks) {
		my @hostname = split(/@/, $nick->{'host'});
		my %location = parse_page (fetch_data(@hostname[1]));
		if (exists $location{'city'}) {
			my $city = $location{'city'};
			push @{$citys{$city}}, $nick->{'nick'} ;
		}
	}
	Irssi::print('%R<<>>%n Creating location-profile of '.$channel->{name}, MSGLEVEL_CLIENTCRAP);
	foreach my $city (keys %citys) {
		Irssi::print('%R>>%n users from '.$city.':', MSGLEVEL_CLIENTCRAP);
		my @list = @{$citys{$city}};
		foreach (@list) { Irssi::print('%B->%n'.$_, MSGLEVEL_CLIENTCRAP); }
	}
}

Irssi::command_bind('localize', 'cmd_localize');
Irssi::command_bind('citys', 'cmd_citys');
