// --------------------------------------------------------------------
// The Ipe object factory.
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ipefactory.h"
#include "ipepath.h"
#include "ipemark.h"
#include "ipetext.h"
#include "ipeimage.h"
#include "iperef.h"

// --------------------------------------------------------------------

/*! \class IpeObjectFactory
  \ingroup high
  \brief Factory for Ipe leaf objects.
*/

//! Create an Ipe object by calling the right constructor.
IpeObject *IpeObjectFactory::CreateObject(IpeRepository *rep,
					  IpeString name,
					  const IpeXmlAttributes &attr,
					  IpeString data)
{
  if (name == "path")
    return new IpePath(rep, attr, data);
  else if (name == "mark")
    return new IpeMark(rep, attr, data);
  else if (name == "text")
    return new IpeText(rep, attr, data);
  else if (name == "image")
    return new IpeImage(rep, attr, data);
  else if (name == "ref")
    return new IpeReference(rep, attr, data);
  else
    return 0;
}

//! Create an IpeImage with a given bitmap.
IpeObject *IpeObjectFactory::CreateImage(IpeRepository *rep,
					 IpeString /*name*/,
					 const IpeXmlAttributes &attr,
					 IpeBitmap bitmap)
{
  return new IpeImage(rep, attr, bitmap);
}

// --------------------------------------------------------------------
