#!/bin/sh
###############################################
# HtmlHeadLine.sh (2000/11/18)
    VERSION=21.8
#   Copyright (C) 2000 Toshiaki kanosue.      #
# e-mail: ckaba313@sutv.zaq.ne.jp (Japan)     #
# http://kano.technolust.cx/HtmlHeadLine.html #
# :set ts=4 for vim                           #
###############################################
if [ "$DISPLAY_ACCESS" = "" ]; then DISPLAY_ACCESS=NO; fi
if [ "$PRESENT_ONLY"   = "" ]; then PRESENT_ONLY=NO; fi
if [ "$NEW_ONLY"       = "" ]; then NEW_ONLY=NO; fi
if [ "$OLD_FILE_NAME"  = "" ]; then OLD_FILE_NAME=~/.old.HHL.output.html; fi
if [ "$AWK_NAME"       = "" ]; then AWK_NAME=awk; fi
if [ "$MAX_RETRYS"     = "" ]; then MAX_RETRYS=3; fi
if [ "$PROXY_ONLY"     = "" ]; then PROXY_ONLY=NO; fi
if [ "$RECV_TIMEOUT"   = "" ]; then RECV_TIMEOUT=30; fi
if [ "$BACK_COLOR"     = "" ]; then BACK_COLOR="#e6e6fa"; fi
if [ "$OTHER_WINDOW"   = "" ]; then OTHER_WINDOW=NO; fi
if [ "$DESC_TABLE"     = "" ]; then DESC_TABLE=NO; fi
if [ "$BIG_FONT"       = "" ]; then BIG_FONT=NO; fi
if [ "$HTML_NAME"      = "" ]; then HTML_NAME=/tmp/`date +%y%m%d`.`date +%H%M%S`.html; fi
if [ "$SAVE_OUTPUT"    = "" ]; then SAVE_OUTPUT=NO; fi
if [ "$OMIT_SITENAME"  = "" ]; then OMIT_SITENAME=YES; fi
if [ "$FILE_ONLY"      = "" ]; then FILE_ONLY=NO; fi
if [ "$KEYWORD"        = "" ]; then KEYWORD=""; fi
if [ "$DATA_NAME"      = "" ]; then DATA_NAME=/tmp/for.MemoPanel.dat; fi
if [ "$SITE_TABLE"     = "" ]; then SITE_TABLE=/usr/local/bin/SITES.table; fi
if [ "$PLAY_MUSIC"     = "" ]; then
	PLAY_MUSIC="/usr/local/bin/wavplay ~/wav/Bweep.wav > /dev/null 2>&1"
fi
#####################################################
if [ "$DEBUG"         = "" ]; then DEBUG=0; fi
LANG2=`echo $LANG|cut -c1-2`
SITE_TABLE1=/tmp/site_table.$$; SCRIPT7=/tmp/script7.$$
AWK1=/tmp/awk1.$$;   AWK2=/tmp/awk2.$$;   AWK3=/tmp/awk3.$$;   AWK4=/tmp/awk4.$$
AWK5=/tmp/awk5.$$;   AWK6=/tmp/awk6.$$;   AWK7=/tmp/awk7.$$;   AWK8=/tmp/awk8.$$
AWK9=/tmp/awk9.$$;   AWK10=/tmp/awk10.$$; AWK11=/tmp/awk11.$$; AWK12=/tmp/awk12.$$
AWK13=/tmp/awk13.$$; AWK14=/tmp/awk14.$$; AWK15=/tmp/awk15.$$; AWK16=/tmp/awk16.$$
AWK17=/tmp/awk17.$$; AWK18=/tmp/awk18.$$; AWK19=/tmp/awk19.$$; AWK20=/tmp/awk20.$$
AWK21=/tmp/awk21.$$; AWK22=/tmp/awk22.$$; AWK23=/tmp/awk23.$$; AWK24=/tmp/awk24.$$
AWK25=/tmp/awk25.$$; AWK26=/tmp/awk26.$$; AWK27=/tmp/awk27.$$; AWK28=/tmp/awk28.$$
AWK29=/tmp/awk29.$$; AWK30=/tmp/awk30.$$; AWK31=/tmp/awk31.$$; AWK32=/tmp/awk32.$$
AWK33=/tmp/awk33.$$; AWK34=/tmp/awk34.$$; AWK35=/tmp/awk35.$$; AWK36=/tmp/awk36.$$
AWK37=/tmp/awk37.$$; AWK38=/tmp/awk38.$$; AWK39=/tmp/awk39.$$; AWK40=/tmp/awk40.$$
AWK41=/tmp/awk41.$$; AWK42=/tmp/awk42.$$; AWK43=/tmp/awk43.$$; AWK44=/tmp/awk44.$$
AWK45=/tmp/awk45.$$; AWK46=/tmp/awk46.$$; AWK47=/tmp/awk47.$$; AWK48=/tmp/awk48.$$
AWK49=/tmp/awk49.$$; AWK50=/tmp/awk50.$$; AWK51=/tmp/awk51.$$; AWK52=/tmp/awk52.$$
AWK53=/tmp/awk53.$$; AWK54=/tmp/awk54.$$; AWK55=/tmp/awk55.$$; AWK56=/tmp/awk56.$$
AWK57=/tmp/awk57.$$; AWK58=/tmp/awk58.$$; AWK59=/tmp/awk59.$$; AWK60=/tmp/awk60.$$
AWK61=/tmp/awk61.$$; AWK62=/tmp/awk62.$$; AWK63=/tmp/awk63.$$; AWK64=/tmp/awk64.$$
AWK65=/tmp/awk65.$$; AWK66=/tmp/awk66.$$; AWK67=/tmp/awk67.$$; AWK68=/tmp/awk68.$$
AWK69=/tmp/awk69.$$; AWK70=/tmp/awk70.$$; AWK71=/tmp/awk71.$$; AWK72=/tmp/awk72.$$
AWK73=/tmp/awk73.$$; AWK74=/tmp/awk74.$$; AWK75=/tmp/awk75.$$; AWK76=/tmp/awk76.$$
AWK77=/tmp/awk77.$$; AWK78=/tmp/awk78.$$; AWK79=/tmp/awk79.$$; AWK80=/tmp/awk80.$$
AWK81=/tmp/awk81.$$; AWK82=/tmp/awk82.$$; AWK83=/tmp/awk83.$$; AWK84=/tmp/awk84.$$
AWK85=/tmp/awk85.$$; AWK86=/tmp/awk86.$$; AWK87=/tmp/awk87.$$; AWK88=/tmp/awk88.$$
AWK89=/tmp/awk89.$$; AWK90=/tmp/awk90.$$; AWK91=/tmp/awk91.$$; AWK92=/tmp/awk92.$$
AWK93=/tmp/awk93.$$; AWK94=/tmp/awk94.$$; AWK95=/tmp/awk95.$$; AWK96=/tmp/awk96.$$
AWK97=/tmp/awk97.$$; AWK98=/tmp/awk98.$$; AWK99=/tmp/awk99.$$;
AWK100=/tmp/awk100.$$; AWK101=/tmp/awk101.$$; AWK102=/tmp/awk102.$$; AWK103=/tmp/awk103.$$
AWK104=/tmp/awk104.$$; AWK105=/tmp/awk105.$$; AWK106=/tmp/awk106.$$; AWK107=/tmp/awk107.$$
AWK108=/tmp/awk108.$$; AWK109=/tmp/awk109.$$; AWK110=/tmp/awk110.$$; AWK111=/tmp/awk111.$$
AWK112=/tmp/awk112.$$; AWK113=/tmp/awk113.$$; AWK114=/tmp/awk114.$$; AWK115=/tmp/awk115.$$
AWK116=/tmp/awk116.$$; AWK117=/tmp/awk117.$$; AWK118=/tmp/awk118.$$; AWK119=/tmp/awk119.$$
AWK120=/tmp/awk120.$$; AWK121=/tmp/awk121.$$; AWK122=/tmp/awk122.$$; AWK123=/tmp/awk123.$$
AWK124=/tmp/awk124.$$; AWK125=/tmp/awk125.$$; AWK126=/tmp/awk126.$$; AWK127=/tmp/awk127.$$
AWK128=/tmp/awk128.$$; AWK129=/tmp/awk129.$$; AWK130=/tmp/awk130.$$; AWK131=/tmp/awk131.$$
AWK132=/tmp/awk132.$$; AWK133=/tmp/awk133.$$; AWK134=/tmp/awk134.$$; AWK135=/tmp/awk135.$$
AWK136=/tmp/awk136.$$; AWK137=/tmp/awk137.$$; AWK138=/tmp/awk138.$$; AWK139=/tmp/awk139.$$;
AWK140=/tmp/awk140.$$; AWK141=/tmp/awk141.$$;
# New-1
CUT1=/tmp/cut1.$$; PERL1=/tmp/perl1.$$.pl; LYNX2=/tmp/perl2.$$.pl; LYNX3=/tmp/perl3.$$.pl
NAM1=/tmp/work1.$$; NAM2=/tmp/work2.$$; NAM3=/tmp/work3.$$; NAM4=/tmp/work4.$$
NAM5=/tmp/work5.$$; NAM6=/tmp/work6.$$; NAM7=/tmp/work7.$$; BUG1=bug.table
AWK_CMP=/tmp/awk_cmp.$$; LYNX_CMD="lynx -anonymous -dump"
YYYY=`date +%Y`
kill1() {
	sleep $[ $RECV_TIMEOUT + 2 ] # plus 2 seconds
	SON_PID=`ps $PID w|grep "$1"|$AWK_NAME '{if(! index($0," grep ")) print $1}'`
	if [ "$SON_PID" != "" ]; then
		echo "@@ killed by timeout: $1 @@"
		kill -KILL $SON_PID
	fi
}
call_awk2() {
	$AWK_NAME -f $1 -f $CUT1 $NAM2 >> $NAM1
}
call_awk1() {
	case "$1" in
	kernel)				call_awk2 $AWK5 ;;
	gnomeSoft)			call_awk2 $AWK4 ;;
	technetcast)		call_awk2 $AWK7 ;;
	nwfusion)			call_awk2 $AWK8 ;;
	wiredPalmpilot)		call_awk2 $AWK9 ;;
	svlug)				call_awk2 $AWK10 ;;
	nikkeibp)			call_awk2 $AWK11 ;;
	php)				call_awk2 $AWK12 ;;
	alsa-project)		call_awk2 $AWK13 ;;
	suse)				call_awk2 $AWK14 ;;
	turbolinux)			call_awk2 $AWK15 ;;
	mysql)				call_awk2 $AWK16 ;;
	postgresql)			call_awk2 $AWK17 ;;
	iss)				call_awk2 $AWK18 ;;
	securityfocus)		call_awk2 $AWK19 ;;
	securiteam)			call_awk2 $AWK20 ;;
	antionline)			call_awk2 $AWK21 ;;
	newsbytes)			call_awk2 $AWK22 ;;
	currents)			call_awk2 $AWK23 ;;
	excite)				call_awk2 $AWK24 ;;
	securityportal)		call_awk2 $AWK25 ;;
	zdnet)				call_awk2 $AWK26 ;;
	idg)				call_awk2 $AWK27 ;;
	webclub)			call_awk2 $AWK28 ;;
	net-security)		call_awk2 $AWK29 ;;
	hardwarecentral)	call_awk2 $AWK30 ;;
	computerworld)		call_awk2 $AWK31 ;;
	news-excite)		call_awk2 $AWK32 ;;
	infowar)			call_awk2 $AWK33 ;;
	gnomeNews)			call_awk2 $AWK34 ;;
	linuxlock)			call_awk2 $AWK35 ;;
	linuxplace)			call_awk2 $AWK36 ;;
	nikkansports)		if [ "$LANG2" = "ja" ]; then
							nkf -em $NAM2 > $NAM3; mv $NAM3 $NAM2
						fi
						call_awk2 $AWK37 ;;
#	in use $AWK38
	debianJp)			if [ "$LANG2" = "ja" ]; then
							nkf -em $NAM2 > $NAM3; mv $NAM3 $NAM2
						fi
						call_awk2 $AWK39 ;;
	cnn)				call_awk2 $AWK40 ;;
	bugnet)				call_awk2 $AWK41 ;;
	techweb)			call_awk2 $AWK42 ;;
	littleigloo)		call_awk2 $AWK43 ;;
	wiredTechnology)	call_awk2 $AWK44 ;;
	hackernews)			call_awk2 $AWK45 ;;
	enlightenment)		call_awk2 $AWK46 ;;
	linuxComDownload)	call_awk2 $AWK47 ;;
	insecure)			call_awk2 $AWK48 ;;
	cnet)				call_awk2 $AWK49 ;;
	linuxOrgNews)		call_awk2 $AWK50 ;;
	linuxOrgBook)		call_awk2 $AWK51 ;;
	debian)				call_awk2 $AWK52 ;;
	ibiblio)			call_awk2 $AWK53 ;;
	emusic)				call_awk2 $AWK54 ;;
	music)				call_awk2 $AWK55 ;;
	real)				call_awk2 $AWK56 ;;
	realguide)			call_awk2 $AWK57 ;;
	film)				call_awk2 $AWK58 ;;
	icecast)			call_awk2 $AWK59 ;;
	shoutcast)			call_awk2 $AWK60 ;;
	heise)				call_awk2 $AWK61 ;;
	gtkThemes)			call_awk2 $AWK62 ;;
	eThemes)			call_awk2 $AWK63 ;;
	cbs)				call_awk2 $AWK64 ;;
	fortune)			call_awk2 $AWK65 ;;
	forbes)				call_awk2 $AWK66 ;;
	yahoo)				call_awk2 $AWK67 ;;
	gamefan)			call_awk2 $AWK68 ;;
	kuro5hin)			call_awk2 $AWK69 ;;
	bbc)				call_awk2 $AWK70 ;;
	linuxsecurity)		call_awk2 $AWK71 ;;
	oreilly)			call_awk2 $AWK72 ;;
	pro-linux)			call_awk2 $AWK73 ;;
	digitalblasphemy)	call_awk2 $AWK74 ;;
	theregister)		call_awk2 $AWK75 ;;
	linuxhq)			call_awk2 $AWK76 ;;
	tky)				call_awk2 $AWK77 ;;
	kernelnotes)		call_awk2 $AWK78 ;;
	anandtech)			call_awk2 $AWK79 ;;
	linux-mandrake)		call_awk2 $AWK80 ;;
	fokus)				call_awk2 $AWK81 ;;
	linux-magazin)		call_awk2 $AWK82 ;;
	linuxdevices)		call_awk2 $AWK83 ;;
	linuxworld)			call_awk2 $AWK84 ;;
	linuxfr)			call_awk2 $AWK85 ;;
	nodevice)			call_awk2 $AWK86 ;;
	cs)					call_awk2 $AWK87 ;;
	salon)				call_awk2 $AWK88 ;;
	linevents)			call_awk2 $AWK89 ;;
	computeruser)		$AWK_NAME '{gsub("\r","\n",$0);print}' $NAM2 > $NAM5
						mv $NAM5 $NAM2
						call_awk2 $AWK90 ;;
	linuxinsider)		call_awk2 $AWK91 ;;
	sharkyextreme)		call_awk2 $AWK92 ;;
	ecommercetimes)		call_awk2 $AWK93 ;;
	linuxnews)			call_awk2 $AWK94 ;;
	newsnow)			call_awk2 $AWK95 ;;
	linhardware)		call_awk2 $AWK96 ;;
	linuxdev)			call_awk2 $AWK97 ;;
	linuxmonth)			call_awk2 $AWK98 ;;
	portalux)			call_awk2 $AWK99 ;;
	redhat)				call_awk2 $AWK100 ;;
	xmlhack)			call_awk2 $AWK101 ;;
	perl)				call_awk2 $AWK102 ;;
	webcomics)			call_awk2 $AWK103 ;;
	nospoon)			call_awk2 $AWK104 ;;
	efront)				call_awk2 $AWK105 ;;
	mklinux)			call_awk2 $AWK106 ;;
	amdzone)			call_awk2 $AWK107 ;;
	gnu)				call_awk2 $AWK108 ;;
	screenshots)		call_awk2 $AWK109 ;;
	isonews)			call_awk2 $AWK110 ;;
	digi)				call_awk2 $AWK111 ;;
	vg)					call_awk2 $AWK112 ;;
	dagbladet)			call_awk2 $AWK113 ;;
	bizit)				if [ "$LANG2" = "ja" ]; then
							nkf -em $NAM2 > $NAM3; mv $NAM3 $NAM2
						fi
						call_awk2 $AWK114 ;;
	xemacs)				call_awk2 $AWK115 ;;
	sabah)				call_awk2 $AWK116 ;;
	laser5)				if [ "$LANG2" = "ja" ]; then
							nkf -em $NAM2 > $NAM3; mv $NAM3 $NAM2
						fi
						call_awk2 $AWK117 ;;
	ninemsn)			call_awk2 $AWK118 ;;
	abc)				call_awk2 $AWK119 ;;
	asThemes)			call_awk2 $AWK120 ;;
	sawmillThemes)		call_awk2 $AWK121 ;;
	kdeThemes)			call_awk2 $AWK122 ;;
	ascii)				if [ "$LANG2" = "ja" ]; then
							nkf -em $NAM2 > $NAM3; mv $NAM3 $NAM2
						fi
						call_awk2 $AWK124 ;;
	spaceviews)			call_awk2 $AWK125 ;;
	space)				call_awk2 $AWK126 ;;
	idgLinux)			call_awk2 $AWK127 ;;
	security-informer)	call_awk2 $AWK128 ;;
	securitysearch) 	call_awk2 $AWK129 ;;
	vim) 				call_awk2 $AWK130 ;;
	15secondsHp)		call_awk2 $AWK131 ;;
	15seconds)			call_awk2 $AWK132 ;;
	softseek)			call_awk2 $AWK133 ;;
	linuxguruz)			call_awk2 $AWK134 ;;
	linuxguruzTut)		call_awk2 $AWK135 ;;
	hollywoodbitchslap)	call_awk2 $AWK136 ;;
	vector)				if [ "$LANG2" = "ja" ]; then
							nkf -em $NAM2|awk '{gsub("\r","\n");print}' > $NAM3; mv $NAM3 $NAM2
						fi
						call_awk2 $AWK137 ;;
	stormix)			call_awk2 $AWK138 ;;
	bestlinux)			call_awk2 $AWK139 ;;
	corel)				call_awk2 $AWK140 ;;
	tagesschau)			call_awk2 $AWK141 ;;
# New-2
	*)					cat $NAM2 >> $NAM1 ;;
	esac
}
cat > $CUT1 <<@
function make_scr(url) {
	if(substr(scr,1,7) != "http://" && substr(scr,1,6) != "ftp://")
		scr="http://" url ((substr(scr,1,1) == "/") ? "" : "/") scr
}
function make_link(url) {
	if(substr(link,1,7) != "http://" && substr(link,1,6) != "ftp://")
		link="http://" url ((substr(link,1,1) == "/") ? "" : "/") link
}
function print2(items) { # items = 2 ~ 5
	if(! length(title)) { title=link=scr=desc=""; return }
	if(items+0 == 5) printf("&&\n%s\n%s\n%s\n%s\n",title,link,scr,desc); else
	if(items+0 == 4) printf("&&\n%s\n%s\n%s\n",title,link,scr); else
	if(items+0 == 3) printf("&&\n%s\n%s\n%s\n",title,link,desc); else
	printf("&&\n%s\n%s\n",title,link)
	title=link=scr=desc=""
}
function get_scr() {
	s5=substr(s0,ix5+9); ix6=index(s5,"\""); scr=substr(s5,1,ix6-1)
}
function get_link() {
	s1=substr(s0,ix1+6); ix2=index(s1,"\""); link=substr(s1,1,ix2-1); s1=substr(s1,ix2+2)
}
function get_link2() { # include other attribute
	s1=substr(s0,ix1+6); ix2=index(s1,"\""); link=substr(s1,1,ix2-1); s1=substr(s1,ix2+1)
}
function get_link3() { # no double quote
	s1=substr(s0,ix1+5); ix2=index(s1,">"); link=substr(s1,1,ix2-1); s1=substr(s1,ix2+1)
}
function link_title() {
	get_link(); ix2=index(s1,"<"); title=substr(s1,1,ix2-1)
}
function link_title2() {
	get_link2(); ix2=index(s1,">"); s1=substr(s1,ix2+1)
	if(ix2=index(s1,"<")) title=substr(s1,1,ix2-1); else title=s1
}
function link_title4() {
	get_link2(); ix2=index(s1,">"); s1=substr(s1,ix2+1)
	if(ix2=index(s1,"</a>")) { title=substr(s1,1,ix2-1); s1=substr(s1,ix2+4) }
	else title=""
}
function link_title5(str) { # str is </a> or </A>
	get_link2(); ix2=index(s1,">"); s1=substr(s1,ix2+1)
	if(ix2=index(s1,str)) { title=cut1(substr(s1,1,ix2-1)); s1=substr(s1,ix2+4) }
	else title=""
}
function deb(str,i) {
	for(i=1;i<=length(str);i++)
		if(substr(str,i,1) != " " && substr(str,i,1) != "\t") { return substr(str,i) }
	return "";
}
function cut1(s1,str,ix1,ix2,s2) {
	str=""; ix1=index(s1,"<")
	while(ix1) {
		str=str substr(s1,1,ix1-1); s2=substr(s1,ix1+1); ix2=index(s2,">")
		s1=(ix2) ? substr(s2,ix2+1) : ""; ix1=index(s1,"<")
	}
	str=str s1; return str
}
function cut2(s1,str,ix1,ix2,s2) {
	str=""; ix1=index(s1,"[")
	while(ix1) {
		str=str substr(s1,1,ix1-1); s2=substr(s1,ix1+1); ix2=index(s2,"]")
		s1=(ix2) ? substr(s2,ix2+1) : ""; ix1=index(s1,"[")
	}
	str=str s1; return str
}
function less_than(ix3) {
	gsub("<","\&lt;",a[num])
	if("$AWK_NAME" != "mawk") { # gawk BUG! "< ==> <lt;" (mawk OK!)
		if(ix3=index(a[num],"<")) a[num]=substr(a[num],1,ix3-1) "&" substr(a[num],ix3+1)
	}
}
@
cat > $AWK_CMP <<@
BEGIN { site_print=0; old_file="$OLD_FILE_NAME" }
{
	s0=\$0
	if(s0 == "</ol>") { if("$PRESENT_ONLY" == "NO" || site_print) print }
	else
	if(substr(s0,1,8)  == "<a href=") {
		site=s0; get_site(); if("$PRESENT_ONLY" == "NO") print
	} else
	if(substr(s0,1,12) == "<li><A HREF=") {
		if(cnt) for(i=0;i<cnt;i++) {
			ix1=index(s0,"</A>"); if(substr(s0,1,ix1-1) == substr(old[i],1,ix1-1)) next
		}
		if("$PRESENT_ONLY" == "YES" && ! site_print) { print site; site_print=1; }
		print

	} else print
}
function get_site() {
	site_print=cnt=found=0
	while(getline old_s0 < old_file > 0) if(old_s0 == site) { found=1; break }
	if(found) {
		while(getline old_s0 < old_file > 0) {
			if(substr(old_s0,1,8)  == "<a href=") break
			if(substr(old_s0,1,12) == "<li><A HREF=") old[cnt++]=old_s0
		}
	}
	close(old_file)
}
@
cat > $AWK38 <<@
BEGIN {
	printf("<html><head>")
	if("$LANG2" == "ja") {
		printf("<meta http-equiv=\"Content-Type\"")
		printf("content=\"text/html; charset=euc-jp\">\n")
	}
	printf("<title>HtmlHeadLine.sh $VERSION by toshi</title>\n")
	printf("</head><body bgcolor=\"$BACK_COLOR\">\n<pre>")
}
@
cat > $SCRIPT7 <<@
<SCRIPT LANG2="JavaScript">
<!--
function show(id, flag) {
  if (document.all) { document.all.item(id).style.visibility = "visible"; }
  if (document.layers) { document.layers[id].visibility = "show"; }
}
function hide(id, flag) {
  if (document.all) { document.all.item(id).style.visibility = "hidden"; }
  if (document.layers) { document.layers[id].visibility = "hide"; }
}
// -->
</SCRIPT>
@
cat > $AWK1 <<@
BEGIN {
	FS="<"; skipcnt=cnt=item=0; soundit=first=1;
	titlesave=scsave=clsave=dlsave=hpsave=linksave=descsave=""
	www_name=ENVIRON["WWW_NAME"]; url1=ENVIRON["URL1"]
#	                     type title2 chglg scrsh description
#	                       title1 hompa dwnlod link
	split("appwatch        1  1  0  0  0  0  0  2  3 " \
		  "kdeApps         1  1  0  0  0  0  0  2  3 " \
		  "kdeDot          1  1  0  0  0  0  0  2  0 " \
		  "marijuana       1  1  0  0  0  0  0  2  0 " \
		  "linuxComNews    1  1  0  0  0  0  0  2  3 " \
		  "linuxComJobs    1  1  0  0  0  0  0  2  0 " \
		  "linuxComGramA   1  1  0  0  0  0  0  2  3 " \
		  "linuxComGramF   1  1  0  0  0  0  0  2  3 " \
		  "linuxComGramL   1  1  0  0  0  0  0  2  3 " \
		  "lin-x-pert      1  1  0  0  0  0  0  2  3 " \
		  "mozillazine     1  1  0  0  0  0  0  2  0 " \
		  "happypenguin    1  1  0  0  0  0  0  2  0 " \
		  "bebits          1  1  0  0  0  0  0  2  0 " \
		  "hotwired        1  1  0  0  0  0  0  2  0 " \
		  "daemonnews      1  1  0  0  0  0  0  2  0 " \
		  "filmink-online  1  1  0  0  0  0  0  2  0 " \
		  "lwn             1  1  0  0  0  0  0  2  0 " \
		  "kde             1  1  0  0  0  0  0  2  0 " \
		  "lansystems      1  1  0  0  0  0  0  2  0 " \
		  "linuxfreak      1  1  0  0  0  0  0  2  0 " \
		  "mozilla         1  0  0  0  0  0  0  1  0 " \
		  "osinvestor      1  1  0  0  0  0  0  2  0 " \
		  "python          1  2  0  0  0  0  0  1  3 " \
		  "freshmeat       2  1  2  8 10  7  0 11  6 " \
		  "gnomeSoft       2  1  2  0  0  7  8 11  6 " \
		  "softwarecenter  3  1  0  0  0  3  0  2  4 " \
		  "segfault        3  1  0  0  0  0  0  2  3 " \
		  "linuxpreview    3  1  0  0  0  0  0  2  3 " \
		  "SolarisCentral  3  1  0  0  0  0  0  2  0 " \
		  "penguinapps     4  1  0  0  0  0  0  3  2 " \
		  "linux-2000      4  1  0  0  0  0  0  2  0 " \
		  "icewalkers      4  1  0  0  0  0  0  3  2 " \
		  "linuxapps       4  1  0  0  0  0  0  3  2 " \
		  "linuxtelephony  6  1  0  0  0  0  0  2  3 " \
		  "linuxtoday      6  1  0  0  0  0  0  2  3 " \
		  "wiredPalmpilot  6  1  0  0  0  0  0  2  3 " \
		  "wiredTechnology 6  1  0  0  0  0  0  2  3 " \
		  "svlug           6  1  0  0  0  0  0  2  3 " \
		  "php             6  1  0  0  0  0  0  2  3 " \
		  "alsa-project    6  1  0  0  0  0  0  2  3 " \
		  "currents        6  1  0  0  0  0  0  2  3 " \
		  "excite          6  1  0  0  0  0  0  2  3 " \
		  "insecure        6  1  0  0  0  0  0  2  3 " \
		  "linuxOrgNews    6  1  0  0  0  0  0  2  3 " \
		  "linuxOrgBook    6  1  0  0  0  0  0  2  3 " \
		  "ibiblio         6  1  0  0  0  0  0  2  3 " \
		  "film            6  1  0  0  0  0  0  2  3 " \
		  "zdnet           6  1  0  0  0  0  0  2  3 " \
		  "idg             6  1  0  0  0  0  0  2  3 " \
		  "idgLinux        6  1  0  0  0  0  0  2  3 " \
		  "hardwarecentral 6  1  0  0  0  0  0  2  3 " \
		  "computerworld   6  1  0  0  0  0  0  2  3 " \
		  "news-excite     6  1  0  0  0  0  0  2  3 " \
		  "linuxlock       6  1  0  0  0  0  0  2  3 " \
		  "linuxplace      6  1  0  0  0  0  0  2  3 " \
		  "techweb         6  1  0  0  0  0  0  2  3 " \
		  "net-security    6  1  0  0  0  0  0  2  3 " \
		  "heise           6  1  0  0  0  0  0  2  3 " \
		  "gnomeNews       6  1  0  0  0  0  0  2  3 " \
		  "cbs             6  1  0  0  0  0  0  2  3 " \
		  "yahoo           6  1  0  0  0  0  0  2  3 " \
		  "bbc             6  1  0  0  0  0  0  2  3 " \
		  "theregister     6  1  0  0  0  0  0  2  3 " \
		  "tky             6  1  0  0  0  0  0  2  3 " \
		  "linux-mandrake  6  1  0  0  0  0  0  2  3 " \
		  "linuxdevices    6  1  0  0  0  0  0  2  3 " \
		  "salon           6  1  0  0  0  0  0  2  3 " \
		  "linevents       6  1  0  0  0  0  0  2  3 " \
		  "linuxinsider    6  1  0  0  0  0  0  2  3 " \
		  "ecommercetimes  6  1  0  0  0  0  0  2  3 " \
		  "linuxnews       6  1  0  0  0  0  0  2  3 " \
		  "linhardware     6  1  0  0  0  0  0  2  3 " \
		  "linuxdev        6  1  0  0  0  0  0  2  3 " \
		  "linuxmonth      6  1  0  0  0  0  0  2  3 " \
		  "xmlhack         6  1  0  0  0  0  0  2  3 " \
		  "perl            6  1  0  0  0  0  0  2  3 " \
		  "nospoon         6  1  0  0  0  0  0  2  3 " \
		  "mysql           6  1  0  0  0  0  0  2  3 " \
		  "webclub         6  1  0  0  0  0  0  2  3 " \
		  "littleigloo     6  1  0  0  0  0  0  2  3 " \
	  "linuxComDownload    6  1  0  0  0  0  0  2  3 " \
		  "gamefan         6  1  0  0  0  0  0  2  3 " \
		  "kuro5hin        6  1  0  0  0  0  0  2  3 " \
		  "anandtech       6  1  0  0  0  0  0  2  3 " \
		  "sharkyextreme   6  1  0  0  0  0  0  2  3 " \
		  "efront          6  1  0  0  0  0  0  2  3 " \
		  "amdzone         6  1  0  0  0  0  0  2  3 " \
		  "gnu             6  1  0  0  0  0  0  2  3 " \
		  "isonews         6  1  0  0  0  0  0  2  3 " \
		  "vg              6  1  0  0  0  0  0  2  3 " \
		  "dagbladet       6  1  0  0  0  0  0  2  3 " \
		  "sabah           6  1  0  0  0  0  0  2  3 " \
		  "bizit           6  1  0  0  0  0  0  2  3 " \
		  "abc             6  1  0  0  0  0  0  2  3 " \
		  "forbes          6  1  0  0  0  0  0  2  3 " \
		  "fortune         6  1  0  0  0  0  0  2  3 " \
		  "shoutcast       6  1  0  0  0  0  0  2  3 " \
		  "icecast         6  1  0  0  0  0  0  2  3 " \
		  "realguide       6  1  0  0  0  0  0  2  3 " \
		  "spaceviews      6  1  0  0  0  0  0  2  3 " \
	  "security-informer   6  1  0  0  0  0  0  2  3 " \
		  "newsnow         6  1  0  0  0  0  0  2  3 " \
		  "antionline      6  1  0  0  0  0  0  2  3 " \
		  "cnn             6  1  0  0  0  0  0  2  3 " \
		  "cs              6  1  0  0  0  0  0  2  3 " \
		  "linuxworld      6  1  0  0  0  0  0  2  3 " \
		  "securiteam      6  1  0  0  0  0  0  2  3 " \
		  "securitysearch  6  1  0  0  0  0  0  2  3 " \
		  "linuxsecurity   6  1  0  0  0  0  0  2  3 " \
		  "linuxfr         6  1  0  0  0  0  0  2  3 " \
		  "turbolinux      6  1  0  0  0  0  0  2  3 " \
		  "debianJp        6  1  0  0  0  0  0  2  3 " \
		  "debian          6  1  0  0  0  0  0  2  3 " \
		  "xemacs          6  1  0  0  0  0  0  2  3 " \
		  "vim             6  1  0  0  0  0  0  2  3 " \
		  "15secondsHp     6  1  0  0  0  0  0  2  3 " \
		  "softseek        6  1  0  0  0  0  0  2  3 " \
		  "linuxguruz      6  1  0  0  0  0  0  2  3 " \
		  "linuxguruzTut   6  1  0  0  0  0  0  2  3 " \
		  "vector          6  1  0  0  0  0  0  2  3 " \
		  "stormix         6  1  0  0  0  0  0  2  3 " \
		  "bestlinux       6  1  0  0  0  0  0  2  3 " \
		  "corel           6  1  0  0  0  0  0  2  3 " \
		  "hackernews      6  1  0  0  0  0  0  2  0 " \
		  "newsbytes       6  1  0  0  0  0  0  2  0 " \
		  "iss             6  1  0  0  0  0  0  2  0 " \
		  "securityportal  6  1  0  0  0  0  0  2  0 " \
		  "postgresql      6  1  0  0  0  0  0  2  0 " \
		  "suse            6  1  0  0  0  0  0  2  0 " \
		  "nikkeibp        6  1  0  0  0  0  0  2  0 " \
		  "kernelnotes     6  1  0  0  0  0  0  2  0 " \
		  "linuxhq         6  1  0  0  0  0  0  2  0 " \
		  "securityfocus   6  1  0  0  0  0  0  2  0 " \
		  "infowar         6  1  0  0  0  0  0  2  0 " \
		  "nikkansports    6  1  0  0  0  0  0  2  0 " \
		  "bugnet          6  1  0  0  0  0  0  2  0 " \
		  "cnet            6  1  0  0  0  0  0  2  0 " \
		  "emusic          6  1  0  0  0  0  0  2  0 " \
		  "music           6  1  0  0  0  0  0  2  0 " \
		  "real            6  1  0  0  0  0  0  2  0 " \
		  "oreilly         6  1  0  0  0  0  0  2  0 " \
		  "pro-linux       6  1  0  0  0  0  0  2  0 " \
		  "kernel          6  1  0  0  0  0  0  2  0 " \
		  "fokus           6  1  0  0  0  0  0  2  0 " \
		  "linux-magazin   6  1  0  0  0  0  0  2  0 " \
		  "nodevice        6  1  0  0  0  0  0  2  0 " \
		  "computeruser    6  1  0  0  0  0  0  2  0 " \
		  "portalux        6  1  0  0  0  0  0  2  0 " \
		  "webcomics       6  1  0  0  0  0  0  2  0 " \
		  "mklinux         6  1  0  0  0  0  0  2  0 " \
		  "screenshots     6  1  0  0  0  0  0  2  0 " \
		  "laser5          6  1  0  0  0  0  0  2  0 " \
		  "ninemsn         6  1  0  0  0  0  0  2  0 " \
		  "space           6  1  0  0  0  0  0  2  0 " \
		  "digi            6  1  0  0  0  0  0  2  0 " \
		  "New-New-3       6  1  0  0  0  0  0  2  0 " \
		  "enlightenment   6  1  0  0  0  0  0  2  0 " \
		  "15seconds       6  1  0  0  0  0  0  2  0 " \
	  "hollywoodbitchslap  6  1  0  0  0  0  0  2  0 " \
		  "redhat          6  1  0  0  0  0  0  2  0 " \
		  "gtkThemes       6  1  0  0  0  0  3  2  0 " \
		  "asThemes        6  1  0  0  0  0  3  2  0 " \
		  "eThemes         6  1  0  0  0  0  3  2  0 " \
		  "sawmillThemes   6  1  0  0  0  0  3  2  0 " \
		  "kdeThemes       6  1  0  0  0  0  3  2  0 " \
		 "digitalblasphemy 6  1  0  0  0  0  3  2  0 " \
		  "ascii           6  1  0  0  0  0  3  2  4 " \
		  "tagesschau      6  1  0  0  0  0  3  2  4 " \
		  "slashdot        7  1  0  0  0  0  0  2  5 " \
		  "32bitsonline    9  1  0  0  0  0  0  2  0 " \
		  "arstechnica     9  1  0  0  0  0  0  2  0 " \
		  "linuxDe        10  1  0  0  0  0  0  2  0 " \
		  "cmptr          13  0  0  0  0  0  0 99  0 " \
		  "technetcast    13  0  0  0  0  0  0 99  0 " \
		  "nwfusion       13  0  0  0  0  0  0 99  0 " \
		  "linuxComTuneup 15  1  0  0  0  0  0  4  3 " \
		  "wideopen       16  0  0  0  0  0  0  0  2 " \
		  "linuxUk        17  0  0  0  0  0  0 99  0 " \
		  "END",par," ")
	par_siz=10; gnu_start=0
}
{
	if(first) {
		i=1
		while(par[i] "" != "END") {
			if(par[i] "" == \$1 "") {
				p_type   = par[i+1]+0; p_title1 = par[i+2]+0; p_title2 = par[i+3]+0
				p_hp     = par[i+4]+0; p_cl     = par[i+5]+0; p_dl     = par[i+6]+0
				p_scr    = par[i+7]+0; p_link   = par[i+8]+0; p_desc   = par[i+9]+0
				break
			}
			i += par_siz
		}
		if(par[i] "" == "END") exit
		if("$FILE_ONLY" == "NO")
			printf("<a href=\"http://%s\"><b>%s</b></a> <b>(%s)</b><ol type=1>\n",url1,www_name,\$1)
		if(p_type == 10) first10=1;
		site=\$1 ""; num=\$2+0; first=0; next
	}
	if(p_type == 14 && skipcnt < 3) { skipcnt++; next }
	if(p_type ==  5 && skipcnt < 1) { skipcnt++; next }
	if(p_type == 17 && index(\$0,"Linux.org.uk"))       gnu_start=1;
	if(p_type == 17 && index(\$0,"News and Goings On")) gnu_start=0;
	# ITEM
	if( p_type ==16 && index(\$0,"lg1head"))    print1(); else
	if( p_type ==17 && index(\$0,"A href"))     print1(); else
	if( p_type ==13 && index(\$0,"a href"))     print1(); else
	if( p_type == 6 && substr(\$0,1,2) == "&&") print1(); else
	if( p_type == 7 && index(\$0,"<story>"))    print1(); else
	if( p_type == 1 && index(\$0,"<item>"))     print1(); else
	if((p_type == 2 || p_type == 3 || p_type == 10) && substr(\$0,1,2) == "%%") print1(); else
	if( p_type ==  4 || p_type ==  5 || p_type ==  9 || p_type == 14 || p_type == 15) {
		if(cnt == 0) { print1(); cnt++ }
	}
	else if(! item) next
	# segfault
	if(site == "segfault" && cnt == 2 && substr(\$0,1,7) != "http://") next
	# TITLE
	if(p_type == 17) {
		if(! cnt) {
			inx=index(\$3,">"); linksave=substr(\$3,9,inx-10)
			titlesave=substr(\$3,inx+1)
		}
	}
	else
	if(p_type == 16) {
		if(! cnt) {
			inx=index(\$3,">"); linksave=substr(\$3,9,inx-10)
			inx=index(\$4,">"); titlesave=substr(\$4,inx+1)
		}
	}
	else
	if(p_type == 13) {
		if(! cnt) {
			if(NF >= 3) {
				body7=(NF >= 4) ? \$3 : \$2
				inx=index(body7,">"); titlesave=substr(body7,inx+1)
				linksave=substr(body7,9,inx-10); next
			}
		}
	}
	else
	if(site == "mozilla") {
		if(! cnt) { inx=index(\$3,">"); titlesave=substr(\$3,inx+1) }
	}
	else
	if(p_type == 2 && (cnt == p_title1 || cnt == p_title2)) {
		titlesave=titlesave " " \$0
	}
	else { s7=save1(p_title1); if(length(s7)) titlesave = s7 }
	s7=save1(p_hp);   if(length(s7)) hpsave   = s7
	s7=save1(p_cl);   if(length(s7)) clsave   = s7
	s7=save1(p_dl);   if(length(s7)) dlsave   = s7
	s7=save1(p_scr);  if(length(s7)) scsave   = s7
	s7=save1(p_link); if(length(s7)) linksave = s7
	s7=save1(p_desc); if(length(s7)) descsave = s7
	# postamble
	cnt++
	if( p_type == 15 && cnt > 5) cnt=0; else
	if( p_type ==  9 && cnt > 2) cnt=0; else
	if((p_type ==  4 || p_type ==  5 || p_type == 14) && cnt > 3) cnt=0
}
function save1(p_hp,save2) {
	if((p_type == 1 || p_type == 7) && p_hp+0 && cnt == p_hp) {
		inx=index(\$2,">"); save2=substr(\$2,inx+1)
	}
	else if(p_hp+0 && cnt == p_hp) save2=\$0
	return save2
}
function print_href1(p_hp,hpsave,head1) {
	if(p_hp)
		if(length(hpsave)) {
			printf(" <A HREF=\"%s\"",hpsave);
			if("$OTHER_WINDOW" == "YES") printf(" TARGET=_blank")
			printf(">%s</A>",head1);
		}
		else printf("%s",substr("    ",1,length(head1)+1))
}
function print1() {
	if((p_type == 17) && ! gnu_start) { titlesave=""; return }
	if(p_type == 10 && first10) { first10=0; return } # www.linux.de
	cnt=0; item=1; num++
	if(length(titlesave)) {
		if("$AWK_NAME" == "mawk") {
			gsub("&amp;","\&",titlesave) # \ required
			gsub("&lt;","<",titlesave)
			gsub("&gt;",">",titlesave)
			gsub("&quot;","\"",titlesave)
			gsub("&nbsp;"," ",titlesave)
		}
		gsub("\t"," ",titlesave) # icewalker
		gsub("\r","",titlesave)  # excite
		gsub("  "," ",titlesave) # 32bitonline
		if(site == "happypenguin") gsub("&apos;","'",titlesave)
		if(site == "linuxComGramA" || site == "linuxComGramL") {
			if(substr(titlesave,1,22) == "The Penguin Hatchery: ") titlesave=substr(titlesave,23)
		}
		if(site == "linuxDe") gsub("<BR>","",titlesave)

		if("$FILE_ONLY" == "YES" ||
		  (site != "ninemsn"		&& site != "cnn"			&&
		   site != "gtkThemes"		&& site != "softseek"		&&
		   site != "eThemes"		&& site != "nikkansports"	&&
		   site != "sharkyextreme"	&& site != "asThemes"		&&
		   site != "vector"	        && site != "hollywoodbitchslap"	&&
		   site != "kdeThemes"		&& site != "sawmillThemes"	&&
		   site != "emusic"			&& site != "gnu")) {
			if("$AWK_NAME" == "mawk") {
				gsub("</B>","",titlesave); gsub("</b>","",titlesave)
			}
			else {
				gsub("/B>","",titlesave); gsub("/b>","",titlesave) # nospoon or newsnow
			}
		}

		if("$FILE_ONLY" == "YES") {
			if("$AWK_NAME" == "mawk") {
				gsub("<B>","",titlesave); gsub("<b>","",titlesave)
			}
			else {
				gsub("B>","",titlesave); gsub("b>","",titlesave) # nospoon or newsnow
			}
		}

		titlesave=deb(titlesave) # linuxOrgNews
		if(site == "nwfusion" || site == "wideopen")
									    linksave="http://www." site ".com" linksave
		else if(site == "linuxUk")      linksave="http://www.linux.org.uk" linksave
		else if(site == "linuxpreview") linksave="http://linuxpreview.org" linksave
		if("$KEYWORD" != "" && index(titlesave,"$KEYWORD") && soundit) {
			system("$PLAY_MUSIC"); soundit=0
		}
		if("$FILE_ONLY" == "NO") {
			printf("<li><A HREF=\"%s\"",linksave)
			if("$OTHER_WINDOW" == "YES") printf(" TARGET=_blank")
			printf(">")
		}
		if("$FILE_ONLY" == "YES") {
			s7=sprintf("%s%s",
				("$OMIT_SITENAME" == "YES") ? "" : substr(site,1,3) ": ",deb(titlesave))
			gsub("  "," ",s7); printf("%s\n",s7)
		}
		else {
			gsub("\r","",titlesave)
			if(substr(titlesave,1,1) "" == " ") titlesave=substr(titlesave,2)

			title_len=60
			if(p_desc) title_len -= 6
			if(p_hp)   title_len -= 3
			if(p_cl)   title_len -= 4
			if(p_dl)   title_len -= 3
			if(p_scr)  title_len -= 4

			s7=substr(titlesave,1,title_len)

			add_len=0
			for(ind1=1;ind1<=title_len;ind1++) if(substr(s7,ind1,1) > "\177") { add_len++; ind1++ }
			title_len += int((add_len+1) / 2)

			if("$BIG_FONT" == "YES") 
				printf("<Font size=+1>%-*s</font>",title_len,s7)
			else
				printf("%-*s",title_len,s7)
		}
		if("$FILE_ONLY" == "NO") {
			printf("</A>")
			print_href1(p_hp, hpsave,"HP");
			print_href1(p_cl, clsave,"Log");
			print_href1(p_scr,scsave,"Scr");
			print_href1(p_dl, dlsave,"DL");
			if(p_desc && length(descsave)) {
				if("$DESC_TABLE" == "YES")
					printf("<br><TABLE><TD>%s </TD></TABLE>",descsave);
				else {
					printf(" <A HREF=\"\"")
					printf(" onMouseOver=\"show('id%d')\"",num)
					printf(" onMouseOut=\"hide('id%d')\">Desc </A>",num)
					printf("<SPAN ID=id%d STYLE=\"visibility:hidden\">",num)
					printf("<LAYER NAME=id%d VISIBILITY=\"hide\">",num)
					printf("%s </LAYER></SPAN>",descsave)
				}
			}
			print ""
		}
		titlesave=scsave=clsave=dlsave=hpsave=linksave=descsave=""
	}
}
END {
	print1()
	if("$FILE_ONLY" == "NO") printf("</ol>\n")
	printf("%d",num) > "$NAM4"
}
@
cat > $AWK2 <<@
BEGIN { FS="/" } { printf("%s\n",\$1) }
@
cat > $AWK3 <<@
BEGIN { FS="." } { printf("%s\n",(NF < 3) ? \$1 : \$2) }
@
# www.gnome.org is changed to a freshmeat style
# The format was changed at 2000/05/26
cat > $AWK4 <<@
BEGIN { FS="<"; scr=dl=s4=s3=s2=s1=""; started=0 }
{
	if(started && \$0 == "</div>") exit
	if(index(\$0,"<th align=\"center\">Version</th>")) { s1=""; started=1; next }
	if(! started) next
	if(substr(\$0,1,20) == " <td align=\"center\">") {
		str1=substr(\$0,21); ix2=index(str1,"<");    s2 =substr(str1,1,ix2-1)
	} else
	if(ix9=index(\$0,"href")) {
		if(ix1=index(\$0,"entrylimit=50")) {
			print1()
			str1=substr(\$0,ix1+15); ix2=index(str1,"<"); s1 =substr(str1,1,ix2-1)
		} else
		if(index(\$0,"images/icon-home")) {
			str1=substr(\$0,ix9+6); ix2=index(str1,"\""); s4 =substr(str1,1,ix2-1)
		} else
		if(index(\$0,"images/icon-shot")) {
			str1=substr(\$0,ix9+6); ix2=index(str1,"\""); scr=substr(str1,1,ix2-1)
		} else
		if(index(\$0,"images/icon-package")) {
			str1=substr(\$0,ix9+5); ix2=index(str1,">"); dl =substr(str1,1,ix2-1)
		}
	} else
	if(substr(\$0,length(\$0),1) == "\r") {
		if(length(\$0) < 2) next
		s9=substr(\$0,1,length(\$0)-1); s3=s3 " " s9
	}
}
function print1() {
	if(length(s1)) {
		printf("%%%%\n%s\n%s\n\n\n\n%s\n%s\n%s\n\n\n%s\n\n",s1,s2,s3,dl,scr,s4)
	}
	scr=dl=s4=s3=s2=s1=""
}
END { if(length(s1)) print1() }
@
# www.kernel.org
cat > $AWK5 <<@
BEGIN { FS="." }
{
	s0=\$0
	if(index(s0,"stable")) print1("stable");   else
	if(index(s0,"beta"))   print1("beta    "); else
	if(index(s0,"alpha"))  print1("alpha  ")
}
function print1(str) {
	ix1=index(s0,":"); s1=deb(substr(s0,ix1+1)); \$0=s1; ver=\$1 "." \$2
	title=sprintf("%s %s",str,s1); link=sprintf("pub/linux/kernel/v%s/",ver)
	make_link("www.kernel.org"); print2(2)
}
@
# SITES.table
cat > $AWK6 <<@
BEGIN { FS="[ #\t]" }
{
	if(substr(\$0,1,3) == "END") exit
	if(substr(\$0,1,1) == "#") next
	if(length(\$1)) print \$1
}
@
# technetcast
cat > $AWK7 <<@
{ gsub("&#149;","\n<>"); print }
@
# nwfusion
cat > $AWK8 <<@
BEGIN { started=0 }
{
	if(index(\$0,"<!-- this week -->")) exit
	if(index(\$0,"<!-- daily news -->")) started=1
	if(started && index(\$0,"href")) printf("<>%s\n",\$0)
}
@
# wiredPalmpilot
cat > $AWK9 <<@
BEGIN { FS="<"; block=0; desc="" }
{
	if(index(\$0,"news_drop/palmpilot/story")) {
		inx=index(\$2,">"); link=substr(\$2,9,inx-10); make_link("www.wired.com")
		title=substr(\$2,inx+1); printf("&&\n%s\n%s\n",cut1(title),link)
		block=1; desc=""; next
	}
	if(! block) next
	if(index(\$0,"</blockquote>")) {
		block=0; gsub("<br>","",desc); gsub("</b>","",desc)
		printf("%s\n",cut1(desc))
	}
	desc=desc \$0
}
@
# svlug
cat > $AWK10 <<@
BEGIN { title=link=desc="" }
{
	if(substr(\$0,1,7) == "title: ") title=substr(\$0,8); else
	if(substr(\$0,1,5) == "url: ")   link=substr(\$0,6); else
	if(substr(\$0,1,6) == "text: ")  desc=cut1(desc1(substr(\$0,7))); else
	if(substr(\$0,1,6) == "date: ")  print2(3); else
	desc=desc " " cut1(desc1(\$0))
}
function desc1(s) {
	if(substr(s,length(s),1) == "\\\\") return substr(s,1,length(s)-1);
	else return s
}
END { if(length(title)) print2(3) }
@
# nikkeibp
cat > $AWK11 <<@
BEGIN { maxnum=refered=0; skip=1 }
{
	s0=\$0
	if(index(s0,"References")) { refered=1; next }
	if(refered) {
		if(! (ix=index(s0,"."))) next
		num=substr(s0,1,ix-1)+0; link=substr(s0,ix+2)
		if(index(link,"mailto:")) next
		if(! length(a[num])) next
		b[num]=link; maxnum=(maxnum < num) ? num : maxnum
	}
	else
	if(skip == 1) { if(index(s0,"˥塼")) { skip=2; next } }
	else
	if(skip == 2) {
		if(index(s0,"ե᡼")) { skip=3; next }
		while(ix1=index(s0,"[")) {
			s1=substr(s0,ix1+1); if(! (ix2=index(s1,"]"))) break
			num=substr(s1,(substr(s1,1,1) "" == "[") ? 2 : 1,ix2-1)+0
			s0=substr(s1,ix2+1)
			if(ix1=index(s0,"[")) {
				a[num]=substr(s0,1,ix1-1); less_than(); s0=substr(s0,ix1)
			}
			else { a[num]=s0; less_than(); break }
		}
	}
}
END { for(i=0;i<=maxnum;i++) if(length(b[i])) printf("&&\n%s\n%s\n",a[i],b[i]) }
@
# php
cat > $AWK12 <<@
BEGIN { title=link=desc=""; started=type=0 }
{
	if(index(\$0,"Older News")) exit
	if(index(\$0,"PHP in the News")) { title=desc=""; started=1; next }
	if(! started) next
	if(index(\$0,"<? endEntry()")) print1(); else
	if(ix1=index(\$0,"<? makeEntry")) {
		desc=""
		s1=substr(\$0,ix1+13); ix1=index(s1,"\"")
		s1=substr(s1,ix1+1);   ix1=index(s1,"\"")
		title=substr(s1,1,ix1-1); type=1
		if(ix1=index(\$0,"http://")) {
			link2=substr(\$0,ix1)
			if(ix1=index(link2,"\"")) { link=substr(link2,1,ix1-1); type=2 }
		}
	} else
	if(ix1=index(\$0,"http://")) {
		link2=substr(\$0,ix1)
		if(ix1=index(link2,"\"")) { link=substr(link2,1,ix1-1); type=2 }
	} else
	if(ix1=index(\$0,"?>")) {
		if(type == 1) {
			link2=link2 \$0; ix1=index(link2,"\""); link=substr(link2,1,ix1-1)
			type=2
		}
	} else
	if(type == 1) {
		link2=link2 \$0; ix1=index(link2,"\""); link=substr(link2,1,ix1-1)
		type=2
	} else
	if(type == 2) desc=desc " " \$0
}
function print1() {
	gsub(/ /,"",link); desc=cut1(desc)
	if(length(title) && started) printf("&&\n%s\n%s\n%s\n",title,link,desc)
	title=link=desc=""; type=0
}
@
# alsa-project
cat > $AWK13 <<@
BEGIN { title=desc=""; started=0 }
{
	if(index(\$0,"<b>WWW server statistics")) exit
	if(index(\$0,"<b>Latest News")) { title=""; started=1; next }
	ix1=index(\$0,"<b>"); ix3=index(\$0,"middle")
	if(ix1) {
		print1(); s1=substr(\$0,ix1+3); ix2=index(s1,"<")
		if(ix2) { title=substr(s1,1,ix2-1); desc="" }
	}
	else
	if(ix3) {
		s1=substr(\$0,ix3+8); s2=s1; less_than(); ix4=index(s2,"<")
		if(ix4) {
			s3=substr(s2,ix4+1); ix5=index(s3,">")
			if(ix5) s2=((ix4 > 1) ? substr(s2,1,ix4-1) : "") substr(s3,ix5+1);
		}
		gsub("</a>","",s2); gsub("</A>","",s2)
		title=title " " s2; desc=desc " " deb(cut1(s1))
	}
	else
	if(! index(\$0,"<")) { s1=\$0; less_than(); desc=desc " " s1 }
}
function print1() {
	title=substr(title,6)
	if(length(title) && started)
		printf("&&\n%s\nhttp://www.alsa-project.org\n%s\n",title,desc)
	title=desc=""
}
@
# suse
cat > $AWK14 <<@
BEGIN { FS="<"; title="" }
{
	if(! index(\$0,"/news/hotnews/")) next
	print2(2); s1=substr(\$3,9); ix2=index(s1,"\""); if(! ix2) next
	link=substr(s1,1,ix2-1); title=substr(s1,ix2+2) substr(\$5,4)
	make_link("www.suse.de")
}
END { if(length(title)) print2(2) }
@
# turbolinux
cat > $AWK15 <<@
BEGIN { FS="<"; title=link=""; started=0 }
{
	s0=\$0
	if(index(s0,"<!-- END content -->")) exit
	if(index(s0,"<!-- BEGIN content -->")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href=")) {
		str5=cut1(substr(s0,1,ix1-4)); link_title2()
		make_link("www.turbolinux.com")
		title=title " | " str5; desc=title; print2(3)
	}
}
@
# mysql
cat > $AWK16 <<@
BEGIN { title=link=desc=""; started=0; type=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"News and articles")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF")) { link_title(); make_link("www.mysql.com/news") } else
	if(index(s0,"CLASS=\"smaller")) { desc=desc " " cut1(s0); type=1 } else
	if(index(s0,"</TR>") && type == 1) { print2(3); type=0 } else
	desc=desc " " cut1(s0)
}
@
# postgresql
cat > $AWK17 <<@
BEGIN { title=""; cnt=0 }
{
	s3=substr(\$0,1,3) ""; s2=substr(\$0,4,1) ""
	if(s3 != "<b>" && ! (s2 >= "0" && s2 <= "9")) next
	print1(); s1=substr(\$0,4); ix2=index(s1,"</b>"); if(! ix2) next
	title=substr(s1,1,ix2-1); title=substr(title,6,5) substr(title,13)
}
function print1() {
	if(cnt++ < 22 && length(title)) printf("&&\n%s\nhttp://www.postgresql.org\n",title)
	title=""
}
@
# iss
cat > $AWK18 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Serious Fun<")) exit
	if(index(s0,"Latest News<")) { title=""; started=1; next }
	if(! started) next
	if(! (ix1=index(s0,"HREF="))) next
	link_title(); make_link("xforce.iss.net"); print2(2)
}
@
# securityfocus
cat > $AWK19 <<@
BEGIN { title=""; started=0 }
{
	if(started && index(\$0,"COMMENTARY")) exit
	if(index(\$0,">NEWS<")) { title=""; started=1; next }
	if(! started) next
	ix1=index(\$0,"newsbarstory"); ix2=index(\$0,"newsbardate")
	if(ix2) {
		s1=substr(\$0,ix2+12); ix2=index(s1,"<")
		title=substr(s1,1,ix2-1) " " title; print1(); next
	}
	else if(! ix1) next
	s1=substr(\$0,ix1+19); ix2=index(s1,"\""); link=substr(s1,1,ix2-1)
	s2=substr(s1,ix2+2); ix3=index(s2,"<"); title=substr(s2,1,ix3-1)
}
function print1() {
	if(length(title)) printf("&&\n%s\nhttp://www.securityfocus.com%s\n",title,link)
	title=""
}
@
# securiteam (two month)
SLYYYY1=`date "+ / %Y"`; YYYY1=`date +%Y`; MM1=`date +%m`
cat > $AWK20 <<@
BEGIN {
	title=""; started=0
	mm=$MM1 - 2; yy=$YYYY1; if(mm < 1) { yy--; mm += 12 }
	split("Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec",month," ")
	mmyyyy2=month[mm] " / " sprintf("%04d",yy)
}
{
	if(started && index(\$0,mmyyyy2)) exit
	if(index(\$0,"$SLYYYY1")) { title=""; started=1; next }
	if(! started) next
	if(! (ix1=index(\$0,"href"))) next
	s0=\$0; link_title(); make_link("www.securiteam.com"); desc=title; print2(3)
}
@
# antionline
cat > $AWK21 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</blockquote>")) exit
	if(index(s0,"src=\"news.gif")) { title=""; started=1; next }
	if(! started) next
	if(! (ix1=index(s0,"HREF"))) next
	link_title(); desc=title; make_link("www.antionline.com"); print2(3)
}
@
# newsbytes
cat > $AWK22 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"End Story Content Area")) exit
	if(index(s0,"Begin Story Content Area")) { title=""; started=1; next }
	if(! started) next
	if(! (ix1=index(s0,"HREF=\"/news"))) next
	link_title5("</A>"); make_link("www.newsbytes.com"); print2(2)
}
@
# currents
cat > $AWK23 <<@
BEGIN { title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"CLOSE MAIN DISPLAY")) exit
	if(index(s0,"storyhed\">News")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"<P class=")) {
		print1(); if(! (ix1=index(s0,"HREF"))) next
		link_title5("</A>"); make_link("www.currents.net")
	}
	else desc=desc \$0
}
function print1() { title=cut1(title); desc=cut1(desc); print2(3) }
END { if(length(title)) print1() }
@
# excite
cat > $AWK24 <<@
BEGIN { title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"bgcolor=#99CCCC")) exit
	if(index(s0,"Track this Topic</a>")) { title=link=desc=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) { print1(); link_title5("</a>") }
	else desc=desc \$0
}
function print1() {
	title=cut1(title); desc=cut1(desc)
	if(substr(link,1,7) == "http://") print2(3); else title=link=desc=""
}
END { if(length(title)) print1() }
@
# securityportal
cat > $AWK25 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"email this article")) exit
	if(index(s0,"HEADLINES<")) { title=""; started=1; next }
	if(! started) next
	if(! (ix1=index(s0,"href"))) next
	s1=substr(s0,ix1+5); ix2=index(s1," "); link=substr(s1,1,ix2-1)
	s1=substr(s1,ix2+1); ix2=index(s1,">")
	s1=substr(s1,ix2+1); ix2=index(s1,"<"); title=substr(s1,1,ix2-1)
	make_link("securityportal.com"); print2(2)
}
@
# zdnet
cat > $AWK26 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!--magazine directory-->")) exit
	if(index(s0,"Today on ZDNet")) { title=""; started=1; next }
	if(! started) next
	ix7=index(s0,"mhead"); ix8=index(s0,"mdeck")
	if(ix7) {
		print2(3); if(! (ix1=index(s0,"href"))) next
		get_link(); s2=substr(s1,21); ix3=index(s2,"<"); title=substr(s2,1,ix3-1)
	}
	else if(ix8) desc=cut1(substr(s0,ix8+7))
}
END { if(length(title)) print2(3) }
@
# idg
cat > $AWK27 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Go to one week view")) exit
	if(index(s0,"hed_moretop.gif")) { title=""; started=1; next }
	if(index(s0,"<TITLE>We are undergoing maintenance</TITLE>")) {
		title=cut1(s0); print2(3)
	}
	if(! started) next
	if((ix1=index(s0,"HREF")) || (ix1=index(s0,"href"))) {
		print1(); link_title2(); make_link("www.idg.net")
	}
	else desc=desc " " s0
}
function print1() { # idg html is too dirty!
	gsub("</FONT>",":",desc); desc=cut1(desc)
	while(ix7=index(desc,">")) desc=substr(desc,ix7+1)
	print2(3)
}
END { if(length(title)) print1() }
@
# webclub
cat > $AWK28 <<@
BEGIN { title=link=desc=""; started=0 }
{
	if(started && index(\$0,"<!-- Golden URL -->")) exit
	if(index(\$0,"<!-- end stars -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"<a href=index.phtml?news")) {
		print1()
		s1=substr(s0,1,ix1-1); s2=substr(s0,ix1+8)
		if(ix1=index(s2,">")) link=substr(s2,1,ix1-1)
		make_link("linux.webclub.ru")
		if(ix1=index(s1,"<BR>")) {
			title=cut1(substr(s1,1,ix1-1)); desc=cut1(substr(s1,ix1+4))
		}
	}
}
function print1() {
	if("$AWK_NAME" == "mawk") {
		gsub("</font>","",title); gsub("</FONT>","",title)
	}
	else {
		gsub("/font>","",title);  gsub("/FONT>","",title)
	}
	print2(3)
}
END { if(length(title)) print1() }
@
# net-security
cat > $AWK29 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- MIDDLE ENDS -->")) exit
	if(index(s0,"<!-- NP")) { title=""; started=1; next }
	if(! started) next
	if(substr(s0,1,14) == "<P><FONT SIZE=" && (ix1=index(s0,"</B>"))) {
		title=substr(s0,1,ix1-1); desc=substr(s0,ix1)
	}
	else
	if((ix1=index(s0,"href")) && (ix2=index(s0,"Link:"))) {
		desc=desc " " substr(s0,1,ix2-1); get_link()
		gsub("<BR>"," ",desc); desc=deb(cut1(desc))
		title=deb(cut1(title)); print2(3)
	}
	else desc=desc " " s0
}
@
# hardwarecentral
cat > $AWK30 <<@
BEGIN { title=""; started=0 }
{
	if(started && index(\$0,"HardwareCentral at a Glance")) exit
	if(index(\$0,"Overclocking")) { title=""; started=1; next }
	if(! started) next
	ix1=index(\$0,"Helvetica\" SIZE=4"); if(! ix1) next
	s1=substr(\$0,ix1+17); ix2=index(s1,"HREF")
	s2=substr(s1,ix2+7); ix2=index(s2,"\""); link=substr(s2,1,ix2-1)
	make_link("www.hardwarecentral.com")
	s1=substr(s2,ix2+2); ix1=index(s1,"<"); title=substr(s1,1,ix1-1)
	desc=cut1(substr(s1,ix1)); print2(3)
}
@
# computerworld
cat > $AWK31 <<@
BEGIN { title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Show previous headlines</span>")) exit
	if(index(s0,"alt=\"Latest News")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		print1(); get_link(); make_link("www.computerworld.com")
		ix1=index(s1,">"); title=cut1(substr(s1,ix1+1))
	}
	else desc=desc " " s0
}
function print1() {
	desc=cut1(desc); print2(3)
}
END { if(length(title)) print1() }
@
# news-excite
cat > $AWK32 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Earlier Stories")) exit
	if(started && index(s0,"<P><B>")) exit
	if(index(s0,"Headlines</A>")) { title=""; started=1; next }
	if(! started) next
	ix1=index(s0,"HREF"); ix4=index(s0,"<B>")
	if(ix1) { print1(); get_link3(); make_link("news.excite.com") } else
	if(ix4) { s1=substr(s0,ix4+3); ix2=index(s1,"<"); title=substr(s1,1,ix2-1) }
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); print2(3) }
END { if(length(title)) print1() }
@
# infowar
cat > $AWK33 <<@
BEGIN { title=""; started=h4cnt=0 }
{
	if(index(\$0,"<H4>")) h4cnt++
	if(started && h4cnt > 3) exit # Two days
	if(index(\$0,"Recent Infowar.Com")) { title=""; started=1; next }
	if(! started) next
	if( (! (ix1=index(\$0,"<li>"))) && (! (ix1=index(\$0,"<LI>"))) ) next
	print2(2)
	s1=substr(\$0,ix1+13); ix2=index(s1,"\""); link=substr(s1,1,ix2-1)
	make_link("www.infowar.com/new_iwc")
	s1=substr(s1,ix2+1); ix2=index(s1,">"); s2=substr(s1,ix2+1)
	ix1=index(s2,"<"); title=substr(s2,1,ix1-1)
}
@
# gnomeNews
cat > $AWK34 <<@
BEGIN { maxnum=refered=0; skip=1; desc=""; num=0 }
{
	s0=\$0
	if(index(s0,"References")) { refered=1; next }
	if(refered) {
		if(! (ix=index(s0,"."))) next
		num=substr(s0,1,ix-1)+0; link=substr(s0,ix+2)
		if(index(link,"mailto:")) next
		if(! length(a[num])) next
		b[num]=link; maxnum=(maxnum < num) ? num : maxnum
	} else
	if(skip == 1) { if(index(s0,"]search")) { title=""; skip=2; next }}
	if(index(s0,"]Software")) { skip=9; next }
	if(skip == 2) {
		if(length(s0) < 4 || substr(s0,4,1) == " ") next 
		title=s0; skip=3
	} else
	if(skip == 3) {
		if(ix1=index(s0,"Read More...")) {
			if(ix1=index(s0,"[")) {
				s1=substr(s0,ix1+1); ix2=index(s1,"]"); num=substr(s1,1,ix2-1)+0
				a[num]=title; c[num]=cut2(desc); desc=""; skip=2
			}
		} else desc=desc " " deb(s0)
	}
}
END {
	for(i=0;i<=maxnum;i++) if(length(b[i])) printf("&&\n%s\n%s\n%s\n",deb(a[i]),b[i],c[i])
}
@
# linuxlock
cat > $AWK35 <<@
BEGIN { FS="<"; title=link=desc=date9=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</body>")) exit
	if(index(s0,"<!-- begin news content table -->")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"<!-- id num")) print1(); else
	if(ix1=index(s0,"href")) {
		get_link(); ix2=index(s1,"<"); title=substr(s1,1,ix2-1)
	} else
	if(ix1=index(s0,"align=right>")) {
		s1=substr(s0,ix1+12); ix2=index(s1,"<"); date9=substr(s1,1,ix2-1)
	} else
	if(substr(s0,1,1) != "<") desc=desc " " s0
}
function print1() {
	if(length(title) && substr(link,1,4) == "http")
		printf("&&\n%s\n%s\n%s %s\n",title,link,date9,cut1(desc))
	title=link=desc=date9=""
}
END { if(length(title)) print1() }
@
# linuxplace
cat > $AWK36 <<@
BEGIN { maxnum=refered=0; skip=1; desc=""; num=0 }
{
	s0=\$0
	if(index(s0,"References")) { refered=1; next }
	if(refered) {
		if(! (ix=index(s0,"."))) next
		num=substr(s0,1,ix-1)+0; link=substr(s0,ix+2)
		if(index(link,"mailto:")) next
		if(! length(a[num])) next
		b[num]=link; maxnum=(maxnum < num) ? num : maxnum
	} else
	if(skip == 1) { if(index(s0,"]Procurar")) { title=""; skip=2; next }}
	if(index(s0,"Busca Linux")) { skip=9; next }
	if(skip == 2) {
		if(length(s0) > 3 && substr(s0,4,1) != " " && substr(s0,4,1) != "(") {
			title=s0; skip=3; next
		}
	} else
	if(skip == 3) {
		if(ix1=index(s0,"[")) {
			s1=substr(s0,ix1+1); ix2=index(s1,"]"); num=substr(s1,1,ix2-1)+0
			skip=4; next
		}
	} else
	if(skip == 4) {
		if(ix1=index(s0,"Leia Mais...")) {
			if(ix1=index(s0,"[")) {
				s1=substr(s0,ix1+1); ix2=index(s1,"]"); num=substr(s1,1,ix2-1)+0
				a[num]=title; c[num]=desc; desc=""; skip=2
			}
		} else desc=desc " " s0
	}
}
END {
	for(i=0;i<=maxnum;i++) if(length(b[i])) printf("&&\n%s\n%s\n%s\n",deb(a[i]),b[i],c[i])
}
@
# nikkansports
cat > $AWK37 <<@
BEGIN { FS="<"; title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!--Start of Footer-->")) exit
	if(index(s0,"<!-- End of Header -->")) { title=""; started=1; next }
	if(! started) next
	if((substr(s0,1,12) == "<td bgcolor=") && index(s0,"font size=")) {
		link=""; title="<B>" deb(cut1(s0)) "</B>"; print2(2)
	}
	else
	if(ix1=index(s0,"href")) {
		link_title4(); make_link("www.nikkansports.com/news/flash")
		day1=cut1(s1); title=substr(day1,2,2) substr(day1,6,6) " " title
		gsub("","<B>",title); gsub("","</B>",title); print2(2)
	}
}
@
# AWK38 in use
# debianJp
cat > $AWK39 <<@
BEGIN { FS="<"; title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<hr>")) exit
	if(index(s0,"<H1>ǿ˥塼</H1>")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		link_title(); make_link("www.debian.org/News"); desc=cut1(s0); print2(3)
	}
}
@
# cnn
cat > $AWK40 <<@
BEGIN { title=link="" }
{
	s0=\$0
	if(ix1=index(s0,"a href")) entry1("class=\"Header",1); else
	if(ix1=index(s0,"A HREF")) entry1("class=\"Link",0)
}
function entry1(str1,b) {
	s1=substr(s0,ix1+8); ix2=index(s1,"\""); link=substr(s1,1,ix2-1)
	if(substr(link,1,1) == "#") return
	make_link("www.cnn.com"); s2=substr(s1,ix2+2);  ix3=index(s2,str1)
	s1=substr(s2,ix3+length(str1)+2); ix2=index(s1,"<")
	title=((b) ? "<b>" : "") substr(s1,1,ix2-1) ((b) ? "</b>" : "")
	if(! b) desc=title; print2(3)
}
@
# bugnet
cat > $AWK41 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</tr>")) exit
	if(index(s0," Alerts</b></font>")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		print1(); get_link(); title=s1; make_link("www.bugnet.com")
	}
	else title=title " " s0
}
function print1() {
	title=cut1(title); gsub("--","",title)
	for(i7=1;i7<=5;i7++) gsub("  "," ",title)
	title=deb(title); print2(2)
}
END { if(length(title)) print1() }
@
# techweb
cat > $AWK42 <<@
BEGIN { FS="<"; title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"production")) { title=""; started=1; next }
	if(index(s0,"CMP is currently")) { title=desc=s0; link=""; print1() }
	if(! started) next
	if(ix1=index(s0,"HREF")) {
		print1(); get_link(); ix2=index(s1,"<"); title=substr(s1,1,ix2-1)
	}
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); gsub("&#149;","",desc); print2(3) }
END { if(length(title)) print1() }
@
# littleigloo
cat > $AWK43 <<@
BEGIN { title=link=desc=""; started=0 }
{
	if(started && index(\$0,"Hopkins FBI for Linux")) exit
	if(index(\$0,"<!-- IceWalkers Search Box Code END -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"HREF")) {
		get_link(); ix1=index(s1,">"); s1=substr(s1,ix1+1)
		ix1=index(s1,"<"); title=substr(s1,1,ix1-1)
		desc=cut1(substr(s1,ix1)); print2(3)
	}
}
@
# wiredTechnology
cat > $AWK44 <<@
BEGIN { FS="<"; title=link=desc=""; started=0 }
{
	if(started && index(\$0,"<!-- end generic desk")) exit
	if(index(\$0,"<!-- begin generic desk")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"href")) {
		print1(); get_link(); make_link("www.wired.com")
		s2=substr(s1,15); ix2=index(s2,"<"); title=substr(s2,1,ix2-1)
	}
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); print2(3) }
END { if(length(title)) print1() }
@
# hackernews
cat > $AWK45 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"More cracks...")) exit
	if(index(s0,"<B>Latest cracked pages")) { started=1; next }
	if(! started) next
	if(ix1=index(s0,"href=")) { link_title(); print2(2) }
}
@
# enlightenment
cat > $AWK46 <<@
BEGIN { title=link=""; begin1=started=0 }
{
	s0=\$0
	if(ix1=index(s0,"href=")) {
		print1(); get_link3(); title=cut1(s1)
		if(substr(link,1,7) == "http://") title=link=""; else
		if(substr(title,1,10) == "What is En") title=link=""; else
		make_link("www.enlightenment.org")
	}
	else
	if(ix1=index(s0,"arial size=2>")) {
		print1(); title=cut1(s0); link="index.html"
		make_link("www.enlightenment.org")
		if(! begin1) title=link=""
	}
	else if(index(s0,"Useful Information")) begin1=1
	else if(index(s0,"Mirrors of Enlightenment")) exit
	else title=title " " cut1(s0)
}
function print1() { if(length(link)) print2(2) }
END { if(length(link)) print1() }
@
# linuxComDownload
cat > $AWK47 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"<b>More Distributions")) exit
	if(index(\$0,"Linux Distributions</h3>")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"href")) {
		print2(3); get_link(); make_link("linux.com/getlinux"); title=cut1(s1)
	}
	else desc=desc " " cut1(s0)
}
END { if(length(title)) print2(3) }
@
# insecure
cat > $AWK48 <<@
BEGIN { title=title2=link=desc=""; started=type=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"Good Reading List </CENTER>")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"<LI>")) { print1(); type=1 }
	if((ix1=index(s0,"HREF")) && type == 1) {
		get_link(); title2=s1; make_link("www.insecure.com")
		if(ix1=index(title2,"</A>")) {
			title=substr(title2,1,ix1-1); desc=substr(title2,ix1+4); type=3
		} else type=2
	}
	else
	if((ix1=index(s0,"</A>")) && type == 2) {
		title=title2 " " substr(s0,1,ix1-1); desc=substr(s0,ix1+4); type=3
	}
	else if(type == 3) desc=desc " " s0
}
function print1() {
	gsub(/&quot;/,"\"",title); gsub(/\\\\/,"",title)
	title=deb(cut1(title)); desc=cut1(desc); print2(3); title2=""
}
END { if(length(title)) print1() }
@
# cnet
cat > $AWK49 <<@
BEGIN { title=link=""; started=0 }
{
	if(index(\$0,"<blockquote>")) started=1
	if((started == 1) && (ix1=index(\$0,"#CC0000'><b>"))) started=2
	if(started < 2) next
	s0=substr(\$0,ix1)
	while(ix1=index(s0,"href")) {
		link_title(); make_link("news.cnet.com"); print2(2); s0=substr(s1,ix2+4)
		if((ix4=index(s0,"#CC0000")) && ix4 < 70) exit
	}
}
@
# linuxOrgNews
cat > $AWK50 <<@
BEGIN { title=link=desc=""; type=started=0 }
{
	s0=\$0
	if(started && index(s0,"News for other months")) exit
	if(index(s0,"NAME=\"ShowNews")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF")) {
		print1(); s1=substr(s0,ix1+6)
		if(ix2=index(s1,"\"")) {
			get_link(); title=deb(cut1(s0)); type=(length(title) == 0)
			type=(! index(s0,"</A>"))
		}
		else type=1
	}
	else
	if(type) {
		if(ix1=index(s0,"\"")) { link=substr(s0,1,ix1-1); title=cut1(substr(s0,ix1+2)) }
		else { title=title " " cut1(s0); type=(! index(s0,"</A>")) }
	}
	else desc=desc " " s0
}
function print1() {
	if(substr(title,1,3) == "[3]") title=""
	if(substr(title,1,14) == "Other pages ..") title=""
	desc=cut1(desc); if(length(link)) print2(3); title=""; type=0
}
END { if(length(title)) print1() }
@
# linuxOrgBook
cat > $AWK51 <<@
BEGIN { title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(\$0,"</TABLE>")) exit
	if(index(s0,"<B>Previously Featured Books")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF=\"/books/FEATURE_")) {
		print1(); link_title(); make_link("www.linux.org"); desc=substr(s1,ix2)
	}
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); print2(3) }
END { if(length(title)) print1() }
@
# debian
cat > $AWK52 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<hr>")) exit
	if(index(s0,"<H1>Latest News</H1>")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		desc=cut1(substr(s0,1,ix1-4)); link_title()
		make_link("www.debian.org"); desc=desc " " title; print2(3)
	}
}
@
# ibiblio
cat > $AWK53 <<@
BEGIN { FS="<"; title=link=desc=""; started=type=0 }
{
	s0=\$0
	if(index(s0,"square2.gif")) { print1(); type=1 } else
	if((type == 1) && (ix1=index(s0,"href"))) {
		get_link(); title2=s1; type=2
	} else
	if(type == 2) {
		ix1=index(s0,"<"); title=title2 deb(substr(s0,1,ix1-1))
		desc=substr(s0,ix1); type=3
	} else
	if(type == 3) desc=desc " " s0
}
function print1() { title=cut1(title); desc=cut1(desc); print2(3) }
END { if(length(title)) print1() }
@
# emusic
cat > $AWK54 <<@
BEGIN { title=link=""; started=type=0 }
{
	s0=\$0
	if(started && index(s0,"<!--END CONTENT-->")) exit
	if(index(s0,"<!--BEGIN CONTENT-->")) { title=""; type=0; started=1; next }
	if(! started) next
	if(type == 0 && ((ix1=index(s0,"href")) || (ix1=index(s0,"HREF")))) {
		print1(); get_link(); title=s1
		gsub("localhost:81","www.emusic.com",link); type=1
	}
	else
	if(type == 1) title=title deb(s0)
	else
	if(index(s0,"color=\"#FFFFFF\"")) {
		title=deb(cut1(s0)); gsub("&nbsp;","",title)
		if(length(title)) { title="<B>" title "</B>"; link=""; print2(2) }
	}
	if(index(s0,"</td>")) type=0
}
function print1() { title=deb(cut1(title)); print2(2) }
END { if(length(title)) print1() }
@
# music
cat > $AWK55 <<@
BEGIN { title=link=""; started=type=0 }
{
	if(started && index(\$0,"// END CONTENT")) exit
	if(index(\$0,"// START CONTENT")) { title=""; type=0; started=1; next }
	if(! started) next
	s0=\$0
	if(type == 0 && (ix1=index(s0,"href"))) {
		print1(); title=substr(s0,1,ix1-4); get_link()
		make_link("www.music.com")
		ix3=index(s1,">"); title=title substr(s1,ix3+1); type=1
	} else
	if(type == 1) title=title deb(s0)
	if(index(s0,"<br>")) type=0
}
function print1() { title=deb(cut1(title)); print2(2) }
END { if(length(title)) print1() }
@
# real
cat > $AWK56 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if((ix1=index(s0,"top10music;")) || (ix1=index(s0,"top10movie;"))) {
		if(index(s0,"HREF")) {
			s1=substr(s0,ix1+5); ix1=index(s1,";")
			title="=== TOP 10 " substr(s1,1,ix1-1) " ==="; link=""; print2(2)
		}
		started=1; next
	}
	if(! started) next
	if(ix1=index(s0,"href")) { link_title2(); make_link("www.real.com"); print2(2) }
	if(started && index(s0,"</ol>")) exit
}
@
# realguide
cat > $AWK57 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	while(ix1=index(s0,"<a href=\"/RGX")) {
		title=deb(cut1(substr(s0,1,ix1-1)))
		for(i=1;i<=5;i++) gsub("  "," ",title)
		if(length(link)) print1()
		s1=substr(s0,ix1+9); ix2=index(s1,"\""); link=substr(s1,1,ix2-1)
		s2=substr(s1,ix2+1); ix2=index(s2,">"); s0=substr(s2,ix2+1)
		if(index(link,"vram") && index(link,".txt.ch"))
			make_link("realguide.real.com");
		else
			link=""
	}
}
function print1() {
	if(ix8=index(title,"Tell a Friend")) title=substr(title,1,ix8-1)
	desc=title; print2(3)
}
END { if(length(title) && length(link)) print1() }
@
# film
cat > $AWK58 <<@
BEGIN { title=link=desc=""; started=type=0 }
{
	s0=\$0
	if(started && index(s0,"- stop insert above -")) exit
	if(index(s0,"- insert info below -")) { title=""; started=1; next }
	if(! started) next
	if(substr(s0,1,3) == "<b>" && index(s0,")")) {
		print1(); title=cut1(s0); ix1=index(title,")")
		title=substr(title,ix1+1); type=1
	} else
	if(type == 1 && substr(s0,1,8) == "<a href=") {
		ix1=index(s0,"href"); get_link(); desc=cut1(desc); type=2
	} else
	if(type == 1) desc=desc " " s0
}
function print1() {
	gsub("&nbsp;","",title); print2(3)
}
END { if(length(title)) print1() }
@
# icecast
cat > $AWK59 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</body>")) exit
	if(index(s0,"<b>Uptime</b>")) { title=""; started=1; next }
	if(! started) next
	while(ix1=index(s0,"href=\"/cgi-bin")) {
		print1(); get_link(); make_link("yp.icecast.org")
		ix2=index(s1,"</table>"); title=cut1(substr(s1,1,ix2-1))
		for(j=1;j<=5;j++) gsub("  "," ",title)
		s0=substr(s1,ix2+8)
	}
}
function print1() { desc=title; print2(3) }
END { print1() }
@
# shoutcast
cat > $AWK60 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Genre [Description")) exit
	if(index(s0,"Genre [Description")) { title=link=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href=\"/sbin/shoutcast")) {
		print1(); get_link(); make_link("www.shoutcast.com")
	}
	else title=title " " s0
}
function print1() {
	if(length(link)) {
		gsub("&nbsp;"," ",title); title=deb(cut1(title))
		if(ix2=index(title,"]")) title=substr(title,ix2+1)
		for(j=1;j<=5;j++) gsub("  "," ",title); desc=title; print2(3)
	}
	else title=link=""
}
END { if(length(title)) print1() }
@
# heise
cat > $AWK61 <<@
BEGIN { title=link=desc=""; started=0 }
{
	if(started && index(\$0,"<!-- MITTE (NEWS-UEBERBLICK) -->")) exit
	if(index(\$0,"<!-- MITTE (NEWS) -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(substr(s0,1,7) == "<A HREF") {
		ix1=4; link_title(); s2=substr(s1,ix2); make_link("www.heise.de")
		if(ix1=index(s2,"<A HREF")) desc=cut1(substr(s2,1,ix1-1));
		else desc=cut1(s2)
		print2(3)
	}
}
@
# gtkThemes
cat > $AWK62 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"feedback</font>")) exit
	if(index(s0,"new&nbsp;&nbsp;themes")) {
		title="<B>" cut1(s0) "</B>"; print1(); started=1; next
	}
	if(! started) next
	if((ix5=index(s0,"img src=")) && index(s0,"_small.jpg")) {
		print1(); get_scr()
	}
	else if(ix1=index(s0,"top&nbsp;&nbsp;5</font>")) {
		print1(); title="<B>" cut1(s0) "</B>"; print1()
	}
	else if(ix1=index(s0,"href=\"/themes.phtml")) {
		link_title(); make_link("gtk.themes.org"); print1()
	}
	else if(ix1=index(s0,"href=\"http://gtk.themes.org/")) {
		link_title(); make_link("gtk.themes.org")
	}
	else title=title " " cut1(s0)
}
function print1() { if(length(deb(title))) print2(4) }
END { print1() }
@
# eThemes
cat > $AWK63 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"feedback</font>")) exit
	if(index(s0,"new&nbsp;&nbsp;themes")) {
		title="<B>" cut1(s0) "</B>"; print1(); started=1; next
	}
	if(! started) next
	if((ix5=index(s0,"img src=")) && index(s0,"_small.jpg")) {
		print1(); get_scr()
	}
	else if(ix1=index(s0,"top&nbsp;&nbsp;5</font>")) {
		print1(); title="<B>" cut1(s0) "</B>"; print1()
	}
	else if(ix1=index(s0,"href=\"/themes.phtml")) {
		link_title(); make_link("e.themes.org"); print1()
	}
	else if(ix1=index(s0,"href=\"http://e.themes.org/")) {
		link_title(); make_link("e.themes.org")
	}
	else title=title " " cut1(s0)
}
function print1() { if(length(deb(title))) print2(4) }
END { print1() }
@
# cbs
cat > $AWK64 <<@
BEGIN { FS="["; maxnum=refered=0; skip=1; s8="" }
{
	s0=\$0
	if(index(s0,"References")) { refered=1; next }
	if(refered) {
		if(! (ix=index(s0,"."))) next
		num=substr(s0,1,ix-1)+0; link=substr(s0,ix+2)
		if(index(link,"mailto:")) next
		if(! length(a[num])) next
		b[num]=link; maxnum=(maxnum < num) ? num : maxnum
	}
	else
	if(NF == 1 && substr(s0,1,11) == "   National") skip=4; else
	if(NF == 1 && substr(s0,1,6) == "   in ") { s8=" in " substr(s0,7) ":"; skip=2 } else
	if(skip == 2 && (ix1=index(\$2,"]"))) {
		num=substr(\$2,1,ix1-1)+0; a[num]=substr(\$2,ix1+1)
		c[num]=s8; s8=""; skip=3
	}
	else
	if(skip == 3) {
		if((ix1=index(s0,"TOP STORIES")) || (ix1=index(s0,"["))) {
			s0=substr(s0,1,ix1-1); skip=1
		}
		c[num]=c[num] " " s0
	}
}
END { for(i=0;i<=maxnum;i++) if(length(b[i])) printf("&&\n%s\n%s\n%s\n",a[i],b[i],c[i]) }
@
# fortune
cat > $AWK65 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"Fortune 500<BR>Rank")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF")) {
		get_link3(); ix2=index(s1,"<"); title=substr(s1,1,ix2-1)
		desc=cut1(substr(s1,ix2))
		if(title != "Add to" && title != "Guru") print2(3)
	}
}
@
# forbes
cat > $AWK66 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</table>")) exit
	if(index(s0,"<!--/list title/years-->")) { title=""; started=1; next }
	if(! started) next
	if((ix1=index(s0,"href=")) && (! index(s0,"ordered by"))) {
		print1(); get_link2(); make_link("www.forbes.com")
		ix2=index(s1,">"); s1=substr(s1,ix2+1)
		title=(ix2=index(s1,"<")) ? substr(s1,1,ix2-1) : s1
	}
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); print2(3) }
END { if(length(title)) print1() }
@
# yahoo
cat > $AWK67 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"Earlier Stories")) exit
	if(index(\$0,"<!-- _JC_  STORIES -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"href=\"http://dailynews.yahoo.com/h/nm")) {
		link_title5("</a>"); desc=cut1(s1); print2(3)
	}
}
@
# gamefan
cat > $AWK68 <<@
BEGIN { title=link=""; down=started=0 }
{
	s0=\$0
	if(ix1=index(s0,"<title>Server Downtime</title>")) {
		down=1; title=deb(cut1(s0)); make_link("www.gamefan.com"); next
	}
	if(down) { desc=desc " " cut1(s0); next }
	if(started && index(s0,"CLICK HERE FOR MORE NEWS")) exit
	if(index(s0,"multi/default_headlines_top.gif")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) { link_title(); make_link("www.gamefan.com"); print2(3) }
	else desc=desc " " deb(cut1(s0))
}
END { if(down) print2(3) }
@
# kuro5hin
cat > $AWK69 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"SIZE=2>Sponsors</FONT")) exit
	if(index(s0,"<!-- begin story summary -->")) { title=""; started=1; next }
	if(! started) next
	if((ix1=index(s0,"HREF")) && index(s0,"Full Story")) {
		get_link(); make_link("www.kuro5hin.org"); print2(3)
	}
	else
	if(ix1=index(s0,"COLOR=\"#000000\" SIZE=2><B><B>")) {
		s1=substr(s0,ix1+29); ix1=index(s1,"<"); title=cut1(substr(s1,1,ix1-1))
	}
	else desc=desc " " deb(cut1(s0))
}
@
# bbc
cat > $AWK70 <<@
BEGIN { title=link=desc=""; started=0; type=3 }
{
	if(started && index(\$0,"NewsOnLineQLX")) exit
	if(index(\$0,"FrontPageStoryBody")) { title=link=desc=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"href")) {
		type=1; print3(); get_link(); make_link("news.bbc.co.uk")
		if(ix2=index(s1,"</A>")) {
			title=substr(s1,1,ix2-1); desc=substr(s1,ix2+4); type=2
		}
		else title=title s1
	}
	else
	if(ix2=index(s0,"<BR>")) next
	else
	if(ix2=index(s0,"</A>")) {
		title=title substr(s0,1,ix2-1); desc=substr(s0,ix2+4); type=2
	}
	else
	if(type == 2) desc=desc s0
	else
	if(type == 1) title=title s0
}
function print3() {
	gsub("\r","",title); title=deb(cut1(title))
	gsub("\r","",desc);  desc =deb(cut1(desc))
	print2(3)
}
END { print3() }
@
# linuxsecurity
cat > $AWK71 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"center><b>Enquete")) exit
	if(index(s0,"src=ologo.gif")) { title=""; started=1; next }
	if(! started) next
	if(substr(s0,1,3) == "<b>") title=cut1(s0); else
	if(index(s0,"<b>Mais infor") && (ix1=index(s0,"href"))) {
		get_link(); make_link("www.linuxsecurity.com.br"); print1()
	}
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); print2(3) }
END { if(length(title)) print2(3) }
@
# oreilly
cat > $AWK72 <<@
BEGIN { title=link=""; started=0; type=1 }
{
	if(started && index(\$0,"</table>")) exit
	if(index(\$0,"<b>Products</b>")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"HREF")) {
		print2(2); get_link()
		if(ix1=index(s1,"</A>")) { title=substr(s1,1,ix1-1); type=1 }
		else { title=s1; type=2 }
	}
	else
	if(type == 2) {
		ix1=index(s0,"</A>"); title=title " " substr(s0,1,ix1-1); type=1
	}
}
END { if(length(title)) print2(2) }
@
# pro-linux
cat > $AWK73 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"News-Archiv</a>")) exit
	if(index(\$0,"#ffffff\">NEWS</font>")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"href")) {
		if(length(link)) { title=deb(cut1(title)); print2(2) }
		title=link=""
		get_link(); make_link("www.pro-linux.de")
	}
	else if(length(s0) < 5) next; else title=title s0
}
END {
	if(length(title) && length(link)) { title=deb(cut1(title)); print2(2) }
}
@
# digitalblasphemy
cat > $AWK74 <<@
BEGIN { title=link=""; started=0; type=1 }
{
	if(started && index(\$0,"</TABLE>")) exit
	if(index(\$0,"tell a friend!</A>")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	while(ix1=index(s0,"href")) {
		s1=substr(s0,ix1+6); ix2=index(s1,"'"); link=substr(s1,1,ix2-1)
		make_link("www.digitalblasphemy.com"); s0=substr(s1,ix2+2)
		ix2=index(s0,"img src=")
		if(ix2) {
			s1=substr(s0,ix2+9); ix2=index(s1,"\""); scr=substr(s1,1,ix2-1)
			make_scr("www.digitalblasphemy.com")
			s1=substr(s1,ix2+1); ix2=index(s1,">"); s0=substr(s1,ix2+1)
		}
		if(ix1=index(s0,"</tr>")) {
			title=substr(s0,1,ix1-1); gsub("</a>","@",title); title=deb(cut1(title))
			ix2=index(title,"@"); title=substr(title,ix2+1) " " substr(title,1,ix2-1)
			s0=substr(s0,ix1+5)
		}
		print2(4); if(substr(s0,1,8) == "</table>") break
	}
}
@
# theregister
cat > $AWK75 <<@
BEGIN { title=link=desc=""; started=0; save_s0=""; type=0 }
{
	gsub("\r","",\$0); if(length(\$0) < 1) next
	s0=save_s0 " " \$0
	if(ix1=index(s0,"<HR>")) { title=link=desc=""; started=1; s0=substr(s0,ix1+4) }
	if(! started) next
	if(type == 1) {
		ix1=index(s0,"</A>"); title=cut1(substr(s0,1,ix1-1));
		s0=substr(s0,ix1+4); type=2
	}
	if(type == 2) {
		ix1=index(s0,"<STRONG>More</STRONG>")
		desc=cut1(substr(s0,1,ix1-1)); type=0; print2(3)
		s0=substr(s0,ix1+21); if((ix3=index(s0,"</TABLE>")) && ix3 < 40) exit
	}
	while(ix1=index(s0,"HREF")) {
		get_link(); make_link("www.theregister.co.uk")
		ix1=index(s1,"</A>"); if(! ix1) { s0=s1; type=1; break }
		title=cut1(substr(s1,1,ix1-1)); s2=substr(s1,ix1+4)
		ix1=index(s2,"<STRONG>More</STRONG>"); if(! ix1) { s0=s2; type=2; break }
		desc=cut1(substr(s2,1,ix1-1)); type=0; print2(3)
		s0=substr(s2,ix1+21); if((ix3=index(s0,"</TABLE>")) && ix3 < 40) exit
	}
	save_s0=s0
}
@
# linuxhq
cat > $AWK76 <<@
BEGIN { title=link=""; type=1 }
{
	s0=\$0; if(index(s0,"I</FONT>NFORMATION")) exit
	if(ix1=index(s0,"HREF")) {
		print1(); s8=(index(s0,"<LI>")) ? "____" : ""
		get_link(); if(substr(link,1,7) == "mailto:") next
		make_link("www.linuxhq.com")
		if(ix1=index(s1,"</A>")) { title=s8 cut1(substr(s1,1,ix1-1)); type=1 }
		else { title=s8 s1; type=2 }
	} else if(type == 2) { title=title " " s0 }
}
function print1() { title=cut1(title); print2(2) }
END { if(length(title)) print1() }
@
# tky
cat > $AWK77 <<@
BEGIN { title=link=desc=""; started=0; type=1 }
{
	s0=\$0; str4=substr(s0,1,4); str3=substr(s0,1,3)
	if(str3 == "-->")  started=1
	if(str4 == "<!--") started=0
	if(started && index(s0,"mailto:tomi.sarvela")) exit
	if(index(s0,"<TD><B>download</B>")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"<TR>")) next
	if(type == 2) {
		if(ix1=index(s0,"</TR>")) {
			desc=desc " " s0; gsub("</TD>"," ",desc)
			desc=cut1(desc); type=1; print2(3)
		} else desc=desc " " s0
	} else
	if(ix1=index(s0,"HREF")) {
		link_title(); make_link("nether.tky.hut.fi/iconstore")
		if(ix1=index(s1,"</TR>")) { desc=substr(s1,1,ix1-1); type=1 }
		else { desc=s1; type=2 }
	}
}
@
# kernelnotes
cat > $AWK78 <<@
BEGIN { maxnum=refered=0; skip=1; mirror=0 }
{
	if(index(\$0,"References")) { refered=1; next }
	if(refered) {
		if(! (ix=index(\$0,"."))) next
		num=substr(\$0,1,ix-1)+0; link=substr(\$0,ix+2)
		if(index(link,"mailto:")) next
		if(! length(a[num])) next
		b[num]=link; maxnum=(maxnum < num) ? num : maxnum
	}
	else
	if(skip == 1) {
		if(index(\$0,"NEWS")) { skip=2; next }
	}
	else
	if(skip == 2) {
		if(index(\$0,"mirrors)")) { if(++mirror >= 2) { skip=3; next } }
		s0=\$0
		while(ix1=index(s0,"[")) {
			s1=substr(s0,ix1+1); if(! (ix2=index(s1,"]"))) break
			num=substr(s1,(substr(s1,1,1) "" == "[") ? 2 : 1,ix2-1)+0
			s0=substr(s1,ix2+1)
			if(ix1=index(s0,"[")) {
				s3=substr(s0,1,ix1-1)
				if(substr(s3,1,5) != "Linux") s3="__" s3
				a[num]=s3; less_than(); chg1(); s0=substr(s0,ix1)
			}
			else {
				if(substr(s0,1,5) != "Linux") s0="__" s0
				a[num]=s0; less_than(); chg1(); break
			}
		}
	}
}
function chg1() {
	gsub("/","",a[num]); gsub("\)","",a[num]); gsub(/\(Download\:/,"",a[num])
}
END { for(i=0;i<=maxnum;i++) if(length(b[i])) printf("&&\n%s\n%s\n",a[i],b[i]) }
@
# anandtech
cat > $AWK79 <<@
BEGIN { title=link=""; type=1 }
{
	if(index(\$0,"<b>More Articles")) exit
	s0=\$0
	if(index(s0,"<!-- new article item")) { print2(3); type=1 }
	else
	if(index(s0,"color=\"016a96")) { title=deb(cut1(s0)); gsub("\r","",title) }
	else
	if((ix1=index(s0,"href")) && type == 1) {
		get_link(); make_link("www.anandtech.com"); type=2
	}
	else { desc=desc " " deb(cut1(s0)) }
}
END { if(length(title)) print2(3) }
@
# linux-madrake
cat > $AWK80 <<@
BEGIN { title=link=desc=""; started=0; best20=0 }
{
	if(started && index(\$0,"</body>")) exit
	if(index(\$0,"LINUX MANDRAKE NEWS")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"<!--fast-->")) {
		if(++best20 > 21) exit
		if(ix1=index(desc,"href")) {
			s1=substr(desc,ix1+6); ix1=index(s1,"\""); link=substr(s1,1,ix1-1)
			make_link("www.linux-mandrake.com/en")
		}
		if(ix1=index(title," - ")) {
			desc=substr(title,1,ix1-1) " " desc; title=substr(title,ix1+3)
		}
		desc=cut1(desc); print2(3)
	}
	else
	if(ix1=index(s0,"<b>")) {
		s1=substr(s0,ix1+3); ix1=index(s1,"</b>")
		title=substr(s1,1,ix1-1); desc=substr(s1,ix1+4)
	} else desc=desc " " s0
}
@
# fokus
cat > $AWK81 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"<TITLE>A vision is dying")) {
		title=cut1(s0); print2(2); next
	}
	if(index(s0,"Main Linux Distributions</A>")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF")) { link_title2(); print2(2) }
}
@
# linux-magazin
cat > $AWK82 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"The Linux Problem Solver</a>")) exit
	if(index(s0,"Linux-Community-News</a>")) { title=""; started=1; next }
	if(index(s0,"<TITLE>Temporarily Unavailable</TITLE>")) { title=cut1(s0); print2(2) }
	if(! started) next
	if(ix1=index(s0,"href")) { print1(); get_link() } else title=title " " s0
}
function print1(ix7) {
	if(length(title) && length(link)) {
		title=deb(cut1(title))
		if(ix7=match(title,/[0-9][0-9].[0-9][0-9].[0-9][0-9][0-9][0-9]/))
			title=substr(title,ix7,5) " " deb(substr(title,1,ix7-1))
		print2(2)
	}
	else title=link=""
}
END { print1() }
@
# linuxdevices
cat > $AWK83 <<@
BEGIN { FS=">"; title=link=""; started=0 }
{
	if(started && index(\$0,"<b>Latest headlines:</b>")) exit
	if(index(\$0,"<table width=\"100%\" cellpadding=5>")) { title=""; started=1; next }
	s0=\$0; if(! started) next
	if(ix1=index(s0,"bgcolor='#FCEC9C'")) title=cut1(\$3)
	else
	if(ix1=index(s0,"href")) {
		get_link(); make_link("www.linuxdevices.com"); desc=cut1(desc); print2(3)
	}
	else desc=desc " " s0
}
@
# linuxworld
cat > $AWK84 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"<TABLE CELLPADDING=")) exit
	if(index(\$0,"News</A>")) { title=""; started=1; next }
	if(started == 1 && index(\$0,"</TR>")) { title=""; started=2; next }
	if(started < 2) next
	s0=\$0
	while(ix1=index(s0,"HREF")) {
		print1(); link_title(); make_link("www.linuxworld.com"); s0=s1
	}
}
function print1() { desc=title; print2(3) }
END { if(length(title)) print1() }
@
# linuxfr
cat > $AWK85 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- SIDEBOX -->")) exit
	if(index(s0,"<!-- NEWSBOX ")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0," class=\"newstitle")) title=cut1(s0); else
	if((ix1=index(s0,"href")) && index(s0,"commentaire")) {
		get_link(); desc=cut1(desc); print2(3)
	}
	else desc=desc " " s0
}
@
# nodevice
cat > $AWK86 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"<TD ALIGN=RIGHT ")) exit
	if(index(\$0,"<!-- include tt_section -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"HREF")) {
		link_title(); make_link("www.nodevice.com"); print2(2)
	}
}
@
# cs
cat > $AWK87 <<@
BEGIN { title=link="" }
{
	s0=\$0
	while(ix1=index(s0,"href")) {
		link_title(); s0=substr(s1,ix2)
		if(link != "../cola.html") {
			make_link("www.cs.helsinki.fi/u/mjrauhal/linux/cola.archive")
			desc=title; print2(3)
		}
	}
}
@
# salon
cat > $AWK88 <<@
BEGIN { title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- END ARTICLE COPY -->")) exit
	if(index(s0,"<!-- BEGIN ARTICLE COPY -->")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) { print1(); link_title(); make_link("www.salon.com") }
	else desc=desc " " cut1(s0)
}
function print1() {
	if(ix9=index(desc,"- - -")) desc=substr(desc,1,ix9-1)
	print2(3)
}
END { if(length(title)) print1() }
@
# linevents
cat > $AWK89 <<@
BEGIN { maxnum=refered=0; skip=1; mirror=0 }
{
	if(index(\$0,"References")) { refered=1; next }
	if(refered) {
		if(! (ix=index(\$0,"."))) next
		num=substr(\$0,1,ix-1)+0; link=substr(\$0,ix+2)
		if(index(link,"mailto:")) next
		if(! length(a[num])) next
		b[num]=link; maxnum=(maxnum < num) ? num : maxnum
	}
	else
	if(skip == 1) { if(index(\$0,"________________________")) { skip=2; next } }
	else
	if(skip == 2) {
		if(index(\$0,"________________________")) { skip=3; next }
		s0=\$0
		if(ix1=match(s0,/[0-9]\. \[[0-9][0-9]\]/)) {
			ix1=index(s0,"["); s1=substr(s0,ix1+1); ix2=index(s1,"]")
			num=substr(s1,1,ix2-1)+0
			s1=substr(s1,ix2+1); ix1=index(s1,"LUG Meeting:")
			a[num]=substr(s1,ix1+12); less_than()
		}
		else if(! index(s0,"more ...")) c[num]=c[num] " " deb(s0)
	}
}
END { for(i=0;i<=maxnum;i++) if(length(b[i])) printf("&&\n%s\n%s\n%s\n",a[i],b[i],c[i]) }
@
# computeruser
cat > $AWK90 <<@
BEGIN { title=link=desc=""; started=0; type=1 }
{
	if(started && index(\$0,"</table>")) exit
	if(index(\$0,"Linux - Games</font>")) { title=desc=""; started=1; next }
	if(! started) next
	s0=\$0
	if(index(s0,"<tr")) { type=1; title=link=desc="" }
	if((ix1=index(s0,"href")) && type == 1) { link_title2(); type=2 }
	else if(index(s0,"</tr>")) print1()
	else if(type == 2) desc=desc " (" deb(cut1(s0)) ")"
}
function print1() {
	title=title " " desc; gsub(/ \(\)/,"",title); if(length(link)) print2(2)
	desc=""; type=1
}
@
# linuxinsider
cat > $AWK91 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- End Teaser Block -->")) exit
	if(index(s0,"<!-- Begin Teaser Block -->")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"Sorry but your query produced no results.")) {
		make_link("www.linuxinsider.com"); desc=title=cut1(s0); print2(3)
	}
	else
	if((ix1=index(s0,"href")) && (! index(s0,"images/en-more.gif"))) {
		print2(3); get_link()
		if(substr(link,1,5) == "more/") title=""
		else { make_link("www.linuxinsider.com"); title=cut1(s1) }
	} else desc=desc " " deb(cut1(s0))
}
END { if(length(title)) print2(3) }
@
# sharkyextreme
cat > $AWK92 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Looking For Previous Hardware")) exit
	if(index(s0,"<td valign=top width=470>")) { title=""; started=1 }
	if(! started) next
	if(index(s0,"color=\"#ffffff")) {
		print1(); title="<B>" substr(cut1(s0),1,47) "</B>"
		link=desc=""; print1()
	}
	else
	if(index(s0," size=4>") && (ix1=index(s0,"href"))) {
		print1()
		get_link2(); make_link("www.sharkyextreme.com");
		if(substr(s1,1,1) != ">") { ix1=index(s1,">"); s1=substr(s1,ix1+1) }
		else s1=substr(s1,2)
		ix1=index(s1,"</a>"); title=cut1(substr(s1,1,ix1-1))
	}
	else desc=desc " " deb(cut1(s0))
}
function print1() {
	gsub("&nbsp;"," ",title); gsub("&#039;","'",title); desc=deb(desc); print2(3)
}
END { print1() }
@
# ecommercetimes
cat > $AWK93 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"More Special Reports...</B>")) exit
	if(index(\$0,"Begin Special Reports")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"<li>")) title=deb(cut1(s0)); else
	if(ix1=index(s0,"--Next Story--")) print2(3); else
	if(ix1=index(s0,"href")) get_link(); else
	desc=desc " " deb(cut1(s0))
}
@
# linuxnews
cat > $AWK94 <<@
BEGIN { title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- begin footer.inc.php -->")) exit
	if(index(s0,"<!SUMMARY START newsblackbox>")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"[...]")) { gsub("read more -- comment","",desc); print2(3) }
	else if(index(s0,"class=\"title") && (ix1=index(s0,"href"))) link_title2()
	else desc=desc " " cut1(s0)
}
@
# newsnow
cat > $AWK95 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,";Earlier Today")) exit
	if(started && index(\$0,"</BLOCKQUOTE>")) exit
	if(index(\$0,";Information Technology")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"</UL>")) print1(); else
	if(ix1=index(s0,"HREF")) {
		print1(); get_link(); ix2=index(s1,">"); title=substr(s1,ix2+1)
	} else title=title " " s0
}
function print1() {
	gsub("&nbsp;"," ",title); title=deb(cut1(title)); desc=title
	if(length(title) && length(link)) print2(3)
}
END { if(length(title)) print1() }
@
# linhardware
cat > $AWK96 <<@
{
	s0=\$0
	if((! length(s0)) || index(s0,"<id>") || index(s0,"<category>") || \
	   index(s0,"<lhddatafeed>") || index(s0,"</lhddatafeed>")) next
	if(ix1=index(s0,"<newsitem>")) title=link=desc=""; else
	if(ix1=index(s0,"<title>"))        title  =got(7); else
	if(ix1=index(s0,"<link>"))         link   =got(6); else
	if(ix1=index(s0,"<source>"))       source =got(8); else
	if(ix1=index(s0,"<summary>"))      summary=got(9); else
	if(ix1=index(s0,"<date>"))         date   =got(6); else
	if(ix1=index(s0,"<description>"))  des    =substr(s0,ix1+13); else
	if(ix1=index(s0,"</description>")) des    =des " " substr(s0,1,ix1-1); else
	if(ix1=index(s0,"</newsitem>")) {
		gsub("&quot;","\"",title)
		gsub("&lt;","<",des); gsub("&gt;",">",des); des=deb(cut1(des))
		desc=date " (" source ") " summary " " des; print2(3)
	} else des=des " " s0
}
function got(pos,str) {
	s1=substr(s0,ix1+pos); ix1=index(s1,"<"); str=substr(s1,1,ix1-1); return str
}
@
# linuxdev
cat > $AWK97 <<@
BEGIN { title=link=""; started=0; type=1 }
{
	if(started && index(\$0,"<!-- CONTENT ENDS   HERE -->")) exit
	if(index(\$0,"<!-- CONTENT STARTS HERE -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if((ix1=index(s0,"href")) && index(s0,"Complete ")) {
		get_link(); make_link("www.linuxdev.net")
		gsub("&nbsp;"," ",title); print2(3); type=1
	}
	else if(index(s0," class=\"newsbody")) type=2
	else if(type == 1) { title=title " " deb(cut1(s0)) }
	else if(type == 2) desc=desc " " deb(cut1(s0))
}
@
# linuxmonth
cat > $AWK98 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"</body>")) exit
	if(index(\$0,"I s s u e 2 &nbsp;&nbsp;A r t i c l e s</h2>")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(substr(s0,1,8) == "<a href=" && (! length(title))) {
		ix1=index(s0,"href"); link_title(); make_link("www.linuxmonth.com")
	}
	else if(index(s0,"Read More")) print2(3)
	else desc=desc " " deb(cut1(s0))
}
@
# portalux
cat > $AWK99 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(ix1=index(s0,"href=\"go")) {
		link_title(); make_link("www.portalux.com")
		s1=substr(s1,ix2)
		if(ix1=index(s1,"bgcolor=")) {
			s1=substr(s1,ix1+18); ix1=index(s1,"<"); title=substr(s1,1,ix1-1) ": " title
		}
		print2(2)
	}
}
@
# redhat
cat > $AWK100 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Get on-line help")) exit
	if(index(s0,"<B>Quick Help</B>")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF")) { link_title2(); make_link("www.redhat.com"); print2(2) }
}
@
# xmlhack
cat > $AWK101 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if((ix1=index(s0,"href")) && index(s0,"Read more")) {
		get_link(); make_link("xmlhack.com"); print2(3)
	}
	else
	if((ix1=index(s0,"DIV CLASS=\"hd"))  || (ix1=index(s0,"div class=\"hd"))) {
		s1=substr(s0,ix1+15); ix2=index(s1,"<"); title=substr(s1,1,ix2-1); desc=""
	}
	else desc=desc " " deb(cut1(s0))
}
@
# perl
cat > $AWK102 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"</TABLE>")) exit
	if(index(\$0,"<h2>CGI</h2>")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"<li><a href=")) {
		print2(3)
		s1=substr(s0,ix1+12); ix2=index(s1,">"); link=substr(s1,1,ix2-1)
		s1=substr(s1,ix2+1); title=cut1(s1)
	}
	else desc=desc " " deb(cut1(s0))
}
END { if(length(title)) print2(3) }
@
# webcomics
cat > $AWK103 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TD>")) exit
	if(index(s0,"Daily WebComics")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		get_link3(); title=s1; gsub("</A>"," ",title); title=cut1(title)
		make_link("www.webcomics.com"); print2(2)
	}
}
@
# nospoon
cat > $AWK104 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"<b>Edito</b>")) exit
	if(index(\$0,"<!-- START: Body -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(index(s0,"images/layout/slc.gif")) title=cut1(s0)
	else
	if((ix1=index(s0,"href")) && (index(s0," commentaires</I>") || index(s0,"<I>Commenter"))) {
		get_link(); make_link("www.nospoon.org"); print2(3); 
	}
	else desc=desc " " deb(cut1(s0))
}
@
# efront
cat > $AWK105 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- RECENT BETAS ENDS -->")) exit
	if(index(s0,"<!-- RECENT BETAS STARTS -->")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"Last  <a href")); else
	if(index(s0,"More Information")); else
	if(ix1=index(s0,"href")) { print2(3); link_title5("</a>"); desc=cut1(s1) }
	else desc=desc " " deb(cut1(s0))
}
END { if(length(title)) print2(3) }
@
# mklinux
cat > $AWK106 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"</ul>")) exit
	if(index(\$0,"<b>Headlines")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"HREF")) {
		get_link(); make_link("mklinux.org/info")
		s1=substr(s1,13); ix1=index(s1,"<"); title=substr(s1,1,ix1-1); print2(2); 
	}
}
@
# amdzone
cat > $AWK107 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(ix1=index(s0,"face=arial><b>No news for today")) {
		title=desc=cut1(s0); link=""; print2(3)
	}
	else
	if(ix1=index(s0,"<font size=2 ")) desc=deb(cut1(s0))
	else
	if(ix1=index(s0,"<TD height=23>")) {
		print2(3); title=deb(cut1(s0)); make_link("www.amdzone.com")
	}
}
END { if(length(title)) print2(3) }
@
# gnu
cat > $AWK108 <<@
BEGIN { title=link=""; started=skip=head=0 }
{
	s0=\$0
	if(started && index(s0,"Return to ")) exit
	if(index(s0,"software.html#TOCDescriptionsOfGNUSoftware")) {
		head=1; hstr=s0; title=""; started=1; next
	}
	if(! started) next
	if(substr(s0,1,4) == " -->") skip=0;
	else
	if(substr(s0,1,5) == "<!---") skip=1;
	else
	if(skip) next
	else
	if(index(s0,"</H4>")) {
		hstr=hstr " " s0; hstr=deb(cut1(hstr))
		if(index(hstr,"Descriptions of")) {
			title="<B>" substr(hstr,17,33) "</B>"; desc=""; link=""; print1()
		}
		head=0
	}
	else
	if(index(s0,"<H4>")) { print1(); head=1; hstr=s0; }
	else
	if(head) hstr=hstr " " s0;
	else
	if((index(toupper(s0),"<LI>")) && (ix1=index(toupper(s0),"HREF"))) {
		print1(); link_title2(); desc=substr(s1,ix2); make_link("www.gnu.org")
	}
	else desc=desc " " s0
}
function print1() { desc=deb(cut1(desc)); print2(3) }
END { if(length(title)) print1() }
@
# screenshots
cat > $AWK109 <<@
BEGIN { title=link=""; started=0 }
{
	if(started && index(\$0,"i/blackpixel.gif")) exit
	if(index(\$0,"i/latestshots.gif")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	while(ix1=index(s0,"HREF")) {
		link_title(); make_link("www.screenshots.net"); print2(2); s0=substr(s1,ix2)
	}
}
@
# isonews
cat > $AWK110 <<@
BEGIN { title=link=""; type=started=0 }
{
	s0=\$0
	if(started && index(s0,"all content ")) exit
	if(index(s0,"news.gif")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"color=\"#990000")) { print1(); type=1 }
	else
	if(type == 1 && (ix1=index(s0,"</b>"))) {
		title=deb(cut1(substr(s0,1,ix1-1))); type=2
	}
	else
	if(type == 2) desc=desc " " deb(cut1(s0))
}
function print1() {
	desc=deb(cut1(desc)); link="news.php3"; make_link("www.isonews.com"); print2(3)
}
END { if(length(title)) print1() }
@
# digi
cat > $AWK111 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(index(s0,"bgcolor=\"#ccffcc") && (ix1=index(s0,"href"))) {
		get_link(); gsub("</p>"," ",s0); title=cut1(s0)
		make_link("www.digi.no"); print2(2)
	}
}
@
# vg
cat > $AWK112 <<@
BEGIN { title=link=""; type=started=0 }
{
	if(started && index(\$0,"<!-- SLUTT FRONTBLOKK -->")) exit
	if(index(\$0,"<!-- START FRONTBLOKK -->")) { title=""; started=1; next }
	if(! started) next
	s0=\$0
	if(ix1=index(s0,"/grafikk/mal/front")) { title=link=""; type=1 }
	else
	if(type == 2 && (ix1=index(s0,"HREF"))) {
		get_link(); desc=deb(cut1(desc))
		if("$AWK_NAME" == "mawk") {
			gsub("</FONT>","",desc); gsub("</font>","",desc)
		}
		else {
			gsub("/FONT>","",desc);  gsub("/font>","",desc)
		}
		print2(3)
	}
	else
	if(type == 1 && (ix1=index(s0,"<b>"))) {
		s1=substr(s0,ix1+3); ix1=index(s1,"/b>"); title=cut1(substr(s1,1,ix1-2))
		desc=substr(s1,ix1+3); link=""; type=2
	}
	else
	if(type == 2) desc=desc " " s0
}
@
# dagbladet
cat > $AWK113 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	while((ix1=index(s0,"<b>")) && (index(s0,"HREF=") || index(s0,"href="))) {
		s1=substr(s0,ix1+3); ix1=index(s1,"/b>");   title=cut1(substr(s1,1,ix1-2))
		s1=substr(s1,ix1+3); ix1=index(s1,"HREF="); if(! ix1) ix1=index(s1,"href=")
		desc=deb(cut1(substr(s1,1,ix1-3)))
		s1=substr(s1,ix1+6); ix1=index(s1,"\"");    link=substr(s1,1,ix1-1)
		if(length(link)) print2(3); s0=substr(s1,ix1+1)
	}
}
@
# bizit
cat > $AWK114 <<@
BEGIN { title=link=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!--/-->")) exit
	if(ix1=index(s0,"<TITLE>Ĥޤ</TITLE>")) {
		title=desc=cut1(substr(s0,ix1+7,16)); link=""; print1(); next
	}
	if(index(s0,"<!--ƥĥơ֥-->")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"<b>")) title=deb(cut1(s0)); else
	if(index(s0,"<!---->")) link=desc=""; else
	if(ix1=index(s0,"href")) { get_link(); make_link("bizit.nikkeibp.co.jp") } else
	if(index(s0,"<!--/-->")) print1(); else
	desc=desc " " s0
}
function print1() {
	desc=deb(cut1(desc)); print2(3)
}
@
# xemacs
cat > $AWK115 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- /content cell -->")) exit
	if(index(s0,"<h1>XEmacs Community News</h1>")) { title=""; started=1; next }
	if(! started) next
	if(substr(s0,1,6) == "<p><b>") {
		print1(); if(ix1=index(s0,"</b>")) title=cut1(substr(s0,ix1+6))
		desc=cut1(s0); make_link("www.xemacs.org")
	}
	else { title=title " " cut1(s0); desc=desc " " cut1(s0) }
}
function print1() { title=deb(title); print2(3) }
END { if(length(title)) print1() }
@
# sabah
cat > $AWK116 <<@
BEGIN { title=link=""; type=started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- GARILDI: -->")) exit
	if(index(s0,"<!-- GARILDI:")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		print1(); get_link(); make_link("www.sabah.com.tr/w"); type=1
	}
	else
	if(type == 1) {
		title=title " " s0; s8=deb(cut1(title))
		if(index(toupper(s0),"/B>") && length(s8)) type=2
	}
	else
	if(type == 2) desc=desc " " s0
}
function print1() {
	title=deb(cut1(title)); desc=deb(cut1(desc))
	if("$AWK_NAME" == "mawk") {
		gsub("<BR>","",title);   gsub("<br>","",title)
		gsub("</B>","",desc);    gsub("</b>","",desc)
		gsub("</FONT>","",desc); gsub("</font>","",desc)
	}
	else {
		gsub("BR>","",title);   gsub("br>","",title)
		gsub("/B>","",desc);    gsub("/b>","",desc)
		gsub("/FONT>","",desc); gsub("/font>","",desc)
	}
	if(length(title) && length(link)) print2(3); else title=link=desc=""
}
END { print1() }
@
# laser5
cat > $AWK117 <<@
BEGIN { title=link=""; type=started=0 }
{
	s0=\$0
	if(started && index(s0,"This page is Japanese only")) exit
	if(index(s0,"<HTML>")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		print1(); get_link(); make_link("www.laser5.co.jp"); type=1
		if(ix1=index(s1,"</a>")) { title=bdeb(deb(substr(s1,1,ix1-1))); type=0 }
		else title=bdeb(deb(s1))
	}
	else
	if(type == 1) {
		if(ix1=index(s0,"</a>")) { title=title " " bdeb(deb(substr(s0,1,ix1-1))); type=0 }
		else title=title " " bdeb(deb(s0))
	}
}
function bdeb(str,i) {
	for(i=length(str);i>0;i--)
		if(substr(str,i,1) != "\r" && substr(str,i,1) != "\t" && substr(str,i,1) != " ") {
			return substr(str,1,i)
		}
	return "";
}
function print1() {
	title=bdeb(deb(cut1(title)))
	if(length(title) && length(link)) print2(2); else title=link=""
}
END { print1() }
@
# ninemsn
cat > $AWK118 <<@
BEGIN { head=title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"/images/headlines.gif")) { title=""; started=1; next }
	if(! started) next
	while(ix1=index(s0,"HREF")) {
		link_title2()
		if(ix5=index(substr(link,2),"/")) {
			head1=substr(link,2,ix5-1)
			if(head1 != head) {
				savetitle=title; savelink=link
				title="<B> " head1 "</B>"; link=""; print2(2)
				title=savetitle; link=savelink; head=head1
			}
		}
		make_link("news.ninemsn.com.au"); print2(2); s0=s1
	}
	if(length(link)) { title=deb(cut1(s0)); print2(2) }
}
@
# abc
cat > $AWK119 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!--end insert of copy for top stories-->")) exit
	if(index(s0,"<!-- start insert of main story copy -->")) { title=""; started=1; next }
	if(! started) next
	if((ix1=index(s0,"href")) || (ix1=index(s0,"HREF"))) {
		get_link(); make_link("www.abc.net.au")
		ix1=index(s1,"</B>"); title=cut1(substr(s1,1,ix1-1)); s1=cut1(substr(s1,ix1+4))
		ix1=index(s1,"[FULL STORY]"); desc=cut1(substr(s1,1,ix1-1)); print2(3)
	}
}
@
# asThemes
cat > $AWK120 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"s h o t s</font>")) exit
	if(index(s0,"t h e m e s</font>")) { title=link=""; started=1; next }
	if(! started) next
	if(index(s0,">[</font>") || index(s0,">]</font>")) next
	if( (ix1=index(s0,"href=")) && (ix5=index(s0,"img src="))) {
		print1(); get_link(); get_scr()
	}
	else if(ix1=index(s0,">as</a>")) title=title " " substr(s0,1,ix1)
	else title=title " " s0
}
function print1() {
	title=cut1(title); if(length(link)) print2(4)
}
END { print1() }
@
# sawmillThemes
cat > $AWK121 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"feedback</font>")) exit
	if(index(s0,"new&nbsp;&nbsp;themes")) {
		title="<B>" cut1(s0) "</B>"; print1(); started=1; next
	}
	if(! started) next
	if((ix5=index(s0,"img src=")) && index(s0,"_small.jpg")) {
		print1(); get_scr()
	}
	else if(ix1=index(s0,"top&nbsp;&nbsp;5</font>")) {
		print1(); title="<B>" cut1(s0) "</B>"; print1()
	}
	else if(ix1=index(s0,"href=\"/themes.phtml")) {
		link_title(); make_link("sawmill.themes.org"); print1()
	}
	else if(ix1=index(s0,"href=\"http://sawmill.themes.org/")) {
		link_title(); make_link("sawmill.themes.org")
	}
	else title=title " " cut1(s0)
}
function print1() { if(length(deb(title))) print2(4) }
END { print1() }
@
# kdeThemes
cat > $AWK122 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,">ad</font>")) exit
	if(index(s0,"new themes</font>")) {
		title="<B>" cut1(s0) "</B>"; print1(); started=1; next
	}
	if(! started) next
	if(ix1=index(s0,"top 5</font>")) {
		print1(); title="<B>" cut1(s0) "</B>"; print1()
	}
	else if(ix1=index(s0,"href=\"/themes.phtml")) {
		link_title(); make_link("kde.themes.org"); print1()
	}
	else if(ix1=index(s0,"href=\"http://kde.themes.org/")) {
		print1(); link_title(); make_link("kde.themes.org")
		if((ix5=index(s0,"img src=")) && index(s0,"_small.jpg")) get_scr()
	}
	else title=title " " cut1(s0)
}
function print1() { if(length(deb(title))) print2(4) }
END { print1() }
@
# bizit special
cat > $AWK123 <<@
{
	if((ix1=index(\$0,"<frame src=\"")) && index(\$0,"name=\"item")) {
		s1=substr(\$0,13); ix1=index(s1,"\"")
		printf("%s","bizit.nikkeibp.co.jp/it/fresh/news/" substr(s1,1,ix1-1))
	}
}
@
# ascii
cat > $AWK124 <<@
BEGIN { title=link=scr=desc=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"images/1pixel.gif")) exit
	if(index(s0,"Linux magazineХåʥСΤ")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"img src=\"../imgs/linuxmag")) {
		print1()
		s1=substr(s0,ix1+9); ix2=index(s1,"\""); scr=substr(s1,1,ix2-1)
		 make_scr("www.ascii.co.jp/linuxmag/backnumber")
		make_link("www.ascii.co.jp/linuxmag/backnumber")
		if(ix1=index(s0,"alt=\"")) {
			s1=substr(s0,ix1+5); ix2=index(s1,"\""); title=substr(s1,1,ix2-1)
		}
	}
	else desc=desc " " s0
}
function print1() {
	desc=deb(cut1(desc))
	if(length(title) && length(link)) print2(5); else title=link=scr=desc=""
}
END { print1() }
@
# spaceviews
cat > $AWK125 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,">Recent News:")) exit
	if(index(s0,">top news<")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF")) {
		link_title(); desc=deb(cut1(substr(s1,ix2))); gsub("&#160;","",desc)
		desc=deb(desc); print2(3)
	}
}
@
# space
cat > $AWK126 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</table>")) exit
	if(index(s0,"/sa_top_stories_subban.gif")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) { link_title2(); make_link("www.space.com"); print2(2) }
}
@
# idgLinux
cat > $AWK127 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"CLASS=\"liTitle")) { title=""; started=1; next }
	if(index(s0,"<TITLE>We are undergoing maintenance</TITLE>")) {
		title=cut1(s0); print2(3)
	}
	if(! started) next
	if(ix1=index(s0,"HREF")) { print2(3); link_title2(); make_link("www.idg.net") }
	else desc=desc " " deb(cut1(s0))
}
END { if(length(title)) print2(3) }
@
# security-informer
cat > $AWK128 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"<B>Top E-Security News")) { title=""; started=1; next }
	if(index(s0,"<TITLE>We are undergoing maintenance</TITLE>")) {
		title=cut1(s0); print2(3)
	}
	if(! started) next
	if(ix1=index(s0,"HREF")) { print2(3); link_title5("</A>") }
	else desc=desc " " cut1(s0)
}
END { if(length(title)) print2(3) }
@
# securitysearch
cat > $AWK129 <<@
BEGIN { title=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</table>")) exit
	if(index(s0,"<b>Todays Headlines</b>")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF=")) { print1(); link_title(); desc=substr(s1,ix2) }
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); print2(3) }
END { print1() }
@
# vim
cat > $AWK130 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</pre>")) exit
	if(index(s0,"<h1>NEWSFLASH</h1>")) { title=""; started=1; next }
	if(! started) next
	if(substr(s0,1,1) >= "0" && substr(s0,1,1) <= "9") {
		print1(); title=cut1(s0); make_link("www.vim.org")
	}
	else desc=desc " " s0
}
function print1() { desc=deb(cut1(desc)); print2(3) }
END { if(length(title)) print1() }
@
# 15secondsHp
cat > $AWK131 <<@
BEGIN {
	title=link=""; started=0
	split("Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec",months," ")
}
{
	s0=\$0
	if(ix1=index(s0,"<!-- /AdSpace -->")) { title=""; started=1; s0=substr(s0,ix1) }
	if(! started) next
	if(index(s0,"HREF")) {
		while(ix1=index(s0,"HREF")) {
			desc=desc " " cut1(substr(s0,1,ix1-4))
			print1(); link_title5("</A>"); make_link("www.15seconds.com"); s0=s1
		}  desc=desc " " cut1(s0)
	} else desc=desc " " cut1(s0)
}
function print1() {
	if(title == "Archive of Previous Articles") exit
	if(title == "[Read This Article]" || title == "[Top]") return
	if(! length(deb(title))) return
	mm=substr(title,1,3); m1=sprintf("%02d",month1()); ix7=index(title,",")
	dd=substr(title,5,ix7-5); d0=(length(dd) == 1) ? "0" : ""
	title=m1 "/" d0 dd " " substr(title,ix7+8); print2(3)
}
function month1() { for(i=1;i<=12;i++) if(months[i] == mm) return i }
END { print1() }
@
# 15seconds
cat > $AWK132 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- BEGIN WEB RING")) exit
	if(ix1=index(s0,"<!-- /AdSpace -->")) { title=""; started=1; s0=substr(s0,ix1) }
	if(! started) next
	while(ix1=index(s0,"HREF")) {
		print2(2); link_title5("</A>"); make_link("www.15seconds.com/howto"); s0=s1
	}
}
END { print2(2) }
@
# softseek
cat > $AWK133 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(index(s0,"<B>top 10 downloads</B>")) {
		title="<B> top 10 downloads</B>"; print1(); started=1; next
	} # no end key
	if(! started) next
	if(index(s0,"<B>in the spotlight</B>")) {
		print1(); title="<B> in the spotlight</B>"; print1()
	} # no else
	if(ix1=index(s0,"HREF")) {
		while(ix1=index(s0,"HREF")) {
			print1(); get_link3(); make_link("www.softseek.com")
			ix2=index(s1,"</A>"); title=cut1(substr(s1,1,ix2-1))
			if(substr(title,1,11) == "... top 10 ") title=""
			s0=substr(s1,ix2)
		}
	}
	else desc=desc " " s0
}
function print1() { desc=deb(cut1(desc)); print2(3) }
END { if(length(title)) print1() }
@
# linuxguruz
cat > $AWK134 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</TABLE>")) exit
	if(index(s0,"<A NAME=\"Q\">")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF=")) {
		link_title(); desc=title; make_link("www.linuxguruz.org/linuxfaq"); print2(3)
	}
}
@
# linuxguruzTut
cat > $AWK135 <<@
BEGIN { title=link=""; kind=1; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!--UdmComment-->")) exit
	if(index(s0,"images/lrnd.gif")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"HREF")) {
		get_link(); make_link("www.linuxguruz.org")
		title=deb(title); print2(3); kind=1
	}
	else if((ix1=index(s0,"size=\"2")) || (ix1=index(s0,"size=2"))) {
		title=title " " cut1(s0); kind=2
	}
	else if(ix1=index(s0,"SIZE=\"4")) kind=3;
	else if(kind == 2) title=title " " cut1(s0);
	else if(kind == 3) desc=desc " " cut1(s0)
}
@
# hollywoodbitchslap
cat > $AWK136 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,">SEARCH</font>")) exit
	if(index(s0,"TOP 5<br>")) {
		gsub("<br>"," ",s0); title="<B>" cut1(s0) "</B>"; print2(2); started=1; next
	}
	if(! started) next
	if(index(s0,"BOTTOM 5<br>")) {
		gsub("<br>"," ",s0); title="<B>" cut1(s0) "</B>"; print2(2)
	}
	else
	if(index(s0,"HREF=") && (ix6=index(s0,"alt="))) {
		s1=substr(s0,ix6+5); ix7=index(s1,"\""); title=title " (" substr(s1,1,ix7-1) ")"
		print2(2)
	}
	else
	if(ix1=index(s0,"HREF=")) { link_title(); make_link("hollywoodbitchslap.com") }
}
@
# vector
cat > $AWK137 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!--This Week End")) exit
	if(index(s0,"好եȥӥ塼</STRONG>")) {
		title=cut1(s0); gsub("Last Updated","",title)
		title="<B>" title "</B>"; print1(); started=1; next
	}
	if(! started) next
	if(ix1=index(s0,"HREF")) {
		print1(); link_title(); make_link("www.vector.co.jp/magazine/softnews")
		desc=s0
	}
	else desc=desc " " s0
}
function print1() { desc=cut1(desc); print2(3) }
END { if(length(title)) print1() }
@
# stormix
cat > $AWK138 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"</table>")) exit
	if(index(s0,"subhead\">Stormix News")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) {
		link_title(); make_link("www.stormix.com"); title=title2 " " title
	}
	else
	if(ix1=index(s0,"color=\"#333399")) { print1(); title2=substr(cut1(s0),1,5) }
	else desc=desc " " cut1(s0)
}
function print1() { gsub("&nbsp;"," ",desc); desc=deb(desc); print2(3) }
END { if(length(title)) print1() }
@
# bestlinux
cat > $AWK139 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"Older Best Linux Headlines")) exit
	if(index(s0,"<b>Latest Best Linux")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"<li>")) {
		if(ix1=index(s0,"href")) get_link()
		desc=cut1(s0); title=substr(desc,6); make_link("bestlinux.net"); print2(3)
	}
}
@
# corel
cat > $AWK140 <<@
BEGIN { title=link=""; started=0 }
{
	s0=\$0
	if(started && index(s0,"<!--End Daily News Feed Here -->")) exit
	if(index(s0,"<!--Start Daily News Feed Here! -->")) { title=""; started=1; next }
	if(! started) next
	if(ix1=index(s0,"href")) { print1(); get_link() } else desc=s0
}
function print1() {
	title=(ix5=index(desc,"</a>")) ? substr(desc,1,ix5-1) : desc
	title=cut1(title); gsub("<br>"," ",desc); desc=cut1(desc); print2(3)
}
END { if(length(title)) print1() }
@
# tagesschau
cat > $AWK141 <<@
BEGIN { title=link=""; type=started=0 }
{
	s0=\$0
	if(started && index(s0,"<!-- ENDE DER MELDUNGEN -->")) exit
	if(index(s0,"<!-- meldungen ueberschrift -->")) { title=""; started=1; next }
	if(! started) next
	if(index(s0,"<!-- /meldungen link volltext/video -->")) { print2(5); type=0 } else
	if(index(s0,"<!-- meldungen text -->")) type=3; else
	if(index(s0,"<!-- meldungen link volltext/video -->")) type=4; else
	if(index(s0,"<!-- MELDUNG")) type=1; else
	if((ix1=index(s0,"href")) && type == 4 && index(s0,".ram")) {
		s1=substr(s0,ix1+6); ix2=index(s1,"\""); scr=substr(s1,1,ix2-1)
		make_scr("www.tagesschau.de")
	} else
	if((ix1=index(s0,"href")) && type == 1) {
		get_link2(); make_link("www.tagesschau.de"); type=2
	} else
	if(type == 2) title=title " " cut1(s0); else
	if(type == 3) desc=desc " " cut1(s0)
}
@
# New-4
cat > $PERL1 <<@
use IO::Socket; \$_ = \$ARGV[0]; /([a-zA-Z0-9.-]+)\/(.*)/;
\$host     = \$1 eq "" ? \$_ : \$1; \$document = \$1 eq "" ? "/" : "/\$2";
\$EOL = "\015\012"; \$BLANK = \$EOL x 2;
eval {
	local \$SIG{ALRM} = sub { alarm 0; die "recv timeout on \$host in perl\n" };
	alarm $RECV_TIMEOUT; 
	\$remote=IO::Socket::INET->new(Proto =>"tcp",PeerAddr =>\$host,PeerPort=>"http(80)");
	unless (\$remote) { die "connect timeout to http daemon on \$host in perl" }
	\$remote->autoflush(1); print \$remote "GET \$document" . \$BLANK;
	while ( <\$remote> ) { print }; close \$remote;
	alarm 0;
};
if(\$@) { die "@@ recv timeout on \$host in perl @@\n" }
@
cat > $LYNX2 <<@
eval {
	local \$SIG{ALRM} = sub { alarm 0; die "recv timeout on \$ARGV[0] in lynx 1\n" };
	alarm $RECV_TIMEOUT; 
	system "$LYNX_CMD http://\$ARGV[0] > \$ARGV[1] 2> /dev/null";
	alarm 0;
};
if(\$@) { die "@@ recv timeout on \$ARGV[0] in lynx 1 @@\n" }
@
cat > $LYNX3 <<@
eval {
	local \$SIG{ALRM} = sub { alarm 0; die "recv timeout on \$ARGV[0] in lynx 2\n" };
	alarm $RECV_TIMEOUT; 
	system "$LYNX_CMD -source http://\$ARGV[0] > \$ARGV[1] 2> /dev/null";
	alarm 0;
};
if(\$@) { die "@@ recv timeout on \$ARGV[0] in lynx 2 @@\n" }
@
if [ "$DEBUG" = "3" ]; then > $BUG1; fi
if [ "$FILE_ONLY" = "YES" ]; then
	> $HTML_NAME
else
	$AWK_NAME -f $AWK38 /dev/null > $HTML_NAME
	cat $SCRIPT7 >> $HTML_NAME
fi
echo "1" > $NAM4
$AWK_NAME -f $AWK6 $SITE_TABLE > $SITE_TABLE1
for URL1 in `cat $SITE_TABLE1`;
do
  RETRYS=1
  while [ $RETRYS -le $MAX_RETRYS ];
  do
	> $NAM2
	WWW_NAME=`echo $URL1|$AWK_NAME -f $AWK2`
	if [ "$WWW_NAME" = "www.forbes.com" ]; then URL1=`echo $URL1|sed "s/YYYY/$YYYY/"`; fi
	if [ "$DEBUG" != "0" -o "$DISPLAY_ACCESS" = "YES" ]; then
		echo "$RETRYS/$MAX_RETRYS: $URL1 start recv"
	fi
	case "$URL1" in
	www.idg.net/english/channel_content/channel_linux_news.html) SITE_NAME=idgLinux ;;
	www.gnome.org/applist/listrecent.php3?entrylimit=50) SITE_NAME=gnomeSoft ;;
	www.wired.com/news_drop/palmpilot/topstories) SITE_NAME=wiredPalmpilot ;;
	www.linux.com/mrn/jobs/latest_jobs.rss)       SITE_NAME=linuxComJobs ;;
	www.linux.com/mrn/linuxgram_all.rss)          SITE_NAME=linuxComGramA ;;
	www.linux.com/mrn/linuxgram_newsflash.rss)    SITE_NAME=linuxComGramF ;;
	www.linux.com/mrn/linuxgram_newsletter.rss)   SITE_NAME=linuxComGramL ;;
	www.wired.com/news/technology)                SITE_NAME=wiredTechnology ;;
	www.linux.org/news/bin/news)                  SITE_NAME=linuxOrgNews ;;
	www.linux.org/books/featured.html)            SITE_NAME=linuxOrgBook ;;
	www.debian.org/News/index.ja.html)			  SITE_NAME=debianJp ;;
	www.15seconds.com/Issue/default.htm)		  SITE_NAME=15secondsHp ;;
	news.gnome.org/gnome-news/)                   SITE_NAME=gnomeNews ;;
	linux.com/getlinux/)                          SITE_NAME=linuxComDownload ;;
	www.linuxguruz.org/z.php?id=2)                SITE_NAME=linuxguruzTut ;;
	209.153.240.73)                				  SITE_NAME=stormix ;;
	*)  case "$WWW_NAME" in
		www.linux.com)			SITE_NAME=linuxComNews ;;
		linux.com)				SITE_NAME=linuxComTuneup ;;
		www.linux.de)			SITE_NAME=linuxDe ;;
		www.linux.org.uk)		SITE_NAME=linuxUk ;;
		news.excite.com)		SITE_NAME=news-excite ;;
		realguide.real.com)		SITE_NAME=realguide ;;
		gtk.themes.org)			SITE_NAME=gtkThemes ;;
		kde.themes.org)			SITE_NAME=kdeThemes ;;
		apps.kde.com)			SITE_NAME=kdeApps ;;
		dot.kde.org)			SITE_NAME=kdeDot ;;
		as.themes.org)			SITE_NAME=asThemes ;;
		sawmill.themes.org)		SITE_NAME=sawmillThemes ;;
		e.themes.org)			SITE_NAME=eThemes ;;
		bizit.nikkeibp.co.jp)	SITE_NAME=bizit ;;
		*)						SITE_NAME=`echo $WWW_NAME|$AWK_NAME -f $AWK3` ;;
		esac ;;
	esac

	if [ "$DEBUG" = "1" ]; then > ../raw/$SITE_NAME; fi
	echo $SITE_NAME"<"`cat $NAM4` > $NAM1
	case "$DEBUG" in
	0|1)
		case "$SITE_NAME" in
		segfault|mozillazine|nikkeibp|kernelnotes|gnomeNews|cbs| \
		SolarisCentral|linuxplace|php|happypenguin)
				kill1 "perl $LYNX2 $URL1 $NAM2" &
				perl $LYNX2 $URL1 $NAM2
				if [ $? != 0 -a "$DEBUG" = "1" ]; then > $NAM2; fi
				;;
# New-5
		vector|nikkansports|wideopen|softseek|vim|xemacs| \
		kdeApps|kdeDot|enlightenment|debian|debianJp|techweb| \
		linhardware|ibiblio|linuxfr|security-informer|spaceviews| \
		insecure|ascii|eThemes|sawmillThemes|kdeThemes|asThemes| \
		ecommercetimes|gtkThemes|abc|laser5|bizit|digi|vg| \
		daemonnews|perl|xmlhack|linuxmonth|webclub| \
		anandtech|efront|linuxnews|securitysearch|kuro5hin|gamefan| \
		penguinapps|linuxdev|mozilla|music|newsbytes|linuxinsider)
				kill1 "perl $LYNX3 $URL1 $NAM2" &
				perl $LYNX3 $URL1 $NAM2
				if [ $? != 0 -a "$DEBUG" = "1" ]; then > $NAM2; fi
				if [ "$SITE_NAME" = "bizit" ]; then # get real url of bizit
					URL1=`$AWK_NAME -f $AWK123 $NAM2`
					> $NAM2
					kill1 "perl $LYNX3 $URL1 $NAM2" &
					perl $LYNX3 $URL1 $NAM2
					if [ $? != 0 -a "$DEBUG" = "1" ]; then > $NAM2; fi
				fi
				;;
		linevents)
				kill1 "$LYNX_CMD http://$URL1" &
				$LYNX_CMD http://$URL1 > $NAM2 2> /dev/null
				if [ $? != 0 -a "$DEBUG" = "1" ]; then > $NAM2; fi
				;;
		kernel)
				kill1 "finger  www.kernel.org" &
				finger @www.kernel.org > $NAM2
				if [ $? != 0 -a "$DEBUG" = "1" ]; then > $NAM2; fi
				;;
		*)		if [ "$PROXY_ONLY" = "YES" ]; then	
					if [ "$SITE_NAME" = "realguide" ]; then
						kill1 "$LYNX_CMD -source http://$URL1" &
						$LYNX_CMD -source http://$URL1 > $NAM2 2> /dev/null
					else
						kill1 "perl $LYNX3 $URL1 $NAM2" &
						perl $LYNX3 $URL1 $NAM2
					fi
				else
					kill1 "perl $PERL1 $URL1" &
					perl $PERL1 $URL1 > $NAM2
				fi
				if [ $? != 0 -a "$DEBUG" = "1" ]; then > $NAM2; fi
				;;
		esac ;;
	2)	cp ../raw/$SITE_NAME $NAM2 ;;
	3)	;;
	esac
	if [ "$DEBUG" = "1" ]; then cp $NAM2 ../raw/$SITE_NAME; fi
	if [ "$DEBUG" = "3" ]; then echo "$WWW_NAME|$SITE_NAME" >> $BUG1; fi
	export URL1; export WWW_NAME; export SITE_NAME; call_awk1 $SITE_NAME
	$AWK_NAME -f $AWK1 -f $CUT1 $NAM1 > $NAM6; LINES=`wc -l $NAM6|$AWK_NAME '{print $1}'`
	if [ $DEBUG -ge 2 -o $LINES -ne 2 -o $RETRYS -ge $MAX_RETRYS ]; then
		if [ "$DISPLAY_ACCESS" = "YES" ]; then
			echo "$RETRYS/$MAX_RETRYS: $URL1 LINE="`wc -l $NAM2|$AWK_NAME '{print $1}'`
		fi
		cat $NAM6 >> $HTML_NAME; break
	fi
	RETRYS=$[ $RETRYS + 1 ]
	if [ $MAX_RETRYS -ge 2 ]; then sleep 5; fi
  done # retry
done # all table
rm $SITE_TABLE1 $SCRIPT7 $PERL1 $LYNX2 $LYNX3
rm $NAM1  $NAM2  $NAM4  $NAM6
rm $AWK1  $AWK2  $AWK3  $AWK4  $AWK5  $AWK6  $AWK7  $AWK8  $AWK9  $AWK10
rm $AWK11 $AWK12 $AWK13 $AWK14 $AWK15 $AWK16 $AWK17 $AWK18 $AWK19 $AWK20
rm $AWK21 $AWK22 $AWK23 $AWK24 $AWK25 $AWK26 $AWK27 $AWK28 $AWK29 $AWK30
rm $AWK31 $AWK32 $AWK33 $AWK34 $AWK35 $AWK36 $AWK37 $AWK38 $AWK39 $AWK40
rm $AWK41 $AWK42 $AWK43 $AWK44 $AWK45 $AWK46 $AWK47 $AWK48 $AWK49 $AWK50
rm $AWK51 $AWK52 $AWK53 $AWK54 $AWK55 $AWK56 $AWK57 $AWK58 $AWK59 $AWK60
rm $AWK61 $AWK62 $AWK63 $AWK64 $AWK65 $AWK66 $AWK67 $AWK68 $AWK69 $AWK70
rm $AWK71 $AWK72 $AWK73 $AWK74 $AWK75 $AWK76 $AWK77 $AWK78 $AWK79 $AWK80
rm $AWK81 $AWK82 $AWK83 $AWK84 $AWK85 $AWK86 $AWK87 $AWK88 $AWK89 $AWK90
rm $AWK91 $AWK92 $AWK93 $AWK94 $AWK95 $AWK96 $AWK97 $AWK98 $AWK99
rm $AWK100 $AWK101 $AWK102 $AWK103 $AWK104 $AWK105 $AWK106 $AWK107 $AWK108
rm $AWK109 $AWK110 $AWK111 $AWK112 $AWK113 $AWK114 $AWK115 $AWK116 $AWK117
rm $AWK118 $AWK119 $AWK120 $AWK121 $AWK122 $AWK123 $AWK124 $AWK125 $AWK126
rm $AWK127 $AWK128 $AWK129 $AWK130 $AWK131 $AWK132 $AWK133 $AWK134 $AWK135
rm $AWK136 $AWK137 $AWK138 $AWK139 $AWK140 $AWK141
# New-6
case "$FILE_ONLY" in
YES) cp $HTML_NAME $DATA_NAME ;;
*)	echo "</pre></body></html>" >> $HTML_NAME
	if [ "$NEW_ONLY" = "YES" ]; then
		$AWK_NAME -f $AWK_CMP $HTML_NAME > $NAM7
		cp $HTML_NAME $OLD_FILE_NAME
		mv $NAM7 $HTML_NAME
	fi
	if [ -d ~/nsdown ]; then cd ~/nsdown; fi # to fix a download directory
	if [ "$DEBUG" != "1" -a "$DEBUG" != "3" ]; then netscape file://$HTML_NAME; fi ;;
esac
if [ "$SAVE_OUTPUT" = "NO" ]; then rm $HTML_NAME; fi
rm $AWK_CMP $CUT1
#
