#!/bin/sh

set -e

ALLFILES="*-ext/* *launch.d/*.cfg debian/README.Debian Makefile etc/dirty_etc_ok"

if [ "$1" = "undo" ]; then
    prename -v 's/hobbitgraph/graphs/'                *.d
    prename -v 's/hobbit/xymon/g'                     *.d sudoers.d/*
    sed -e 's/^#Pre-Depends:/Pre-Depends:/g'          -i debian/control
    sed -e 's/(<< 4.3.7-1~)/(>= 4.3.17-2~)/g'         -i debian/control
    sed -e 's/hobbit/xymon/g'                         -i sudoers.d/* debian/postinst *-bin/* *launch.d/*.cfg
    sed -e 's/hobbitd/xymond/g'                       -i server-ext/ircbot *launch.d/ircbot.cfg client-bin/xynagios
    sed -e 's: hobbitgraph.d : graphs.d :g'           -i Makefile
    sed -e 's:hobbit\([a-z]*\).d:xymon\1.d:g'         -i Makefile
    sed -e 's:/var/log/hobbit/:/var/log/xymon/:g'     -i $ALLFILES
    sed -e 's:/var/lib/hobbit/:/var/lib/xymon/:g'     -i $ALLFILES
    sed -e 's:/usr/lib/hobbit/:/usr/lib/xymon/:g'     -i $ALLFILES
    sed -e 's:/etc/hobbit:/etc/xymon:g'               -i $ALLFILES
    sed -e 's:sudoers.d/hobbit:sudoers.d/xymon:g'     -i $ALLFILES
    sed -e 's:HOBBITCLIENTHOME:XYMONCLIENTHOME:g'     -i $ALLFILES
    sed -e 's:BBHOME:XYMONHOME:g'                     -i server-ext/*
    sed -e 's:BBDISP:XYMSRV:g'                        -i server-ext/*
    sed -e 's:$ENV{BB}:$ENV{XYMON}:g'                 -i server-ext/*
    sed -e 's:BBSERVERHOSTNAME:XYMONSERVERHOSTNAME:g' -i server-ext/*
    sed -e 's:bbhostgrep:xymongrep:g'                 -i server-ext/*
    [ -e debian/maintscript.disabled ] && mv -v debian/maintscript.disabled debian/maintscript
else
    [ -e debian/maintscript ] && mv -v debian/maintscript debian/maintscript.disabled
    sed -e 's:xymongrep:bbhostgrep:g'                 -i server-ext/*
    sed -e 's:XYMONSERVERHOSTNAME:BBSERVERHOSTNAME:g' -i server-ext/*
    sed -e 's:XYMONHOME:BBHOME:g'                     -i server-ext/*
    sed -e 's:XYMSRV:BBDISP:g'                        -i server-ext/*
    sed -e 's:$ENV{XYMON}:$ENV{BB}:g'                 -i server-ext/*
    sed -e 's:XYMONCLIENTHOME:HOBBITCLIENTHOME:g'     -i $ALLFILES
    sed -e 's:sudoers.d/xymon:sudoers.d/hobbit:g'     -i $ALLFILES
    sed -e 's:/etc/xymon:/etc/hobbit:g'               -i $ALLFILES
    sed -e 's:/usr/lib/xymon/:/usr/lib/hobbit/:g'     -i $ALLFILES
    sed -e 's:/var/lib/xymon/:/var/lib/hobbit/:g'     -i $ALLFILES
    sed -e 's:/var/log/xymon/:/var/log/hobbit/:g'     -i $ALLFILES
    sed -e 's:xymon\([a-z]*\).d:hobbit\1.d:g'         -i Makefile
    sed -e 's: graphs.d : hobbitgraph.d :g'           -i Makefile
    sed -e 's/xymond/hobbitd/g'                       -i server-ext/ircbot *launch.d/ircbot.cfg client-bin/xynagios
    sed -e 's/xymon/hobbit/g'                         -i sudoers.d/* debian/postinst *-bin/* *launch.d/*.cfg
    sed -e 's/(>= 4.3.17-2~)/(<< 4.3.7-1~)/g'         -i debian/control
    sed -e 's/^Pre-Depends:/#Pre-Depends:/g'          -i debian/control
    prename -v 's/xymon/hobbit/g'                     *.d sudoers.d/*
    prename -v 's/graphs/hobbitgraph/'                *.d
fi

exit 0
