{-# LANGUAGE ExplicitNamespaces #-}

-----------------------------------------------------------------------------
-- |
-- Module      :  Data.Promotion.TH
-- Copyright   :  (C) 2013 Richard Eisenberg
-- License     :  BSD-style (see LICENSE)
-- Maintainer  :  Richard Eisenberg (rae@cs.brynmawr.edu)
-- Stability   :  experimental
-- Portability :  non-portable
--
-- This module contains everything you need to promote your own functions via
-- Template Haskell.
--
----------------------------------------------------------------------------

module Data.Promotion.TH (
  -- * Primary Template Haskell generation functions
  promote, promoteOnly, genDefunSymbols, genPromotions,

  -- ** Functions to generate @Eq@ instances
  promoteEqInstances, promoteEqInstance,

  -- ** Functions to generate @Ord@ instances
  promoteOrdInstances, promoteOrdInstance,

  -- ** Functions to generate @Bounded@ instances
  promoteBoundedInstances, promoteBoundedInstance,

  -- ** Functions to generate @Enum@ instances
  promoteEnumInstances, promoteEnumInstance,

  -- ** Functions to generate @Show@ instances
  promoteShowInstances, promoteShowInstance,

  -- ** defunctionalization
  TyFun, Apply, type (@@),

  -- * Auxiliary definitions
  -- | These definitions might be mentioned in code generated by Template Haskell,
  -- so they must be in scope.

  PEq(..), If, type (&&),
  POrd(..), ThenCmp, Foldl,
  PBounded(..),
  PEnum(FromEnum, ToEnum),
  PShow(..),
  ShowString, ShowParen, ShowSpace, ShowChar, ShowCommaSpace,
  (:.),
  Proxy(..),

  Error, ErrorSym0, ErrorSym1,
  Undefined, UndefinedSym0,
  TrueSym0, FalseSym0,
  type (==@#@$), type (==@#@$$), type (==@#@$$$),
  type (>@#@$), type (>@#@$$), type (>@#@$$$),
  LTSym0, EQSym0, GTSym0,
  Tuple0Sym0,
  Tuple2Sym0, Tuple2Sym1, Tuple2Sym2,
  Tuple3Sym0, Tuple3Sym1, Tuple3Sym2, Tuple3Sym3,
  Tuple4Sym0, Tuple4Sym1, Tuple4Sym2, Tuple4Sym3, Tuple4Sym4,
  Tuple5Sym0, Tuple5Sym1, Tuple5Sym2, Tuple5Sym3, Tuple5Sym4, Tuple5Sym5,
  Tuple6Sym0, Tuple6Sym1, Tuple6Sym2, Tuple6Sym3, Tuple6Sym4, Tuple6Sym5, Tuple6Sym6,
  Tuple7Sym0, Tuple7Sym1, Tuple7Sym2, Tuple7Sym3, Tuple7Sym4, Tuple7Sym5, Tuple7Sym6, Tuple7Sym7,
  CompareSym0, CompareSym1, CompareSym2,
  ThenCmpSym0, ThenCmpSym1, ThenCmpSym2,
  FoldlSym0, FoldlSym1, FoldlSym2, FoldlSym3,
  MinBoundSym0, MaxBoundSym0,
  ShowsPrecSym0, ShowsPrecSym1, ShowsPrecSym2, ShowsPrecSym3,
  ShowStringSym0, ShowStringSym1, ShowStringSym2,
  ShowParenSym0, ShowParenSym1, ShowParenSym2,
  ShowSpaceSym0, ShowSpaceSym1,
  ShowCharSym0, ShowCharSym1, ShowCharSym2,
  ShowCommaSpaceSym0, ShowCommaSpaceSym1,
  type (.@#@$), type (.@#@$$), type (.@#@$$$), type (.@#@$$$$),
  (:@#@$), (:@#@$$), (:@#@$$$),

  SuppressUnusedWarnings(..)

 ) where

import Data.Singletons.Internal
import Data.Singletons.Promote
import Data.Singletons.Prelude.Base
import Data.Singletons.Prelude.Instances
import Data.Singletons.Prelude.Bool
import Data.Singletons.Prelude.Enum
import Data.Singletons.Prelude.Eq
import Data.Singletons.Prelude.Ord
import Data.Singletons.Prelude.Show
import Data.Singletons.TypeLits
import Data.Singletons.SuppressUnusedWarnings
