/*
 * static char *rcsid_client_c =
 *   "$Id: client.c,v 1.4 2002/01/15 07:32:59 mwedel Exp $";
 */
/*
    Crossfire client, a client program for the crossfire program.

    Copyright (C) 2001 Mark Wedel & Crossfire Development Team

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to crossfire-devel@real-time.com
*/

 /* Client interface main routine.
  * this file sets up a few global variables, connects to the server,
  * tells it what kind of pictures it wants, adds the client and enters
  * the main dispatch loop
  *
  * the main event loop (event_loop()) checks the tcp socket for input and
  * then polls for x events.  This should be fixed since you can just block
  * on both filedescriptors.
  *
  * The DoClient function recieves a message (an ArgList), unpacks it, and
  * in a slow for loop dispatches the command to the right function through
  * the commands table.   ArgLists are essentially like RPC things, only 
  * they don't require going through RPCgen, and it's easy to get variable
  * length lists.  They are just lists of longs, strings, characters, and 
  * byte arrays that can be converted to a machine independent format
 */


#include <client.h>
#include <external.h>
#include <errno.h>

/* actually declare the globals */

char *server=SERVER,*client_libdir=NULL,*meta_server=META_SERVER;
char *image_file="";

int port_num=EPORT, meta_port=META_PORT, want_skill_exp=0, mapx=11, mapy=11,
    want_mapx=11, want_mapy=11, want_darkness=1, fog_of_war=0;
FILE *fpin,*fpout;
int fdin, fdout, basenrofpixmaps, pending_images=0,maxfiledescriptor,
	pending_archs=0,maxfd,map1cmd=0,metaserver_on=METASERVER;
Client_Player cpl;
ClientSocket csocket;
int fast_tcp_send=1;

char *resists_name[NUM_RESISTS] = {
"armor", "magic", "fire", "elec", 
"cold", "conf", "acid", "drain",
"ghit", "pois", "slow", "para",
"t undead", "fear", "depl","death", 
"hword", "blind"};

char *skill_names[MAX_SKILL] = {
"agility", "personality", "mental", "physique", "magic", "wisdom"
};

typedef void (*CmdProc)(unsigned char *, int len);

struct CmdMapping {
  char *cmdname;
  void (*cmdproc)(unsigned char *, int );
};


struct CmdMapping commands[] = {
    /* Order of this table doesn't make a difference.  I tried to sort
     * of cluster the related stuff together.
     */
    { "map", MapCmd },
    { "map1", Map1Cmd },
    { "map_scroll", (CmdProc)map_scrollCmd },
    { "magicmap", MagicMapCmd},
    { "newmap", NewmapCmd },

    { "item", ItemCmd },
    { "item1", Item1Cmd },
    { "upditem", UpdateItemCmd },
    { "delitem", DeleteItem },
    { "delinv",	DeleteInventory },

    { "drawinfo", (CmdProc)DrawInfoCmd },
    { "stats", StatsCmd },

    { "image", ImageCmd },
    { "face", FaceCmd},
    { "face1", Face1Cmd},


    { "sound", SoundCmd},
    { "anim", AnimCmd},

    { "player", PlayerCmd },
    { "comc", CompleteCmd},

    { "addme_failed", (CmdProc)AddMeFail },
    { "addme_success", (CmdProc)AddMeSuccess },
    { "version", (CmdProc)VersionCmd },
    { "goodbye", (CmdProc)GoodbyeCmd },
    { "setup", (CmdProc)SetupCmd},

    { "query", (CmdProc)handle_query},
};

#define NCOMMANDS (sizeof(commands)/sizeof(struct CmdMapping))

void DoClient(ClientSocket *csocket)
{
    int i,len;
    unsigned char *data;

    while (1) {
	i=SockList_ReadPacket(csocket->fd, &csocket->inbuf, MAXSOCKBUF-1);
	if (i==-1) {
	    /* Need to add some better logic here */
	    /*ET: not an error.  It's EOF!  At least errno isn't valid.
	    fprintf(stderr,"Got error on read (error %d)\n", errno);
	    */
	    csocket->fd=-1;
	    return;
	}
	if (i==0) return;   /* Don't have a full packet */
	csocket->inbuf.buf[csocket->inbuf.len]='\0';
        data = (unsigned char *)strchr((char*)csocket->inbuf.buf +2, ' ');
	if (data) {
	    *data='\0';
	    data++;
	}
        len = csocket->inbuf.len - (data - csocket->inbuf.buf);
	/* Terminate the buffer */
	LOG(0,"Command:%s (%d)\n",csocket->inbuf.buf+2, len);
	for(i=0;i < NCOMMANDS;i++) {
	    if (strcmp((char*)csocket->inbuf.buf+2,commands[i].cmdname)==0) {
		    commands[i].cmdproc(data,len);
		    break;
	    }
	}
	csocket->inbuf.len=0;
	if (i == NCOMMANDS) {
	    printf("Bad command from server (%s)\n",csocket->inbuf.buf+2);
	}
    }
}

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <ctype.h>
#include <arpa/inet.h>

/* returns the fd of the connected socket, -1 on failure. */

int init_connection(char *host, int port)
{
    struct protoent *protox;
    int fd, oldbufsize, newbufsize=65535, buflen=sizeof(int);
    struct sockaddr_in insock;

    protox = getprotobyname("tcp");
    if (protox == (struct protoent  *) NULL)
    {
	fprintf(stderr, "Error getting prorobyname (tcp)\n");
	return -1;
    }
    fd = socket(PF_INET, SOCK_STREAM, protox->p_proto);
    if (fd==-1) {
	perror("init_connection:  Error on socket command.\n");
	return -1;
    }
    insock.sin_family = AF_INET;
    insock.sin_port = htons((unsigned short)port);
    if (isdigit(*host))
	insock.sin_addr.s_addr = inet_addr(host);
    else {
	struct hostent *hostbn = gethostbyname(host);
	if (hostbn == (struct hostent *) NULL)
	{
	    fprintf(stderr,"Unknown host: %s\n",host);
	    return -1;
	}
	memcpy(&insock.sin_addr, hostbn->h_addr, hostbn->h_length);
    }
    if (connect(fd,(struct sockaddr *)&insock,sizeof(insock)) == (-1))
    {
	perror("Can't connect to server");
	return -1;
    }
    if (fcntl(fd, F_SETFL, O_NDELAY)==-1) {
	fprintf(stderr,"InitConnection:  Error on fcntl.\n");
    }

#ifdef TCP_NODELAY
    /* turn off nagle algorithm */
    if (fast_tcp_send) {
	int i=1;

	if (setsockopt(fd, SOL_TCP, TCP_NODELAY, &i, sizeof(i)) == -1)
	    perror("TCP_NODELAY");
    }
#endif

    if (getsockopt(fd,SOL_SOCKET,SO_RCVBUF, (char*)&oldbufsize, &buflen)==-1)
        oldbufsize=0;

    if (oldbufsize<newbufsize) {
	if(setsockopt(fd,SOL_SOCKET,SO_RCVBUF, (char*)&newbufsize, sizeof(&newbufsize))) {
            LOG(1,"InitConnection: setsockopt unable to set output buf size to %d\n", newbufsize);
	    setsockopt(fd,SOL_SOCKET,SO_RCVBUF, (char*)&oldbufsize, sizeof(&oldbufsize));
	}
    }
    return fd;
}

/* This function negotiates/establishes the connection with the
 * server.
 */

void negotiate_connection(int sound)
{
    int cache;

    SendVersion(csocket);

    /* We need to get the version command fairly early on because
     * we need to know if the server will support a request to use
     * png images.  This isn't done the best, because if the server
     * never sends the version command, we can loop here forever.
     * However, if it doesn't send the version command, we have no idea
     * what we are dealing with.
     */
    while (csocket.cs_version==0) {
	DoClient(&csocket);
    }


    cache = display_willcache();
    if (cache) cache = CF_FACE_CACHE;

    if (csocket.sc_version<1023) {
	fprintf(stderr,"Server does not support PNG images, yet that is all this client\n");
	fprintf(stderr,"supports.  Either the server needs to be upgraded, or you need to\n");
	fprintf(stderr,"downgrade your client.\n");
	exit(1);
    }
    /* Other than cache, this doesn't do anything.  However, in the
     * future, it may be possible to select other image sets (eg, iso)
     */
    SendSetFaceMode(csocket,CF_FACE_PNG | cache);

#if 0
    if (display_usebitmaps()) 
	SendSetFaceMode(csocket,CF_FACE_BITMAP | cache); 
    else if (display_usexpm()) 
	SendSetFaceMode(csocket,CF_FACE_XPM | cache);
    else if (display_usepng()) {
	if (csocket.sc_version<1023) {
	    SendSetFaceMode(csocket,CF_FACE_XPM | cache);
	    draw_info("Server does not support PNG images.  Will use XPM instead", NDI_RED);
	}
	else SendSetFaceMode(csocket,CF_FACE_PNG | cache);
    }
#endif

    cs_print_string(csocket.fd,
		    "setup sound %d sexp %d darkness %d newmapcmd %d",
		    sound>=0, want_skill_exp, want_darkness, fog_of_war);

    mapx=11;
    mapy=11;
    if (want_mapx!=11 || want_mapy!=11)
	cs_print_string(csocket.fd,"setup mapsize %dx%d",want_mapx, want_mapy);

    SendAddMe(csocket);
}


