# $Id: courier-authlib.spec.in,v 1.5 2005/11/17 01:29:03 mrsam Exp $
#
# Copyright 1998 - 2005 Double Precision, Inc.  See COPYING for
# distribution information.

%define is_not_mandrake %(test ! -e /etc/mandrake-release && echo 1 || echo 0)

%if %is_not_mandrake
%define courier_release %(release="`rpm -q --queryformat='.%{VERSION}' redhat-release 2>/dev/null`" ; if test $? != 0 ; then release="`rpm -q --queryformat='.%{VERSION}' fedora-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; fi ; echo "$release")
%else
%define courier_release mdk
%endif

Summary: Courier authentication library.
Name: courier-authlib
Version: 0.58
Release: 1%{courier_release}
License: GPL
Group: System Environment/Daemons
URL: http://www.courier-mta.org
Source0: %{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildPreReq: libtool
BuildPreReq: openldap-devel
BuildPreReq: mysql-devel zlib-devel
BuildPreReq: postgresql-devel
BuildPreReq: gdbm-devel
BuildPreReq: pam-devel
BuildPreReq: expect
BuildPreReq: gcc-c++

Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig

%description
The Courier authentication library provides authentication services for
other Courier applications.

%package devel
Summary: Development libraries for the Courier authentication library.
Group: Development/Libraries
Requires: courier-authlib = 0:%{version}-%{release}

%description devel
This package contains the development libraries and files needed to compile
Courier packages that use this authentication library.  Install this
package in order to build the rest of the Courier packages.  After they are
built and installed this package can be removed.  Files in this package
are not needed at runtime.

%package userdb
Summary: userdb support for the Courier authentication library.
Group: System Environment/Daemons
Requires: courier-authlib = 0:%{version}-%{release}

%description userdb
This package installs the userdb support for the Courier authentication
library.  Userdb is a simple way to manage virtual mail accounts using
a GDBM-based database file.

Install this package in order to be able to authenticate with userdb.
%package ldap
Summary: LDAP support for the Courier authentication library.
Group: System Environment/Daemons
Requires: courier-authlib = 0:%{version}-%{release}

%description ldap
This package installs LDAP support for the Courier authentication library.
Install this package in order to be able to authenticate using LDAP.

%package mysql
Summary: MySQL support for the Courier authentication library.
Group: System Environment/Daemons
Requires: courier-authlib = 0:%{version}-%{release}

%description mysql
This package installs MySQL support for the Courier authentication library.
Install this package in order to be able to authenticate using MySQL.

%package pgsql
Summary: MySQL support for the Courier authentication library.
Group: System Environment/Daemons
Requires: courier-authlib = 0:%{version}-%{release}

%description pgsql
This package installs PostgreSQL support for the Courier authentication
library.
Install this package in order to be able to authenticate using PostgreSQL.

%package pipe
Summary: External authentication module that communicates via pipes.
Group: System Environment/Daemons
Requires: courier-authlib = 0:%{version}-%{release}

%description pipe
This package installs the authpipe module, which is a generic plugin
that enables authentication requests to be serviced by an external
program, then communicates through messages on stdin and stdout.

%prep
%setup -q
%configure --with-redhat

%build
%{__make} %{_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
MAKEFLAGS= %{__make} -j 1 install DESTDIR=$RPM_BUILD_ROOT
%{__rm} -f $RPM_BUILD_ROOT%{_libdir}/courier-authlib/*.a
%{__install} -m 555 sysconftool $RPM_BUILD_ROOT%{_libexecdir}/courier-authlib
%{__install} -m 555 authmigrate $RPM_BUILD_ROOT%{_libexecdir}/courier-authlib

./courierauthconfig --configfiles >configtmp
. configtmp

./authmksock $RPM_BUILD_ROOT%{_localstatedir}/spool/authdaemon/socket || exit 1
touch $RPM_BUILD_ROOT%{_localstatedir}/spool/authdaemon/pid.lock || exit 1
touch $RPM_BUILD_ROOT%{_localstatedir}/spool/authdaemon/pid || exit 1
%{__chmod} 777 $RPM_BUILD_ROOT%{_localstatedir}/spool/authdaemon/socket || exit 1

cat >configfiles.base <<EOF
%defattr(-,$mailuser,$mailgroup,-)
%{_sysconfdir}/authlib
%{_libexecdir}/courier-authlib
%dir %{_libdir}/courier-authlib
%dir %attr(750,$mailuser,$mailgroup) %{_localstatedir}/spool/authdaemon
EOF

echo "%defattr(-,$mailuser,$mailgroup,-)" >configfiles.mysql
echo "%defattr(-,$mailuser,$mailgroup,-)" >configfiles.ldap
echo "%defattr(-,$mailuser,$mailgroup,-)" >configfiles.pgsql
echo "%defattr(-,$mailuser,$mailgroup,-)" >configfiles.userdb
echo "%defattr(-,$mailuser,$mailgroup,-)" >configfiles.pipe
echo "%defattr(-,$mailuser,$mailgroup,-)" >configfiles.devel

for f in $RPM_BUILD_ROOT%{_sbindir}/*
do
	fn=`basename $f`
	case "$fn" in
	*userdb*)
		echo "%{_sbindir}/$fn" >>configfiles.userdb
		;;
	*)
		echo "%{_sbindir}/$fn" >>configfiles.base
		;;
	esac
done

for f in $RPM_BUILD_ROOT%{_libdir}/courier-authlib/*
do
	fn=`basename $f`
	case "$fn" in
	libauthpipe*)
		echo "%{_libdir}/courier-authlib/$fn" >>configfiles.pipe
		;;
	libauthldap*)
		echo "%{_libdir}/courier-authlib/$fn" >>configfiles.ldap
		;;
	libauthmysql*)
		echo "%{_libdir}/courier-authlib/$fn" >>configfiles.mysql
		;;
	libauthpgsql*)
		echo "%{_libdir}/courier-authlib/$fn" >>configfiles.pgsql
		;;
	libauthldap*)
		echo "%{_libdir}/courier-authlib/$fn" >>configfiles.ldap
		;;
	libauthuserdb*)
		echo "%{_libdir}/courier-authlib/$fn" >>configfiles.userdb
		;;
	*)
		echo "%{_libdir}/courier-authlib/$fn" >>configfiles.base
		;;
	esac
done
%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d
%{__install} -m 555 courier-authlib.sysvinit \
	 $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/courier-authlib

%post
%{_libexecdir}/courier-authlib/authmigrate >/dev/null
%{_libexecdir}/courier-authlib/sysconftool %{_sysconfdir}/authlib/*.dist >/dev/null

/sbin/chkconfig --del courier-authlib
/sbin/chkconfig --add courier-authlib

%preun
if test -x %{_sbindir}/authdaemond
then
	%{_sbindir}/authdaemond >/dev/null 2>&1 || /bin/true
fi

if test "$1" = "0"
then
	/sbin/chkconfig --del courier-authlib
fi

%clean
rm -rf $RPM_BUILD_ROOT


%files -f configfiles.base
%defattr(-,root,root,-)
%doc README README*html README.authmysql.myownquery README.ldap
%doc NEWS COPYING* AUTHORS ChangeLog authldap.schema
/etc/rc.d/init.d/*
%ghost %attr(600, root, root) %{_localstatedir}/spool/authdaemon/pid.lock
%ghost %attr(644, root, root) %{_localstatedir}/spool/authdaemon/pid
%ghost %attr(-, root, root) %{_localstatedir}/spool/authdaemon/socket
%{_mandir}/man1/*

%files -f configfiles.userdb userdb
%{_mandir}/man8/*userdb*

%files -f configfiles.devel devel
%defattr(-,root,root,-)
%{_bindir}/courierauthconfig
%{_includedir}/*
%{_mandir}/man3/*
%doc authlib.html auth_*.html

%files -f configfiles.ldap ldap
%defattr(-,root,root,-)
%doc authldap.schema

%files -f configfiles.mysql mysql

%files -f configfiles.pgsql pgsql

%files -f configfiles.pipe pipe

%changelog
* Sun Oct  3 2004 Mr. Sam <sam@email-scan.com> - 0.50-1
- Initial build.

