/* font.h - multiple font handling
   Copyright (C) 1996-2000 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#ifndef _FONT_H
#define _FONT_H

typedef struct {
    unsigned char width;
    unsigned char descent;
} fontdim_t;

struct font_object {
    char *name;
    int ref;
    XFontSet font_set;
    XFontStruct *font_struct;
    void *pad1;
    int pad2;
    GC gc;
    int mean_font_width;
    int fixed_font;
    int anti_aliasing;
    int font_height;
    int font_ascent;
    int font_descent;
    struct font_object *next;
    fontdim_t *per_char;
    char per_char_256[256];
    int num_per_char;
    int free_font_struct;
};

#define CGC				current_font->gc
#define FONT_MEAN_WIDTH			current_font->mean_font_width
#define FIXED_FONT			current_font->fixed_font
#define FONT_ASCENT			current_font->font_ascent
#define FONT_HEIGHT			current_font->font_height
#define FONT_DESCENT			current_font->font_descent
#define FONT_PER_CHAR(x)		font_per_char(x)
#define FONT_USE_FONT_SET		(!current_font->font_struct && current_font->font_set)
#define FONT_LAST_UNICHAR		0x1FFFFUL
#define FONT_ANTIALIASING		current_font->anti_aliasing

/* if you know the char < 256 */
#define FONT_PER_CHAR_256(x)		current_font->per_char_256[x]

#define FONT_PER_CHAR_DESCENT(x)	font_per_char_descent(x)
#define FONT_OVERHEAD			option_text_line_spacing
#define FONT_PIX_PER_LINE		(FONT_OVERHEAD + FONT_HEIGHT)
#define FONT_BASE_LINE			(FONT_OVERHEAD + FONT_ASCENT)

int font_per_char (wchar_t c);
int font_per_char_descent (wchar_t c);

void CFreeAllFonts (void);
int CPushFont (char *name, char *xname);
void CPopFont (void);

#endif


