/*
	$Id: streamed_mikmod_sample.cpp,v 1.1.1.1 2000/04/09 12:18:03 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Streamed sample

*/

#include "API/MikMod/streamed_mikmod_sample.h"

/*****************************
      CL_Streamed_MikModSample
*****************************/

CL_SoundBuffer *CL_Streamed_MikModSample::create(
	const char *filename,
	CL_InputSourceProvider *inputprovider, 
	bool looped)
{
	return CL_SoundBuffer::create(new CL_Streamed_MikModSample(filename, inputprovider, looped), true);
}

CL_Streamed_MikModSample::CL_Streamed_MikModSample(const char *_filename, CL_InputSourceProvider *_inputprovider, bool _looped)
{
	filename = _filename;
	looped = _looped;

	if (_inputprovider == NULL)
	{
		inputprovider = CL_InputSourceProvider::create_file_provider(".");
	}
	else
	{
		inputprovider = _inputprovider->clone();
	}

}

CL_Streamed_MikModSample::~CL_Streamed_MikModSample()
{
	delete inputprovider;
}

CL_StreamSoundProvider_Session *CL_Streamed_MikModSample::begin_session()
{
	return new CL_Streamed_MikModSample_Session(inputprovider->open_source(filename), looped, filename);
}

void CL_Streamed_MikModSample::end_session(CL_StreamSoundProvider_Session *session)
{
	delete session;
}

/*****************************
  CL_Streamed_MikModSample_Session
*****************************/

CL_Streamed_MikModSample_Session::CL_Streamed_MikModSample_Session(
	CL_InputSource *_input, bool _looped, const char* filename)
{
	input = _input;
	looped = _looped;
	cl_assert(input != NULL);

	/* Register the loaders we want to use:  */
	MikMod_RegisterAllLoaders();

	/* Register the drivers we want to use: */
	MikMod_RegisterDriver(&drv_nos);

#if LIBMIKMOD_VERSION >= ((3 << 16) | (1 << 8) | (7))
	MikMod_Init("");
#else
	MikMod_Init();
#endif

	md_mode |= DMODE_INTERP;

	mf = Player_Load((char*)filename,8,0);

	if (mf == NULL)
	  {
	    throw CL_Error(MikMod_strerror(MikMod_errno));
	  }

	mf->loop = looped;

	Player_Start(mf);

	sample_freq = md_mixfreq;

	int bytes_per_sample = ((md_mode&DMODE_STEREO)?2:1) * ((md_mode&DMODE_16BITS)?2:1);

	if (((md_mode&DMODE_STEREO)?2:1) == 2 && bytes_per_sample == 4) sample_format = sf_16bit_signed_stereo;
	else if (((md_mode&DMODE_STEREO)?2:1) == 2 && bytes_per_sample == 2) sample_format = sf_8bit_signed_stereo;
	else if (((md_mode&DMODE_STEREO)?2:1) == 1 && bytes_per_sample == 2) sample_format = sf_16bit_signed;
	else if (((md_mode&DMODE_STEREO)?2:1) == 1 && bytes_per_sample == 1) sample_format = sf_8bit_signed;
	else
	{
		std::cout << "    Invalid wave file format         " << std::endl;
		std::cout << "---------------------------------" << std::endl;
		std::cout << "Sample size: " << sample_size << std::endl;
		std::cout << "Sample frequency: " << sample_freq << std::endl;
		std::cout << "Number of channels: " << ((md_mode&DMODE_STEREO)?2:1) << std::endl;
		std::cout << "Number of bytes pr. sample: " << bytes_per_sample << std::endl;
		std::cout << "---------------------------------" << std::endl;

		throw CL_Error("Invalid wave file format");
	}
}

CL_Streamed_MikModSample_Session::~CL_Streamed_MikModSample_Session()
{
	Player_Stop();
	Player_Free(mf);
	MikMod_Exit();
	delete input;
}

bool CL_Streamed_MikModSample_Session::eof() const
{
	return !Player_Active();
}

bool CL_Streamed_MikModSample_Session::set_position(int pos)
{
	Player_SetPosition(pos);
	return true; // (Player_GetPosition() == pos); does not exist, what to do?
}

bool CL_Streamed_MikModSample_Session::play()
{
	if (Player_Active())
		return false;
		
	Player_Start(mf);
	return Player_Active() != 0;
}

void CL_Streamed_MikModSample_Session::stop()
{
	Player_Stop();
}

int CL_Streamed_MikModSample_Session::get_data(void *data_ptr, int data_requested)
{
/*	if (!Player_Active() && looped)
	{
		Player_SetPosition(0);
		Player_Start(mf);
	}*/

	MikMod_Update();
	int read = VC_WriteBytes((SBYTE*)data_ptr,data_requested);

	return read;
}

int CL_Streamed_MikModSample_Session::get_frequency() const
{
	return sample_freq;
}

SoundFormat CL_Streamed_MikModSample_Session::get_format() const
{
	return sample_format;
}
