/*
	$Id: cl_gtextfield.cpp,v 1.2 2000/04/25 21:40:16 mbn Exp $
*/
#include <API/GUI/cl_gtextfield.h>
#include <API/GUI/cl_gapplication.h>

CL_GTextfield::CL_GTextfield(CL_GWidget *parent,int x,int y,int w,int h,
			     CL_Font *font=0):
  CL_GWidget(parent,x,y,w,h),
  text_font(font),
  align(ALIGN_RIGHT),
  cursor_pos(0),
  draw_cursor(false),
  cursor(false),
  block_input(false)
  
{
  register_slot(cl_slot(CL_GTextfield::keypress));
  register_signal(cl_signal(CL_GTextfield::changed));
  if(text_font==0)
    text_font=uapp->getButtonFont();
}

CL_GTextfield::~CL_GTextfield(){
  deregister_slot(cl_slot(CL_GTextfield::keypress));
  deregister_signal(cl_signal(CL_GTextfield::changed));
}

void CL_GTextfield::create(){
  CL_GWidget::create();
  if (!text_font) return;
  	int text_width = text_font->get_text_width(text.c_str());
	int text_height = text_font->get_height();
	 CL_SurfaceProvider *surf_prov = surface_->get_provider();
	CL_GRect dest;
	 switch(align)
	{
		case ALIGN_CENTER:
			dest = CL_GRect((surf_prov->get_width()-text_width)/2,
				(surf_prov->get_height()-text_height)/2,
				text_width, text_height);
			
			break;
			
		case ALIGN_LEFT:
			dest = CL_GRect(0,
				(surf_prov->get_height()-text_height)/2,
				text_width, text_height);
			break;
			
		case ALIGN_RIGHT:
		 	dest = CL_GRect((surf_prov->get_width()-text_width),
				(surf_prov->get_height()-text_height)/2,
				text_width, text_height);
			break;
    }
	text_font->put_target(dest.upperLeft().x, dest.upperLeft().y, text.c_str(), surf_prov);
}

void CL_GTextfield::keypress(int key){

  needsUpdate_=true;
}
bool CL_GTextfield::processEvent(const CL_GEvent *event)
{
  bool handled = false;


  if(haveFocus_)
    {
     // cerr << "we have focus\n";
      if(event->type() == CL_GEvent::KEY)
	{
	  if(((CL_GKeyEvent *)event)->get_state() == CL_GKeyEvent::PRESSED)
	    {
	      CL_Key tkey =((CL_GKeyEvent *)event)->get_key();
	      char input = tkey.ascii;
	     
	      //basic editing: there are ENTER and BS 
	      //nearly emacs ... HAHAHA
	      if(!block_input && std::isprint(input))
		{
		  text += std::string(1,input);
		  needsUpdate_ = true;
		  //textChanged_ = true;
		  cerr << "text=" << text.c_str() << endl;
		  changed(/*text.c_str()*/this);
		  handled = true;
		}
	      if((input =='\n') || (input == '\r'))
		{
		  enter(/*text.c_str()*/this);
		  handled = true;
		}
	      if(input == '\b' || tkey.id==62)
		{
		  if(text.length() > 0)
		    {
		      text.erase(text.length()-1,1);
		      needsUpdate_ = true;
		      block_input = false;
		      changed(/*text.c_str()*/this);
		    }
		  handled = true;
		}
	      if(handled)
		{
		  //emit signal
		  keypress(0);
		}
	      
	    }
	}
    
      
    } // if(haveFocus_)
      
  
  
  if(!haveFocus_)
    {
      if(cursor)
	{
	  draw_cursor = false;
	  needsUpdate_ = true;
	  
	}
    }
  
  return handled;
}
