/*
	$Id: implementation_svgalib.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Initialization functions for Svgalib implementation.

*/

#include "Core/precomp.h"

#ifdef USE_SVGALIB

#include "API/Core/Display/display.h"
#include "Core/System/Unix/implementation_svgalib.h"
#include "Core/Display/Svgalib/displaycard_svgalib.h"
// #include "Core/Input/Svgalib/keyboard_svgalib.h"
#include "API/Core/Input/input.h"
//#include "Core/Input/FBDev/mouse_fbdev.h"
#include "Core/Input/TTY/keyboard_tty.h"
#include "Core/Input/X11/joystick_linux.h"
#include "implementation.h"


extern "C"
{
	DL_PREFIX char* clan_module_identify()
	{
		return "SVGAlib target";
	}

	DL_PREFIX char* clan_module_abbreviation()
	{
		return "svga";
	}

	DL_PREFIX void clan_module_init()
	{
		CL_Implementation_Svgalib::add_display();
	}
}

char *svgalib_identify()
{
	return clan_module_identify();
}

char *svgalib_abbreviation()
{
	return clan_module_abbreviation();
}

void svgalib_init()
{
	return clan_module_init();
}


void CL_Implementation_Svgalib::add_display()
{
	int card_no = CL_Display::cards.size();
	CL_Display::cards.push_back(new CL_DisplayCard_Svgalib(card_no));
}

void CL_Implementation_Svgalib::add_input()
{
	CL_Input::keyboards.push_back(new CL_TTYKeyboard());
//	CL_Input::pointers.push_back(new CL_Mouse_FBDev());

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)

	for (int i=0; i<8; i++)
	{
		CL_LinuxJoystick *joy = new CL_LinuxJoystick();
		if (joy->init(i))
			CL_Input::joysticks.push_back(joy);
		else
			delete joy;
	}

#endif

//	CL_Input::keyboards.add(new CL_SVGAKeyboard());
}

#endif
