/*
	$Id: implementation_ggi.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Initialization functions for GGI implementation.

*/

#include "Core/precomp.h"

#ifdef USE_GGI

#include "implementation_ggi.h"
#include "API/Core/Display/display.h"
#include "Core/Display/GGI/display_ggi.h"
#include "API/Core/Input/input.h"
#include "Core/Input/GGI/mouse_ggi.h"
#include "Core/Input/GGI/keyboard_ggi.h"
#include "Core/Input/X11/joystick_linux.h"
#include "implementation.h"

bool CL_Implementation_GGI::initialized = false;
int CL_Implementation_GGI::display_counter=0;

static CL_Implementation_GGI impl_ggi;

extern "C"
{
	DL_PREFIX char* clan_module_identify()
	{
		return "GGI target";
	}

	DL_PREFIX char* clan_module_abbreviation()
	{
		return "ggi";
	}

	DL_PREFIX void clan_module_init()
	{
		impl_ggi.add_display();
	}
}

char *ggi_identify()
{
	return clan_module_identify();
}

char *ggi_abbreviation()
{
	return clan_module_abbreviation();
}

void ggi_init()
{
	clan_module_init();
}

CL_Implementation_GGI::~CL_Implementation_GGI()
{
	clean_up();
}

bool CL_Implementation_GGI::init()
{
	if (initialized) return true;

	return true;
}

void CL_Implementation_GGI::clean_up()
{
	if (display_counter == 0) return; // nothing to clean up...

	display_counter--;
	if (display_counter>0) return;
}

void CL_Implementation_GGI::add_display()
{
	if (init() == false)
	{
		cout << "ClanLib: Failed to open display. No GGI display available." << endl;
	}

	CL_GGI_DisplayCard *card = new CL_GGI_DisplayCard(display_counter);

	CL_Display::cards.push_back(card);

	CL_Input::keyboards.push_back(new CL_GGIKeyboard(card));
	CL_Input::pointers.push_back(new CL_Mouse_GGI(card));

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)

	for (int i=0; i<8; i++)
	{
		CL_LinuxJoystick *joy = new CL_LinuxJoystick();
		if (joy->init(i))
			CL_Input::joysticks.push_back(joy);
		else
			delete joy;
	}

#endif

	display_counter+=2;
}

#endif
