/*
	$Id: provider_pcx.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		PCX surface provider.
*/

//! component="SurfaceProviders"

#ifndef header_pcxprovider
#define header_pcxprovider

#include "generic_surfaceprovider.h"
#include "../Display/pixelformat.h"

class CL_PCXProvider : public CL_SurfaceProvider_Generic
//: Surface provider that can load PCX files.
{
public:
	static CL_Surface *create(
		std::string handle,
		CL_InputSourceProvider *provider,
		bool transparent=false,
		unsigned char trans_col=0);
	//: Loads the pcx file 'handle' from the inputsource provider 'provider. 
	//: Creates a CL_Surface using the pcx image and returns it.
	//: If you just want to load a file, use 'handle' for filename, and set provider to NULL
	
	CL_PCXProvider(
		std::string name,
		CL_InputSourceProvider *provider,
		bool transparent=false,
		unsigned char trans_col=0);
	//: Constructs a surface provider that can read pcx files.
	//!param: name - Name of the pcx file to load.
	//!param: provider - Input source provider that delivers the pcx file.
	//!param: transparent - True if a color in image should be transparent.
	//!param: trans_col - Transparency color used if 'transparent' is true. Defaults to color 0.

	virtual ~CL_PCXProvider();

	virtual unsigned int get_pitch() const { return pitch; }
	//: Returns the pitch of the image (bytes per line).

	virtual int get_translate_x() const { return bounding_left; }
	//: Returns how many pixels to translate the image (X axis).

	virtual int get_translate_y() const { return bounding_top; }
	//: Returns how many pixels to translate the image (Y axis).

	virtual unsigned int get_width() const { return bounding_right-bounding_left; }
	//: Returns the width of the image.

	virtual unsigned int get_height() const { return bounding_bottom-bounding_top; }
	//: Returns the height of the image.

	virtual unsigned int get_num_frames() const { return 1; }
	//: Returns the number of subsprites in the image.
/*
	virtual EPixelFormat get_pixel_format() const;
	//: Returns the pixelformat used by the image.
*/
	virtual unsigned int get_red_mask() const;
	virtual unsigned int get_green_mask() const;
	virtual unsigned int get_blue_mask() const;
	virtual unsigned int get_alpha_mask() const;
	virtual unsigned int get_depth() const;

	virtual CL_Palette *get_palette() const { return palette; }
	//: Returns the palette used by the image. NULL if system palette.

	virtual bool is_indexed() const { return true; }
	
	virtual bool uses_src_colorkey() const { return trans_col != -1; }

	virtual unsigned int get_src_colorkey() const { return trans_col; }
	//: Returns the transparency color used, -1 if none.

	virtual void *get_data() const { return image+bounding_left+bounding_top*pitch; }
	//: Returns the image data. Provider must be locked before pointer is valid.

	virtual void perform_lock();
	//: Locks the surface provider.

	virtual void perform_unlock();
	//: Unlocks the surface provider.

private:
	CL_InputSourceProvider *provider;
	int pitch, height;
	int bounding_left, bounding_top, bounding_right, bounding_bottom;
	bool transparent;
	int trans_col;
	std::string name;
	EPixelFormat pixelformat;

	CL_Palette *palette;
	unsigned char *image;
};

#endif
