/*
	$Id: provider_mpeg.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		mpeg player using libmpeg.

*/

//! component="SurfaceProviders"

#ifndef header_mpegprovider
#define header_mpegprovider

#ifdef USE_LIBMPEG

#include <stdio.h>
#include <mpeg.h>
#include "generic_surfaceprovider.h"

class CL_MPEGProvider : public CL_SurfaceProvider_Generic
//: A surface provider that can show MPEG animations.
{
public:
	static CL_Surface *create(char *filename)
	{
		return CL_Surface::create(new CL_MPEGProvider(filename, FULL_COLOR_DITHER), true);
	}
	//: Creates a surface using the mpeg file 'filename' as source.
	//!param: filename - The mpeg file to use.

	static CL_Surface *create(char *filename, int dithermode)
	{
		return CL_Surface::create(new CL_MPEGProvider(filename, dithermode), true);
	}
	//: Creates a surface using the mpeg 'filename' as source and 
	//: dithermode passed to libmpeg.


	CL_MPEGProvider(const char *filename, int dithermode);
	//: Constructs a surfaceprovider using the mpeg file 'filename' as source, 
	//: passing flags to libmpeg.
	//!param: filename - mpeg file to use.
	//!param: dithermode - passed to libmpeg.
	
	virtual ~CL_MPEGProvider();

	virtual void rewind();
	//: Rewinds the mpeg stream
	
	virtual unsigned int get_framerate() const;
	//: Returns the framerate

	virtual unsigned int get_width() const;
	//: Returns the width of the image.
	
	virtual unsigned int get_height() const;
	//: Returns the height of the image.

	virtual unsigned int get_pitch() const;
	//: Returns the pitch of the Image.
	
	virtual unsigned int get_num_frames() const;
	//: Returns the number of subsprites in the image.

	virtual EPixelFormat get_pixel_format() const;
	//: Returns the pixel format used by the image.

	virtual unsigned int get_red_mask() const;
	virtual unsigned int get_green_mask() const;	
	virtual unsigned int get_blue_mask() const;
	virtual unsigned int get_alpha_mask() const;

	virtual CL_Palette *get_palette() const;
	//: Returns the palette used by the image. NULL if system palette.
	
	virtual bool is_indexed() const;
	virtual bool uses_src_colorkey() const;
	
	virtual unsigned int get_src_colorkey() const;
	//: Returns the transparency color used the image. -1 if none.

	virtual void *get_data() const;
	//: Returns a pointer to the image data. Must be locked before data is valid.

	virtual void perform_lock();
	//: Locks the surface provider.
	
	virtual void perform_unlock();
	//: Unlocks the surface provider.

private:
	FILE *mpeg;
	ImageDesc img;
	char *pixels;
	bool moreframes;
};

#endif
#endif