/*
	$Id: provider_convpoly_basics.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		ConvexPolygon_Basics provides all the common functionality of convex
		polygons.

*/

#ifndef header_provider_convpoly_basics
#define header_provider_convpoly_basics


#ifndef max
	#define max(a,b) ((a>b) ? (a) : (b))
#endif

#ifndef min
	#define min(a,b) ((a<b) ? (a) : (b))
#endif

#include "../../stl.h"
#include "generic_surfaceprovider.h"

class CL_ConvexPolygonPoint
{
public:
	int x, y, u, v;

	CL_ConvexPolygonPoint(int _x, int _y, int _u, int _v)
	{
		x=_x; y=_y; u=_u; v=_v;
	}

	CL_ConvexPolygonPoint(CL_ConvexPolygonPoint &copy)
	{
		x = copy.x;
		y = copy.y;
		u = copy.u;
		v = copy.v;
	}
};

class CL_ConvexPolygon_Basics : public CL_SurfaceProvider_Generic
{
public:
	CL_ConvexPolygon_Basics();
	virtual ~CL_ConvexPolygon_Basics();

	virtual void add_point(int x, int y, int u, int v);
	virtual void add_point(CL_ConvexPolygonPoint &point);
	virtual void clear_points();
	virtual unsigned int get_width() const { return max_x-min_x+1; }
	virtual unsigned int get_height() const { return max_y-min_y+1; }
	virtual unsigned int get_pitch() const { return get_width(); }

	virtual void perform_lock();
	virtual void perform_unlock();

protected:
	std::vector<CL_ConvexPolygonPoint*> points;

	int *scanline_left;
	int *scanline_right;
	int *scanline_left_mapping;
	int *scanline_right_mapping;

	int min_x, min_y;
	int max_x, max_y;

	int top_point, bottom_point;

	bool changed;

	virtual void calc_boundary();
	void draw_scanline(int *dest, int x1, int y1, int x2, int y2);
	void create_scanline(int start_point, int end_point, int **scanline, int **scanline_mapping);
	virtual void setup();
};

#endif
