/*
	$Id: static_provider_wave.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Simple sample support.

*/

//! component="Static SoundProviders"

#ifndef header_sampleprovider
#define header_sampleprovider

#include "../../stl.h"
#include "../Sound/static_soundprovider.h"
#include "../Sound/soundbuffer.h"

class CL_Sample : public CL_StaticSoundProvider
//: ClanLib's datafile samples. This class can read samples from datafiles.
{
public:
	static CL_SoundBuffer *create(
		const char *sample_id,
		CL_InputSourceProvider *provider);
	//: Loads the sample 'sample_id' from the inputsource provider 'provider'. 
	//: Creates a CL_SoundBuffer using this sample and returns it.

	CL_Sample(
		const char *s_id,
		CL_InputSourceProvider *_provider);
	//: Constructs a static sound provider that represents 'sample_id' from the
	//: inputsource provider 'provider'.

	virtual ~CL_Sample();

	virtual void lock();
	//: Locks the sample data.

	virtual void unlock();
	//: Unlocks the sample data.

	virtual SoundFormat get_format() const;
	//: Returns the sample format used by this sample.

	virtual int data_size() const;
	//: Returns the size of the sample.

	virtual void *get_data() const;
	//: Returns the sample data. Must be locked before this is done.

	virtual int get_frequency() const;
	//: Returns the default frequency used when playing this sample.

private:
	struct WAVE_FORMAT
	{
		short formatTag;
		short nChannels;
		int nSamplesPerSec;
		int nAvgBytesPerSec;
		short nBlockAlign;
	};

	CL_InputSourceProvider *provider;
	std::string sample_id;

	char *sample_data;
	SoundFormat sample_format;
	int sample_size;
	int sample_freq;

	void load_data();
};

#endif
