/*
	$Id: network.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Network component header file.


*/

//! component="Network"

#ifndef header_network
#define header_network

#include "../../stl.h"

class CL_NetGame;

class CL_Network
//: Network component class. Starting place for all net activity in ClanLib.
{
public:
	static void find_games_broadcast(
		std::string game_id,
		int port);
	//: Searchs for games using UDP broadcasting at the specified 'port'. 
	//: Only games with the same 'game_id' are added to CL_Network::netgames.
	//!param: game_id - The game's ID used to locate this type of game with.
	//!param: port - Broadcast UDP port.
	
	static void find_game_at(
		std::string game_id,
		const char *host_address,
		int port);
	//: Searchs for games at the specified host address and port ('port').
	//!param: host_address - IP address or hostname of the computer to be contacted.
	//!param: port - Port which the computer contacted listens on.
	
	static bool peek_game_found();
	//: Returns true if any netgames have been found. Use receive_game_found() to
	//: get the individual games found.
	//!retval: True if any netgames have been found.

	static CL_NetGame *receive_game_found(int timeout_millis);
	//: Returns the first netgame found. It is then removed from the list of games
	//: found. Next time it is called it will return the next in available. <br>
	//: The function is blocking until the specified timeout runs out.
	//: If set to zero, it will block forever until a game has been found.<br>
	//: Remember to delete the netgame returned after usage.
	//!param: timeout_millis - Timeout before returning if no game was found.
	//!retval: The netgame found, or NULL if timed out. Remember to delete the
	//!retval: netgame after usage.

	static void clear_games_found();
	//: Clears the list of games found.

	static CL_NetGame *create_game(
		std::string game_id,
		int port);
	//: Creates a new network game.
	//!param: game_id - The game ID is used to locate netgames of the same type.
	//!param: port - Port the game accepts connections on - and listens for broadcasts.
	//!retval: The created network game.
};

#endif
