/*
	$Id: keyboard.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Input"

#ifndef header_keyboard
#define header_keyboard

#include "inputdevice.h"

enum
{
	CL_KEY_A, CL_KEY_B, CL_KEY_C, CL_KEY_D, CL_KEY_E, CL_KEY_F, CL_KEY_G,
	CL_KEY_H, CL_KEY_I, CL_KEY_J, CL_KEY_K, CL_KEY_L, CL_KEY_M, CL_KEY_N,
	CL_KEY_O, CL_KEY_P, CL_KEY_Q, CL_KEY_R, CL_KEY_S, CL_KEY_T, CL_KEY_U,
	CL_KEY_V, CL_KEY_W, CL_KEY_X, CL_KEY_Y, CL_KEY_Z, CL_KEY_0, CL_KEY_1,
	CL_KEY_2, CL_KEY_3, CL_KEY_4, CL_KEY_5, CL_KEY_6, CL_KEY_7, CL_KEY_8,
	CL_KEY_9,

	CL_KEY_F1, CL_KEY_F2, CL_KEY_F3, CL_KEY_F4, CL_KEY_F5, CL_KEY_F6,
	CL_KEY_F7, CL_KEY_F8, CL_KEY_F9, CL_KEY_F10, CL_KEY_F11, CL_KEY_F12,

	CL_KEY_ESCAPE, CL_KEY_LEFT, CL_KEY_RIGHT, CL_KEY_UP, CL_KEY_DOWN,
	CL_KEY_LCTRL, CL_KEY_RCTRL, CL_KEY_LSHIFT, CL_KEY_RSHIFT, CL_KEY_ALT,
	CL_KEY_ALTGR, CL_KEY_TAB, CL_KEY_ENTER, CL_KEY_SPACE, CL_KEY_BACKSPACE,
	CL_KEY_INSERT, CL_KEY_DELETE, CL_KEY_HOME, CL_KEY_END, CL_KEY_PAGEUP,
	CL_KEY_PAGEDOWN, CL_KEY_CAPSLOCK, CL_KEY_NUMLOCK, CL_KEY_SCRLOCK,
	CL_KEY_PRINT, CL_KEY_PAUSE, CL_KEY_KP_DIV, CL_KEY_KP_MULT,
	CL_KEY_KP_MINUS, CL_KEY_KP_PLUS, CL_KEY_KP_ENTER,

	CL_KEY_NONE_OF_THE_ABOVE,
	CL_NUM_KEYS
};
// Key buttons available on a keyboard.

class CL_Keyboard : public CL_InputDevice
//: Keyboard interface in ClanLib.
// This is the keyboard input device interface. It contains all the extra
// functions needed by the keyboard, which didn't fit into the general
// CL_InputDevice abstraction.
{
public:
	virtual ~CL_Keyboard() { return; }

	static bool get_keycode(int button_no);
	//: Returns true if the specified button is down on the keyboard.
	//: <br>
	//: This static function is an easier way of writing 
	//: CL_Input::keyboards[0]->get_button->is_pressed();
	//!param: button_no - Button number checked for being pressed.
	//!retval: True if the key is pressed.
};

#endif
