/*
	$Id: inputbutton_to_axis_digital.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="InputConverters"

#ifndef header_inputbutton_to_axis_digital
#define header_inputbutton_to_axis_digital

#include "../Input/inputbutton.h"
#include "../Input/inputaxis.h"

class CL_InputButtonToAxis_Digital : public CL_InputAxis
//: Converts two CL_InputButton's into one digital CL_InputAxis. 
{
	CL_InputButton *left;
	CL_InputButton *right;

public:
	CL_InputButtonToAxis_Digital(
		CL_InputButton *_left,
		CL_InputButton *_right)
	{
		left = _left;
		right = _right;
	}
	//: Constructs a button to axis converter using the two buttons 'left' 
	//: and 'right'.

	virtual float get_pos()
	{
		if (left->is_pressed()) return -1;
		if (right->is_pressed()) return 1;
		return 0;
	}
	//: Returns the axis position.
	//!retval: Current axis position.
};

#endif
