/*
	$Id: res_surface.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Display 2D"

#ifndef header_res_surface
#define header_res_surface

class CL_ResourceManager;
class CL_ResourceOptions;
class CL_SurfaceProvider;

class CL_ResourceSource_Surface
//: Plugin interface for surface resources.
// <p>CL_ResourceSource_Surface is a plugin interface for the surface resource
// type.</p>
//
// <p>Applications and libraries can inherit this class to add their own
// customized surface sources. Just as any other plugin in ClanLib, the
// application or library has to keep one global instance of each plugin -
// otherwise the resource manager will not be able to use the new resource
// source.</p>
{
public:
	CL_ResourceSource_Surface();
	virtual ~CL_ResourceSource_Surface();
	
	virtual const char *get_name()=0;

	virtual bool can_create(
		std::string file_extension,
		CL_ResourceOptions *options)=0;

	virtual CL_SurfaceProvider *create(
		std::string filename,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent)=0;
};

#endif
