/*
	$Id: mousecursor_provider.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Display 2D"

#ifndef header_mousecursor_provider
#define header_mousecursor_provider

class CL_SurfaceProvider;
class CL_ResourceManager;

class CL_MouseCursorProvider
//: Mouse cursor image interface.
// <p>The mouse cursor provider is an interface that describes how a mouse
// cursor should animate, and which images it should use.</p>
// <p>Use this class to create your cursor icon, and then use CL_MouseCursor
// to make your cursor visible.</p>
{
public:
	static CL_MouseCursorProvider *create(
		CL_SurfaceProvider *provider,
		bool delete_provider=true,
		bool animate=true,
		const std::vector<int> *frame_delays=NULL);
	// <p>Creates a mouse cursor source, using a surface provider as the
	// image source.</p>
	// <p>If the surface provider contain subframes, those will be available
	// in the mouse cursor too. Furthermore, those frames can be used to
	// animate the cursor, if a list of millisec delays are passed as well.</p>
	//!param: provider - Image of the cursor.
	//!param: delete_provider - If true, the surface provider will be
	//!param:                   deleted together with the cursor provider.
	//!param: animate - If true, the subframes in the surface provider will
	//!param:           be used to animate the cursor.
	//!param: frame_delays - A list of millis to wait between each frame,
	//!param:                when animating the cursor.

	static CL_MouseCursorProvider *load(
		const char *resource_id,
		CL_ResourceManager *manager);
	// <p>Creates a mouse provider, loaded from resources.</p>
	//!param: resource_id - Resource ID of the mouse cursor.
	//!param: manager - Resource manager where the cursor is loaded from.

	virtual ~CL_MouseCursorProvider() { ; }

	virtual CL_SurfaceProvider *get_surface_provider()=0;
	// Returns the surface provider associated with the mouse cursor.
	
	virtual bool is_animated()=0;
	// Returns true if the cursor is animated.
	
	virtual int get_frame_delay(unsigned int frame_number)=0;
	// Returns the millisec delay between 'frame_number' and the next one.
};

#endif
