/*
	$Id: mousecursor.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Display 2D"

#ifndef header_mousecursor
#define header_mousecursor

class CL_MouseCursorProvider;

class CL_MouseCursor
//: Mouse cursor management class.
// <p>Use this class to set the mouse cursor icon, or to toggle its
// visibility.</p>
{
public:
	static void set_cursor(
		CL_MouseCursorProvider *provider,
		int frame=0);
	// Set the system mouse cursor to 'provider'. If 'frame' is also
	// specified, it will use that subframe in the cursor provider.
	//!param: provider - Mouse cursor to use.
	//!param: frame - Subframe in the mouse cursor to use.

	static void show(bool show_async=true);
	// Makes the currently selected mouse cursor visible. If 'show_async' is
	// true, it will use a secondary thread to draw the mouse. This ensures
	// that the mouse cursor will keep running smooth despite of the
	// framerate in the game.
	//!param: show_async - True if a secondary thread should be used for
	//!param:              mouse painting.

	static void hide();
	// Hides the mouse cursor.
};

#endif
