/*
    alpha test example... uses the Magick Provider on purpose
*/

#include <ClanLib/core.h>
#include <ClanLib/magick.h>

class SurfaceApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "alpha test application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupMagick::init();
		CL_SetupCore::init_display();
	}
	
	virtual void deinit_modules()
	{
		CL_SetupMagick::deinit();
		CL_SetupCore::deinit();
	}
	
	virtual int main(int, char **)
	{
		try
		{
			// Set mode: 640x480 16 bpp
			CL_Display::set_videomode(640, 480, 16);
		
			CL_Canvas *canvas = new CL_Canvas(640, 480, 1);
			CL_Canvas *screen = new CL_Canvas(640, 480, 1,
							CL_Color::get_red_mask(RGB565),
							CL_Color::get_green_mask(RGB565),
							CL_Color::get_blue_mask(RGB565),
							CL_Color::get_alpha_mask(RGB565));

			canvas->lock();
			unsigned int* data = (unsigned int*) canvas->get_data();
			
			for (int y=0; y<480; y++)
			{
				for (int x=0; x<640; x++)
				{
				        data[x + 640*y] = CL_Color::get_color(RGBA8888, 
						1.0f,
						0.0f,
						0.0f,
						float (y)/ 480.0f); 
				}
			}			
			canvas->unlock();
		
			// Load surface from jpg file:
			CL_Surface *image = CL_MagickProvider::create("back.jpg", NULL, RGB565);
			image->get_provider()->lock(); //force it to be persistent in memory
			
			CL_Surface *gradient = CL_Surface::create(canvas, true);
			CL_Surface *surface = CL_Surface::create(screen, true);
		
			float alpha = 0;
			int frames = 0;
			int time = CL_System::get_time();

			// Loop until the user hits escape:
			while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
				// Draw surface:
				CL_Display::clear_display();
				image->put_target(0, 0, 0, screen);
				
				//CL_Display::fill_rect(0, 0, 319, 199, 1.0, 1.0, 1.0, 1.0);
				
				alpha += 0.01f;
				if (alpha>1.0)
					alpha -= 1.0f;
				frames++;

				//for (int y=30; y<170; y++)
				//	CL_Display::draw_line(30, y, 290, y, 0.0, 0.0, 1.0, alpha);
				
				//CL_Display::fill_rect(30, 30, 290, 170, 0.0, 0.0, 1.0, alpha);

				gradient->put_target(0, 0, 0, screen);
				surface->reload();
				surface->put_screen(0,0);
			
				// Flip front and backbuffer. This makes the changes visible:
				CL_Display::flip_display();
			
				// Update keyboard input and handle system events:
				// Exits the loop if ClanLib requests shutdown - for instance if
				// someone closes the window.
				CL_System::keep_alive();
			}
			float fps = frames / ((float) (CL_System::get_time() - time) / 1000.0f);
			cout << "fps : " << fps << endl;

			delete surface;
			delete image;
			delete gradient;
		}
		catch(CL_Error error)
		{
			cout << "Exception caught : " << error.message.c_str() << endl;			
			return -1;
		}
		return 0;
	}
} app;
