#include "cp_types.h"
#include "cp_proto.h"

/* update the mobius transformations associated with side pairings
   in multiply connected cases. Return 0 if errors occur in the
   process -- particularly arith errors in routines of mobius_math.c */

int update_pair_mob(struct p_data *p)
{
  int j,length=0,err_flag=0;

  if (!p->redfaces) return 0;
  while (p->edge_pair[length+1].edge)
    length++;
  if (length>1)
    for (j=1;j<=length;j++)
      if (!pair_mobius(p,j)) err_flag++;
  if (err_flag) return 0;
  return 1;
} /* update_pair_mob */

