#include "cp_types.h"
#include "cp_proto.h"

/* rountines are only preliminary -- the shere is tough! */

/* Compute radii of packing to meet angle_sum targets, specified as
"aims". A negative "aim" means that that circle should not have its
radius adjusted. aim of zero is possible only for boundary 
circles in hyp setting. 

All routines are iterative, inspired by routine suggested
by Thurston. This file includes recent algorithms, old reliable
versions, and experimental stuff being tried in spherical case.

Radii are of type r,h, or s (for special): r is euclidean radius,
h is hyperbolic, and s=exp(-h). Other relationships are:
h=log((1+r)/(1-r)), s=(1-r)/(1+r), r=(1-s)/(1+s).
Will be storing radii as s_radii. If h is infinite, then will store
eucl radius with negative value as the s_radius so it can be
used in graphing the appropriate circle. 

There currently is no packing algorithm for spherical geometry. Only
approach is to force packing into unit disc, do maximal packing
there and project back to sphere. Often, this involves a "puncture"
of the complex; missing circle is replaced as northern hemisphere
after max packing is projected back to sph. 

Overlap angles specified > Pi/2 can lead to incompatibilities. To
avoid domain errors, routines computing angles in such cases return
angle Pi. */

int s_riffle(struct p_data *p,int passes)
     /* adjust sph radii to meet curvature targets in 'aim'.
A target less than zero means that vertex is free - no adjustments.
Bdry radii adjusted only if their aim >= 0. Geometry forces different
tactics. To normalize, we find first face having three default aims,
set its aims to -1 and its radii to pi/3. When we state the
process, may need preliminary changes in some radii to avoid
incompatibilities. Also, process slow, so accept greater error. 
Also, may need alternate methods for complexes with bdry. */
{
  int i,j,aimnum=0,*index,count=0,dummy,norm_face,flag,v;
  double max_err=0,err,valence,new_radius;
  struct R_data *pR_ptr;
  f_data *face_ptr;

  index=(int *)malloc(5*(p->nodecount+1)*sizeof(int));
  pR_ptr=p->packR_ptr;
  face_ptr=p->faces;
  /* Pick face to normalize */
  flag=1;i=0;
  while (flag && i++<=p->facecount)
    {
      flag=0;
      for (j=0;j<3;j++)
	if (fabs(p->packR_ptr[face_ptr[i].vert[j]].aim 
		 - 2.0*M_PI) > okerr) flag=1;
    }
  if (flag) /* no face to normalize */
    {free(index);return count;}
  norm_face=i;
  for (j=0;j<3;j++)
    {
      pR_ptr[face_ptr[norm_face].vert[j]].rad = (M_PI-okerr)/3.0;
      pR_ptr[face_ptr[norm_face].vert[j]].aim = -1.0;
    }
  /* make sure radii compatibility is met */
  ck_s_compat(p,norm_face);
  /* identify verts subject to change */
  fillcurves(p);
  for (i=1;i<=p->nodecount;i++)
    if (pR_ptr[i].aim>0)
      {
	index[aimnum]=i;
	aimnum++;
	err=pR_ptr[i].curv-pR_ptr[i].aim;
	max_err = (fabs(err)>max_err) ? fabs(err) : max_err;
      }
  if (aimnum==0 || max_err < .0001) /* none to adjust or okay. */
    {
      for (j=0;j<3;j++) pR_ptr[face_ptr[norm_face].vert[j]].aim =
			  2.0*M_PI; /* reset aims of face used for norming */
      free(index);
      return count;
    }

  /* find valence of mapping from aim totals */
  valence=(branch_order(p)/2.0) + 1.0;
  /* ultimately need to branch for complexes with bdry, and possibly
     for branched complexes. */
  /* if only one vertex subject to adjustment */
  if (aimnum==1) 
    {
      for (j=0;j<3;j++) pR_ptr[face_ptr[norm_face].vert[j]].aim =
			  2.0*M_PI; /* reset aims of face used for norming */
      v=s_riffle_vert(p,index[0]);
      free(index);
      return(v);
    }
  /* normalize area */
  s_radcalc_norm(p,valence);
  v=1;  /*initalize for record keeping */
  while ((!(v=select_vertex(p,index,aimnum))==0)
	 && (count < passes))
    {
      count++;
      if ((count % 100)==0)
	{
	  s_radcalc_norm(p,valence);
	  sprintf(msgbuf," %d-> % .8e ",v,pR_ptr[v].curv/M_PI);
	  msg();
	} 
      new_radius=s_radcalc(p,v,pR_ptr[v].rad,pR_ptr[v].aim,&dummy);
      s_changerad(p,v,new_radius);
      /* s_radcalc_norm(p,valence); */
    }			
  for (j=0;j<3;j++) pR_ptr[face_ptr[norm_face].vert[j]].aim =
		      2.0*M_PI; /* reset aims of face used for norming */
  free(index);
  return count;
} /* s_riffle */

int s_riffle_vert(struct p_data *p,int i)
{
  int n=0,dummy,flag=0;
  double diff;
  struct R_data *pR_ptr;

  pR_ptr=p->packR_ptr;
  s_anglesum_overlap(p,i,pR_ptr[i].rad,&pR_ptr[i].curv,&flag);
  diff=pR_ptr[i].curv-pR_ptr[i].aim;
  while (n<20 && (diff>okerr || diff<(-okerr)) )
    /* limit number of attempts */
    {
      pR_ptr[i].rad=s_radcalc(p,i,
			      pR_ptr[i].rad,pR_ptr[i].aim,&dummy);
      s_anglesum_overlap(p,i,pR_ptr[i].rad,&pR_ptr[i].curv,&flag);
      diff=pR_ptr[i].curv-pR_ptr[i].aim;
      n++;
    }
  return n;
} /* s_riffle_vert */
