#include "cp_types.h"
#include "cp_proto.h"

/* cut out generational sub-complex */

int gen_cut(struct p_data *p,int v,int gen)
{
  int i,j,w,wflag=0,*newold=NULL,*dum=NULL,oldcount,count;
  char buff[32];
  struct K_data *pK_ptr;
  struct RedList *redlist,*rtrace;
  struct Edgelist *trace;

  /* build the appropriate red chain */
  redlist=build_gen_redlist(p,v,dum,gen,&count);
  if (count>=p->nodecount) 
    {
      if (redlist) free_redfaces(&redlist);
      return 1;
    }
  if (!redlist) return 0;

  /* Mark the outside verts 'poison' and call cookie to finish up */

  pK_ptr=p->packK_ptr;
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].mark=0;
  rtrace=redlist;
  while (rtrace!=redlist || !(wflag++))
    {
      pK_ptr[p->faces[rtrace->face].vert[nghb_tri(p,
	 rtrace->next->face,rtrace->face)]].mark=1;
      rtrace=rtrace->next;
    }
  if (redlist) free_redfaces(&redlist);
  sprintf(buff,"-v %d m",v);
  oldcount=p->nodecount; /* save orig nodecount */
  if (!cookie_cutter(p,buff,&newold))
    {
      sprintf(msgbuf,"cookie failed.");
      emsg();
      if (newold) free(newold);
      return 0;
    }

  for (i=1;i<=p->nodecount;i++) p->packK_ptr[i].plot_flag=1;
  if (newold)
    {
      p->vertex_map=trace=(struct Edgelist *)
	calloc((size_t)1,sizeof(struct Edgelist));
      for (j=1;j<=p->nodecount;j++)
	if ((w=newold[j]))
	  {
	    trace=trace->next=(struct Edgelist *)
	      calloc((size_t)1,sizeof(struct Edgelist));
	    trace->v=j;
	    trace->w=w;
	  }
      trace=p->vertex_map;
      p->vertex_map=p->vertex_map->next;
      free(trace);
      free(newold);
    }
  return p->nodecount; /* success */
} /* gen_cut */

