#include "cp_types.h"
#include "cp_proto.h"

/* 'energy' considerations for points (circle centers ) distributed 
   on the sphere (only). */

int print_energy(struct p_data *p)
     /* compute the 'energy' for exponents s=-1,0,1, or infinity. Return 0
on error. */
{
  double E_0,E_neg_1,E_1;

  if (p->hes<=0)
    {
      sprintf(msgbuf,"Can call '?energy' only for spherical packings.");
      emsg();
      return 0;
    }
  E_neg_1=comp_energy(p,-1.0);
  E_1=comp_energy(p,1.0);
  E_0=comp_energy(p,0.0);
  /*  E_neg_infty=comp_energy(p,-100.0);*/
  
  sprintf(msgbuf,"'Energy' for packing:\n   (associated with "
	  "distribution of circle centers on the sphere) ");
  msg();
  sprintf(msgbuf,"s= -1: %f",E_neg_1);
  msg();
  sprintf(msgbuf,"s=  0: %f",E_0);
  msg();
  sprintf(msgbuf,"s=  1: %f",E_1);
  msg();
  sprintf(msgbuf,"min spherical distance: %f",comp_min_dist(p));
  msg();
  /*  sprintf(msgbuf,"s= -infty: %f",E_neg_infty);
      msg();*/
	
  return (1);
}/* print_energy */

double comp_energy(struct p_data *p,double s)
{
  int i,j;
  double d,ds,sum=0.0;
     
  if(fabs(s)>0)   
    {
      for(i=1;i<p->nodecount;i++)
	{
	  for(j=i+1;j<=p->nodecount;j++)
	    {
	      d=R3_dist(p->packR_ptr[i].center,
			p->packR_ptr[j].center);
	      ds=pow(d,s);
	      sum=sum+ds;
	    }
	}
    }
  else /* log energy */
    {
      for(i=1;i<p->nodecount;i++)
	{
	  for(j=i+1;j<=p->nodecount;j++)
	    {
	      d=R3_dist(p->packR_ptr[i].center,
			p->packR_ptr[j].center);
	      ds=log(1.0/d);
	      sum=sum+ds;
	    }
	} 
    }
  
  return(sum);
} /* comp_energy */ 

double comp_min_dist(struct p_data *p)
{
  int i,j;
  double d,min_s_dist=5.0;

  if (p->hes<=0) return 0;
  for (i=1;i<p->nodecount;i++)
    {
      for(j=i+1;j<=p->nodecount;j++)
	{
	  d=s_dist(p->packR_ptr[i].center,
		    p->packR_ptr[j].center);
	  min_s_dist=(d<min_s_dist) ? d : min_s_dist;
	}
    }
  return min_s_dist;
} /* comp_min_dist */



