#include "cp_types.h"
#include "cp_proto.h"

/* Given vertex seed v0 in simply connected complex and number n>1,
want the smallest simply connected sub-complex which contains v0
and all vertices up to and including generation n. May need to avoid
'green' verts (eg., those already included in some other complex). 
Main difficulty is filling in "holes" formed by higher generation 
vertices -- inclusions; this is handled by simplify_redchain. */

struct RedList *build_gen_redlist(struct p_data *p,int seed,
				  int *vec_seed,int gen,int *count)
/* Given seed and number gen>1, find red chain enclosing 
smallest simply connected sub-complex containing vertices up to 
and including generation gen from seed, but stopping at v if v 
is 'green', meaning vec_seed[v]<0. count is set by call to 
label_seed_generations. */
{
  int i,j,k,num,*gen_list,*gen_numbers,keep_vert,dum;
  int debug=0,out_vert=1,tick=0;
  int last_vert=0,gen_count=0,min_gen,cgen,cvert,n,v;
  struct Vertlist *dum_fdo=NULL;
  struct RedList *redlist=NULL,*rtrace,*keep_ptr=NULL;
  struct Edgelist *lifeline=NULL,*etrace,*clobber;
  struct K_data *pK_ptr;

  gen_list=label_seed_generations(p,seed,vec_seed,gen-1,&dum,count);
  if (!gen_list || (*count)>=p->nodecount) return NULL; 
       /* nothing/everything?*/
  pK_ptr=p->packK_ptr;

/* set generation gen and above verts and green verts to poison */
  for (i=1;i<=p->nodecount;i++) 
    {
      if (gen_list[i]<=0 || gen_list[i]>=gen) 
	pK_ptr[i].util_flag=-1;
      else pK_ptr[i].util_flag=0;
    }
/* remove any isolated poison verts */
  for (i=1;i<=p->nodecount;i++)
    if (pK_ptr[i].util_flag==-1)
      {
	k=0;
	for (j=0;j<=pK_ptr[i].num;j++) 
	  k+= pK_ptr[pK_ptr[i].flower[j]].util_flag;
	if (!k)
	  {
	    pK_ptr[i].util_flag=0;
	    tick++;
	  }
      }

/* build the redchain and set its data */
  dum_fdo=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  catalog_faces(p);
  
  if (p->rwb_flags) free(p->rwb_flags);
  p->rwb_flags=(int *)calloc((size_t)(p->facecount+1),sizeof(int));
  if (!(redlist=build_redchain(p,seed,dum_fdo)))
    {
      sprintf(msgbuf,"Failed to build redchain.");
      emsg();
      goto BOMB;
    }

if (debug) record_redlist(redlist,p->facecount);

/* We have to make the region inside the redchain simply connected. 
We need a persistent redchain entry and vertex on redchain outer edge
so we don't discard the wrong portions of redchain.

If p is top sphere, we use out_vert (furthest from seed) and lifeline
to it. If top disc, first attempt is to find a bdry vert on redchain
outer edge, otherwise throw lifeline from the vert closest to bdry. */

  keep_vert=0;
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;

  if (p->num_bdry_comp>0)   /* top disc */
    {
      for (i=1;i<=p->nodecount;i++) /* flag bdry verts */
	if (pK_ptr[i].bdry_flag) pK_ptr[i].util_flag=1;
      v=red_share_vert(p,redlist);
      if (pK_ptr[v].bdry_flag)
	{
	  keep_vert=v;
	  keep_ptr=redlist;
	}
      else
	{
	  rtrace=redlist->next;
	  while (rtrace!=redlist)
	    {
	      v=red_share_vert(p,rtrace);
	      if (pK_ptr[v].bdry_flag)
		{
		  keep_vert=v;
		  keep_ptr=rtrace;
		}
	      rtrace=rtrace->next;
	    }
	}
    }
  else  /* top sphere */
    {
      /* find 'out_vert', furthest vert from seed. */
      gen_numbers=label_generations(p,0,&out_vert,&gen_count);
      free(gen_numbers);
      pK_ptr[out_vert].util_flag=1; /* flag out_vert */
      if ((v=red_share_vert(p,redlist))==out_vert)
	{
	  keep_vert=v;
	  keep_ptr=redlist;
	}
      else
	{
	  rtrace=redlist->next;
	  while (rtrace!=redlist)
	    {
	      if ((v=red_share_vert(p,rtrace)) == out_vert)
		{
		  keep_vert=v;
		  keep_ptr=rtrace;
		}
	      rtrace=rtrace->next;
	    }
	}
    }

  if (!keep_vert) /* have to establish a lifeline */
    {
      /* determine distance of points from the flagged vert(s) */
      gen_numbers=label_generations(p,-1,&last_vert,&gen_count);
      /* find vert on redchain outer edge closest to the flagged vert(s) */
      keep_vert=red_share_vert(p,redlist);
      keep_ptr=redlist;
      min_gen=gen_numbers[keep_vert];
      
      rtrace=redlist->next;
      while (rtrace!=redlist)
	{
	  n=red_share_vert(p,rtrace);
	  if (gen_numbers[n]<min_gen)
	    {
	      keep_vert=n;
	      keep_ptr=rtrace;
	      min_gen=gen_numbers[n];
	    }
	  rtrace=rtrace->next;
	}
      /* build lifeline */
     
      cvert=keep_vert;
      cgen=gen_numbers[cvert];
      lifeline=etrace=(struct Edgelist *)
	calloc((size_t)1,sizeof(struct Edgelist));
      do
	{
	  num=pK_ptr[cvert].num;
	  for (j=0;j<=num;j++)
	    {
	      k=pK_ptr[cvert].flower[j];
	      if (gen_numbers[k]<cgen)
		{
		  etrace->next=(struct Edgelist *)
		    calloc((size_t)1,sizeof(struct Edgelist));
		  etrace=etrace->next;
		  etrace->v=cvert;
		  cvert=etrace->w=k;
		  cgen=gen_numbers[k];
		  j=num+1;
		}
	    }
	} while (!pK_ptr[cvert].util_flag);
      clobber=lifeline; /* first one is empty */
      lifeline=lifeline->next;
      free(clobber);
      free(gen_numbers);
    }

  /* set redlist to start at persistent entry, then process red 
     chain to remove inclusions */

  redlist=keep_ptr;
  if (!simplify_redchain(p,&redlist,lifeline,keep_vert,keep_ptr)) 
    {
      sprintf(msgbuf,"Failed to simplify properly.");
      emsg();
      goto BOMB;
    }
  edge_free(&lifeline);
  destroy_catalog(p->nodecount);
  return redlist;

 BOMB:
  destroy_catalog(p->nodecount);
  free(gen_list);
  if (redlist) free(redlist);
  if (dum_fdo) free(dum_fdo);
  if (lifeline) edge_free(&lifeline);
  return NULL;
} /* build_gen_redlist */
