#ifndef H_CDW_BUTTON
#define H_CDW_BUTTON

#include "main.h"
#include "cdw_widgets.h"
#include "cdw_ncurses.h"


typedef struct {

	cdw_widget_t widget;

	WINDOW *parent; /* parent window of the widget */
	WINDOW *strip;  /* a private window in which the widget displays its content */

	cdw_form_widget_function_t on_click_callback;
	int on_click_key;

	int begin_x;
	int begin_y;

	char *label;

	cdw_colors_t colors;

} CDW_BUTTON;



CDW_BUTTON *cdw_button_new(WINDOW *parent, int begin_y, int begin_x, const char *label, cdw_colors_t colors);
void cdw_button_delete(CDW_BUTTON **button);
void cdw_button_free(CDW_BUTTON *button);
void cdw_button_focus(CDW_BUTTON *button);
void cdw_button_unfocus(CDW_BUTTON *button);
int  cdw_button_driver(CDW_BUTTON *button, void *data);


#endif /* ifndef H_CDW_BUTTON */
