#ifndef H_CDW_FILE_SELECTOR
#define H_CDW_FILE_SELECTOR





#include <stdbool.h>

#include "main.h"
#include "cdw_ncurses.h"
#include "cdw_fs_browser.h"





struct cdw_file_selector_s;
typedef struct cdw_file_selector_s cdw_file_selector_t;


struct cdw_file_selector_s {

	cdw_widget_t widget;

	/* Path to file/directory that will initially be displayed
	   when file selector is opened. */
	char *initial_fullpath;

	/* Is this the first time during lifetime of this data
	   structure/widget that it will be displayed in a window?
	   File selector may be shown/hidden multiple times between
	   creating it with _new() and destroying with _delete(). */
	bool first_selection;

	/* File system browser. It uses a window declared below. */
	cdw_fs_browser_t *fs_browser;

	/* Window in which a file system browser's list of files is
	   displayed. */
	WINDOW *window;

	/* Title of window in which a file system browser is
	   displayed. */
	char *title;

	/* Code using file selector may need to process navigation keys. */
	bool return_on_navigation_keys;
};





cdw_file_selector_t *cdw_file_selector_new(void);
void                 cdw_file_selector_delete(cdw_file_selector_t **selector);
cdw_rv_t             cdw_file_selector_show(cdw_file_selector_t *selector,
					    WINDOW *parent,
					    int n_lines, int n_cols, int begin_y, int begin_x,
					    chtype colors,
					    char const *title,
					    char const *fullpath);
void                 cdw_file_selector_hide(cdw_file_selector_t *selector);
int                  cdw_file_selector_driver(cdw_file_selector_t *selector);
void                 cdw_file_selector_refresh(cdw_file_selector_t *selector);

void cdw_file_selector_update_window_decoration(cdw_file_selector_t *selector);





#endif /* H_CDW_FILE_SELECTOR */
